/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.GenericDsigCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;

public class VerificationCertState
extends GenericDsigCertState {
    private static final long serialVersionUID = 20050515L;

    public VerificationCertState(Tasklet value) {
        super(value);
        this.certType = CertificateTypes.ValidTypes.dsigVerificationCert;
        this.setMenuName("Signature Verification Certificate");
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        List activeVerificationCerts = this.connection.getDsigVerificationCerts().getActiveVerificationCerts();
        this.activeCertificatesTableRows = new ArrayList();
        this.setInactiveCerts(new HashSet<Cert>(this.connection.getDsigVerificationCerts().getAllVerificationCerts()));
        for (Cert cert : activeVerificationCerts) {
            this.activeCertificatesTableRows.add(new TableRow(Collections.singletonList(new GenericDsigCertState.CertFieldItem((SimpleFieldDescriptor)this.ACTIVE_CERTIFICATE, cert.getDescriptionForDisplay(35)))));
            this.getInactiveCerts().remove(cert);
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.certRequired && this.getActiveCerts().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Cert_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        int index = 1;
        for (Cert cert : this.getActiveCerts()) {
            summaryList.add(new SummaryInfo(String.format("Active Certificate %d", index++), cert.getDescriptionForDisplay(), this));
        }
        if (this.isIncludeKeyInfoVisible()) {
            summaryList.add(new SummaryInfo(this.getMessage("IncludeKeyInfo"), Boolean.toString(this.isIncludeKeyInfo()), this));
        }
        if (this.isIncludeKeyValueVisible()) {
            summaryList.add(new SummaryInfo(this.getMessage("IncludeKeyValue"), Boolean.toString(this.isIncludeKeyValue()), this));
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        tempConnection.getDsigVerificationCerts().setActiveVerificationCerts(new ArrayList<Cert>(this.getActiveCerts()));
        return true;
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.refreshInUseCertsParent(tasklet.getDsigVerificationCerts());
        this.activeCertificatesTableRows = new ArrayList();
        for (Cert cert : this.getConnectionCerts().getActiveVerificationCerts()) {
            this.activeCertificatesTableRows.add(new TableRow(Collections.singletonList(new GenericDsigCertState.CertFieldItem((SimpleFieldDescriptor)this.ACTIVE_CERTIFICATE, cert.getDescriptionForDisplay(35)))));
        }
    }

    @Override
    public boolean isShowMultiCertSelection() {
        return true;
    }

    @Override
    public LinkedHashSet<Cert> getActiveCerts() {
        Map<String, Cert> verificationCerts = this.getConnectionCerts().getAllVerificationCerts().stream().collect(Collectors.toMap(cert -> cert.getDescriptionForDisplay(35), cert -> cert));
        return this.getActiveCertificatesTableRows().stream().filter(row -> !row.isMarkedForDelete()).map(row -> (Cert)verificationCerts.get(row.getFields().get(0).getValue())).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<Cert> getInactiveCerts() {
        Set inactiveCerts = this.getConnectionCerts().getAllVerificationCerts();
        inactiveCerts.removeAll(this.getActiveCerts());
        return inactiveCerts;
    }

    public void metaDataReset() {
        ConnectionCerts dsigVerificationCerts = this.connection.getDsigVerificationCerts();
        List activeVerificationCerts = dsigVerificationCerts.getActiveVerificationCerts();
        this.activeCertificatesTableRows = new ArrayList();
        this.setInactiveCerts(new HashSet<Cert>(dsigVerificationCerts.getAllVerificationCerts()));
        for (Cert cert : activeVerificationCerts) {
            this.activeCertificatesTableRows.add(new TableRow(Collections.singletonList(new GenericDsigCertState.CertFieldItem((SimpleFieldDescriptor)this.ACTIVE_CERTIFICATE, cert.getDescriptionForDisplay(35)))));
            this.getInactiveCerts().remove(cert);
        }
        this.refreshInUseCertsParent(dsigVerificationCerts);
    }

    private void refreshInUseCertsParent(ConnectionCerts connectionCerts) {
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        if (iuca != null) {
            iuca.setDsigConnectionCerts(connectionCerts);
        }
    }
}

