/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.WsfedJwtSigningAlgorithms;
import com.pingidentity.fsm.state.impl.SigningCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.form.IPropertySelectionModel;

public class WsFedJwtSigningCertState
extends SigningCertState {
    private static final long serialVersionUID = 1L;

    public WsFedJwtSigningCertState(Tasklet value) {
        super(value);
    }

    @Override
    public boolean isIncludeKeyInfoVisible() {
        return false;
    }

    @Override
    public void setIncludeKeyInfoVisible(boolean includeKeyInfoVisible) {
    }

    @Override
    public boolean isIncludeKeyValueVisible() {
        return false;
    }

    @Override
    protected IPropertySelectionModel getSigningAlgModel(String prefix) {
        StringPairPropertySelectionModel model;
        block3: {
            block2: {
                model = new StringPairPropertySelectionModel();
                if (!prefix.equals("RSA")) break block2;
                for (Map.Entry entry : WsfedJwtSigningAlgorithms.getRSAalg2NameMap().entrySet()) {
                    model.add((String)entry.getValue(), entry.getKey());
                }
                break block3;
            }
            if (!prefix.equals("EC")) break block3;
            for (Map.Entry entry : WsfedJwtSigningAlgorithms.getECalg2NameMap().entrySet()) {
                model.add((String)entry.getValue(), entry.getKey());
            }
        }
        return model;
    }

    @Override
    public Set<KeyAlgorithmFilter> getKeyAlgorithmFilter() {
        HashSet<KeyAlgorithmFilter> algFilters = new HashSet<KeyAlgorithmFilter>();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.RSA).setMinPublicKeySize(2048).build());
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.EC).build());
        return algFilters;
    }

    @Override
    protected String getSelectedSigningAlgTypeForSummary() {
        return (String)WsfedJwtSigningAlgorithms.getAlg2NameMap().get(this.selectedSigningAlgType);
    }

    @Override
    protected void setDefaultSigningAlgOnNewKeyType(String newKeyAlg) {
    }
}

