/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.state.impl.UrlWhitelistState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.wsfed.domain.ConnectionFactory;
import org.sourceid.wsfed.domain.WSFedConnectionWrapper;

public class WsFedServiceUrlState
extends UrlWhitelistState {
    private static final long serialVersionUID = 20050515L;
    private LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> messageHooks = new LinkedHashMap();
    private String endpoint;
    private boolean showAdvanced;
    private final boolean allowAdvanced;
    private Map<String, String> name2ContextMap;
    private final StringPairPropertySelectionModel hookTypes = new StringPairPropertySelectionModel();
    private boolean isEditingHook;
    private String selectedHookType;
    private String selectedHookExpr;
    private String linkContextName;

    public WsFedServiceUrlState(Tasklet parent, boolean allowAdvanced) {
        super(parent);
        this.setMenuName("Service URL");
        this.allowAdvanced = allowAdvanced;
        this.name2ContextMap = allowAdvanced ? MessageCustomizationCard.getVarNameToContextMap(true, false) : null;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (this.allowAdvanced && this.hookTypes.getOptionCount() == 0) {
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        WSFedConnectionWrapper connWrapper = ConnectionFactory.getWrapper((ConnectionBase)connection);
        this.endpoint = connWrapper.getWsFedEndpointUrl();
        if (this.getAllowAdvanced()) {
            this.showAdvanced = false;
            this.isEditingHook = false;
            this.selectedHookType = null;
            this.selectedHookExpr = null;
            this.linkContextName = null;
            this.messageHooks.clear();
            MessageCustomizationCard.populateMsgHooks(connection, this.name2ContextMap, this.messageHooks);
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        WSFedConnectionWrapper connWrapper = ConnectionFactory.getWrapper((ConnectionBase)tempConnection);
        connWrapper.setWsFedEndpointUrl(this.endpoint);
        if (this.getAllowAdvanced() && this.getCurrentUser().isExpressionAdmin()) {
            MessageCustomizationCard.saveMsgHooks(tempConnection, this.name2ContextMap, this.messageHooks);
        }
        return super.save(dataToDisk);
    }

    @Override
    public void reset() {
        this.endpoint = null;
        this.messageHooks.clear();
        this.showAdvanced = false;
        this.isEditingHook = false;
        this.selectedHookType = null;
        this.selectedHookExpr = null;
        this.linkContextName = null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.endpoint)) {
            delegate.record(this.getMessage("Url_required"), ValidationConstraint.REQUIRED);
        }
        if (!delegate.getHasErrors() && !ValidationUtil.isValidUrl((String)this.endpoint)) {
            if (this.findParent(ConnectionTasklet.class).isBaseUrlConfigured()) {
                if (!ValidationUtil.startsWithForwardSlash((String)this.endpoint)) {
                    delegate.record(this.getMessage("Endpoint_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                }
            } else if (ValidationUtil.isValidUri((String)this.endpoint)) {
                delegate.record(this.getMessage("Relative_urls_but_no_base"), ValidationConstraint.URL_FORMAT);
            } else {
                delegate.record(this.getMessage("Malformed_url"), ValidationConstraint.URL_FORMAT);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Endpoint URL", this.endpoint, this));
        super.doSummary(summaryList);
        if (this.getAllowAdvanced()) {
            for (MessageCustomizationCard.MessageHookEntry msgHookEntry : this.getMessageHooks().values()) {
                if (msgHookEntry.isDeleted()) continue;
                String msg = "Expression for variable '" + msgHookEntry.getName() + "'";
                summaryList.add(new SummaryInfo(this.getMessage("message_customization"), msg, this));
            }
        }
    }

    public void setEndpoint(String ep) {
        this.endpoint = ep;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean isShowWhitelistTable() {
        return this.getRole() == Role.SP || targetResourceValidationMgr.isEnableValidationWreplySLO();
    }

    public String getWhitelistTableMsg() {
        if (this.getRole() == Role.SP) {
            return "You can specify additional allowed domains and paths below. This whitelist will also be used to validate wreply for SLO, if enabled under Security > System Integration > Redirect Validation.";
        }
        return "For incoming SLO cleanup messages, your partner may specify a redirect location via the wreply parameter. You can define allowed values for this parameter below.";
    }

    private Role getRole() {
        return this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.IDP ? Role.IDP : Role.SP;
    }

    public boolean getShowAdvanced() {
        return this.showAdvanced;
    }

    public void setShowAdvanced(boolean adv) {
        this.showAdvanced = adv;
    }

    public boolean isEditMode() {
        if (this.getAllowAdvanced()) {
            for (MessageCustomizationCard.MessageHookEntry entry : this.getMessageHooks().values()) {
                if (!entry.isEditing()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getAllowAdvanced() {
        return this.allowAdvanced && ExpressionManager.getInstance().isEvaluateExpressionsOn();
    }

    public LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks() {
        return this.messageHooks;
    }

    public Map<String, String> getName2ContextMap() {
        return this.name2ContextMap;
    }

    public boolean getIsEditingHook() {
        return this.isEditingHook;
    }

    public void setIsEditingHook(boolean editing) {
        this.isEditingHook = editing;
    }

    public StringPairPropertySelectionModel getHookTypes() {
        return this.hookTypes;
    }

    public String getSelectedHookType() {
        return this.selectedHookType;
    }

    public void setSelectedHookType(String selectedHookType) {
        this.selectedHookType = selectedHookType;
    }

    public String getSelectedHookExpression() {
        return this.selectedHookExpr;
    }

    public void setSelectedHookExpression(String selectedHookExpr) {
        this.selectedHookExpr = selectedHookExpr;
    }

    public String getLinkContextName() {
        return this.linkContextName;
    }

    public void setLinkContextName(String linkName) {
        this.linkContextName = linkName;
    }

    public void updateKeyContext(boolean isWsFedJwt) {
        if (isWsFedJwt && this.allowAdvanced) {
            this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(true, false);
            this.name2ContextMap.remove("AssertionType");
        } else {
            this.name2ContextMap = this.allowAdvanced ? MessageCustomizationCard.getVarNameToContextMap(true, false) : null;
        }
    }

    public boolean isEaOrHasCustomisation() {
        return this.getCurrentUser().isExpressionAdmin() || !this.messageHooks.isEmpty();
    }
}

