/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapFilterState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;

public class WsTrustConfigLdapFilterState
extends ConfigLdapFilterState {
    private static final long serialVersionUID = 2L;

    public WsTrustConfigLdapFilterState(Tasklet parent, String cardName) {
        super(parent, cardName);
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping targetAttrMapping = (TokenPluginAttributeMapping)dataFromDisk;
        AttributeSource source = targetAttrMapping.getAttributeMapping().getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        this.filter = this.origFilter = source.getParameter("filter");
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi parentTasklet = (AttributeSourceApi)((Object)this.getParent());
        LdapDataSource tempDataSource = (LdapDataSource)parentTasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
            this.dataSource = tempDataSource;
            this.origFilter = new String("");
            this.filter = new String("");
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping mapping = (TokenPluginAttributeMapping)dataToDisk;
        AttributeSource source = mapping.getAttributeMapping().getAttributeSource();
        source.setParameter("filter", this.filter);
        return true;
    }

    @Override
    public List<String> getValues() {
        Tasklet parentTasklet = this.getParent();
        if (parentTasklet instanceof WsTrustTokenGeneratorMappingTasklet) {
            return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
        }
        return Collections.emptyList();
    }

    @Override
    public String getValueText() {
        if (this.getParent() instanceof WsTrustTokenGeneratorMappingTasklet) {
            return this.getIsOidc() ? "Provider Claims" : "Assertion Values";
        }
        return super.getValueText();
    }

    @Override
    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public boolean isShowPluginValues() {
        return !this.getValues().isEmpty();
    }
}

