/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustIdpTasklet;
import java.util.Collection;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;

public class WsTrustIdpState
extends SingleTaskletState
implements NeededCredentialsApi {
    private static final long serialVersionUID = 1L;
    private WsTrustFederatedWspSettings wsTrustSettings;
    private Object populateAllStatesData;

    public WsTrustIdpState(Tasklet value) {
        super(value);
        this.setMenuName("WS-Trust STS");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.wsTrustSettings = ((IdpConnection)dataFromDisk).getWsTrustSettings();
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = ((IdpConnection)data).getWsTrustSettings();
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        WsTrustIdpTasklet tasklet = this.getTaskletToEdit(WsTrustIdpTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(WsTrustIdpTasklet.class);
            tasklet.configureTasklet();
            if (this.wsTrustSettings != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.wsTrustSettings);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean userHasEnteredSubflow = true;
        Collection<TaskletState> states = this.getTaskletToEdit().getStateList();
        for (TaskletState state : states) {
            if (state.isItClickable()) continue;
            userHasEnteredSubflow = false;
            break;
        }
        if (!userHasEnteredSubflow) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Wstrust_not_configured"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connectionToDisk = (IdpConnection)dataToDisk;
        connectionToDisk.setWsTrustSettings(new WsTrustFederatedWspSettings());
        return super.save(connectionToDisk.getWsTrustSettings());
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isBackChannelAuthenticationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureVerificationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureNeeded() : false;
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isEncryptionCertificateNeeded() : false;
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDecryptionKeyNeeded() : false;
    }
}

