/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.impl.WsTrustRequestContractTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

@AutoSaveState
public class WsTrustManageRequestContractsState
extends TaskletListState {
    private static final long serialVersionUID = 1L;

    public WsTrustManageRequestContractsState(Tasklet value) {
        super(value);
        this.setMenuName("Manage Request Contracts");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        this.buildTaskletList();
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        Tasklet tasklet = this.getTasklet(taskletToDelete);
        tasklet.setItDeleted(true);
        WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
        WsTrustRequestContract requestContract = new WsTrustRequestContract();
        tasklet.save(requestContract);
        requestContractManager.delete(requestContract);
    }

    public boolean isRequestContractIdInUse(String contractId) {
        List<Tasklet> tasklets = this.getTasklets();
        for (Tasklet tasklet : tasklets) {
            WsTrustRequestContractTasklet requestContractTasklet = (WsTrustRequestContractTasklet)tasklet;
            if (contractId == null || !contractId.equals(requestContractTasklet.getRequestContractId())) continue;
            return true;
        }
        return false;
    }

    public boolean isRequestContractNameInUse(String contractName) {
        List<Tasklet> tasklets = this.getTasklets();
        for (Tasklet tasklet : tasklets) {
            WsTrustRequestContractTasklet requestContractTasklet = (WsTrustRequestContractTasklet)tasklet;
            if (contractName == null || !contractName.equals(requestContractTasklet.getRequestContractName())) continue;
            return true;
        }
        return false;
    }

    private void buildTaskletList() {
        WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
        Collection requestContracts = requestContractManager.findAll();
        for (WsTrustRequestContract requestContract : requestContracts) {
            WsTrustRequestContractTasklet tasklet = this.createTasklet(WsTrustRequestContractTasklet.class);
            tasklet.setMode(this.getParent().getMode());
            tasklet.populate(requestContract);
            this.addTasklet(tasklet);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        int counter = 1;
        for (Tasklet tasklet : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (tempDelegate.getHasErrors()) {
                WsTrustRequestContractTasklet t = (WsTrustRequestContractTasklet)tasklet;
                Object[] objects = new Object[1];
                String requestContractId = t.getRequestContractId();
                String requestContractName = t.getRequestContractName();
                objects[0] = !StringUtils.isBlank((String)requestContractId) ? requestContractId : (!StringUtils.isBlank((String)requestContractName) ? requestContractName : "Contract #" + String.valueOf(counter));
                delegate.record(this.getMessage("Instance_has_errors", objects), ValidationConstraint.REQUIRED);
            }
            ++counter;
        }
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (taskletToEdit instanceof WsTrustRequestContractTasklet) {
            super.setTaskletToEdit(taskletToEdit);
        }
    }

    public void resetSaveCalledForAll() {
        for (Tasklet t : this.getTasklets()) {
            WsTrustRequestContractTasklet tasklet = (WsTrustRequestContractTasklet)t;
            tasklet.setSaveCalled(false);
        }
    }

    public boolean isEnableAutomaticConnectionValidation() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isDisableAutomaticConnectionValidation();
    }
}

