/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.WsTrustRestrictByState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustListUIEntry;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class WsTrustRestrictByCertState
extends WsTrustRestrictByState {
    private static final long serialVersionUID = 2L;
    public static final String FEATURE_NAME = "STS Settings Mutual SSL Authentication Certs";

    public WsTrustRestrictByCertState(Tasklet value) {
        super(value);
        this.setMenuName("Allowed Issuer Certificates");
        this.setCertType(CertificateTypes.ValidTypes.wsTrustDsigVerificationCert);
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataToDisk;
        ConnectionCerts connectionCerts = this.getConnectionCerts();
        Set allVerificationCertsToSave = connectionCerts.getAllVerificationCerts();
        PkCertAndConnectionCertManager certManager = this.getCertManager();
        if (allVerificationCertsToSave != null && !allVerificationCertsToSave.isEmpty()) {
            certManager.saveCertsForFeature(allVerificationCertsToSave, FEATURE_NAME);
        }
        Set<Cert> certsFromKeystore = this.getKeystoreCertsWithFeatureId();
        ArrayList<String> aliases = new ArrayList<String>();
        for (WsTrustListUIEntry entry : this.listEntries) {
            for (Cert cert : certsFromKeystore) {
                if (!this.certsMatch(cert, entry)) continue;
                aliases.add(cert.getAlias());
            }
        }
        if (!aliases.isEmpty()) {
            wsTrustData.setAcceptableIssuerCertAliases(aliases);
        }
        return true;
    }

    private boolean certsMatch(Cert cert, WsTrustListUIEntry entry) {
        String alias = entry.getCert().getAlias();
        if (!StringUtils.isBlank((String)alias) && alias.equals(cert.getAlias())) {
            return true;
        }
        return cert.getDescriptionForDisplay().equals(entry.getEntry());
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setSelectedCert(tasklet.getSelectedCert());
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        iuca.setDsigConnectionCerts(tasklet.getDsigVerificationCerts());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        List<WsTrustListUIEntry> listEntries = this.getListEntries();
        if (listEntries == null || listEntries.isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("At_least_one_issuer_cert"), ValidationConstraint.REQUIRED);
        } else {
            for (WsTrustListUIEntry entry : listEntries) {
                if (entry.isCertExpired()) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Cert_expired", new Object[]{entry.getEntry()}), ValidationConstraint.REQUIRED);
                }
                if (!entry.isKnownToBeRevoked()) continue;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Cert_revoked", new Object[]{entry.getEntry()}), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getListEntries() != null && !this.getListEntries().isEmpty()) {
            for (WsTrustListUIEntry entry : this.getListEntries()) {
                summaryList.add(new SummaryInfo("Issuer Certificate", entry.getEntry(), this));
            }
        }
    }

    @Override
    protected void loadState(WsTrustStsData wsTrustData) {
        this.listEntries = this.getEntryList(wsTrustData);
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        ConnectionCerts dsigConnectionCerts = iuca.getDsigConnectionCerts();
        dsigConnectionCerts.setVerificationCerts(null, this.getCertsForCertManagement());
        LinkedHashSet<Cert> activeCerts = new LinkedHashSet<Cert>();
        activeCerts.addAll(this.getListEntryCerts(this.listEntries));
        this.setActiveCerts(activeCerts);
        HashSet<Cert> inactiveCerts = new HashSet<Cert>();
        inactiveCerts.addAll(this.getKeystoreCertsWithFeatureId());
        inactiveCerts.removeAll(activeCerts);
        this.setInactiveCerts(inactiveCerts);
    }

    private Set<Cert> getCertsForCertManagement() {
        HashSet<Cert> certs = new HashSet<Cert>();
        certs.addAll(this.getListEntryCerts(this.listEntries));
        certs.addAll(this.getKeystoreCertsWithFeatureId());
        return certs;
    }

    private Set<Cert> getListEntryCerts(List<WsTrustListUIEntry> entryList) {
        HashSet<Cert> certs = new HashSet<Cert>();
        for (WsTrustListUIEntry entry : entryList) {
            certs.add(entry.getCert());
        }
        return certs;
    }

    private List<WsTrustListUIEntry> getEntryList(WsTrustStsData wsTrustData) {
        ArrayList<WsTrustListUIEntry> entryList = new ArrayList<WsTrustListUIEntry>();
        List<String> xmlFileEntries = wsTrustData.getAcceptableIssuerCertAliases();
        for (String alias : xmlFileEntries) {
            for (Cert cert : this.getKeystoreCertsWithFeatureId()) {
                if (!cert.getAlias().equals(alias)) continue;
                WsTrustListUIEntry entry = new WsTrustListUIEntry();
                entry.setEntry(cert.getDescriptionForDisplay());
                entry.setCert(cert);
                entryList.add(entry);
            }
        }
        return entryList;
    }

    private Set<Cert> getKeystoreCertsWithFeatureId() {
        PkCertAndConnectionCertManager mgr = this.getCertManager();
        return mgr.getCertsForFeature(FEATURE_NAME);
    }

    public PkCertAndConnectionCertManager getCertManager() {
        return (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
    }

    public ConnectionCerts getConnectionCerts() {
        return this.findParent(InUseCertsApi.class).getDsigConnectionCerts();
    }

    public void setConnectionCerts(ConnectionCerts certs) {
        this.findParent(InUseCertsApi.class).setDsigConnectionCerts(certs);
    }

    public String getIssuerCertsStr() {
        ArrayList<String> l = new ArrayList<String>();
        for (WsTrustListUIEntry entry : this.getListEntries()) {
            if (!entry.isActive()) continue;
            l.add(entry.getEntry());
        }
        return Util.listToCommaDelimString(l);
    }

    public boolean hasAtLeastOneEntry() {
        List<WsTrustListUIEntry> listEntries = this.getListEntries();
        return listEntries != null && !listEntries.isEmpty();
    }
}

