/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSystemAuthTasklet;
import java.util.ArrayList;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.common.Util;

public class WsTrustSelectStsSystemAuthState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private boolean enableHttpBasic;
    private boolean enableSsl;

    public WsTrustSelectStsSystemAuthState(Tasklet value) {
        super(value);
        this.setMenuName("Authentication Methods");
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataFromDisk;
        this.enableHttpBasic = wsTrustData.isBasicAuthnEnabled();
        this.enableSsl = wsTrustData.isClientCertAuthnEnabled();
        return true;
    }

    @Override
    public void cancel(Object data) {
        this.populateAllStates(data);
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataToDisk;
        wsTrustData.setBasicAuthnEnabled(this.enableHttpBasic);
        wsTrustData.setClientCertAuthnEnabled(this.enableSsl);
        return true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        WsTrustStsSystemAuthTasklet t = (WsTrustStsSystemAuthTasklet)this.getParent();
        if (this.enableHttpBasic) {
            t.setHttpBasicAuthBreadcrumbs();
        }
        if (this.enableSsl) {
            t.setSslAuthBreadcrumb();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Enable_http_basic_summary"), Boolean.toString(this.enableHttpBasic), this));
        summaryList.add(new SummaryInfo(this.getMessage("Enable_ssl_summary"), Boolean.toString(this.enableSsl), this));
    }

    public boolean isEnableHttpBasic() {
        return this.enableHttpBasic;
    }

    public void setEnableHttpBasic(boolean enableHttpBasic) {
        this.enableHttpBasic = enableHttpBasic;
    }

    public boolean isEnableSsl() {
        return this.enableSsl;
    }

    public void setEnableSsl(boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    public String getAuthnMethodsStr() {
        ArrayList<String> methods = new ArrayList<String>();
        if (this.enableHttpBasic) {
            methods.add(this.getMessage("Enable_http_basic_summary"));
        }
        if (this.enableSsl) {
            methods.add(this.getMessage("Enable_ssl_summary"));
        }
        if (!this.enableHttpBasic && !this.enableSsl) {
            methods.add("None");
        }
        return Util.listToCommaDelimString(methods);
    }
}

