/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;

public class WsTrustSelectTokenGeneratorState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private transient TokenPluginInstance selectedTokenGenerator;
    private transient TokenPluginInstance connectionOverrideInstance;
    private String selectedTokenGeneratorId;
    private List<String> attributeList;
    private boolean newTokenGenerator = true;
    private boolean overrideAdapterConnectionSettings;

    public WsTrustSelectTokenGeneratorState(Tasklet value) {
        super(value);
        this.setMenuName("Token Generator Instance");
    }

    @Override
    public void initialize() {
        this.createTokenGeneratorAttributeList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping attributeMappingFromDisk = (TokenPluginAttributeMapping)dataFromDisk;
        String pluginId = attributeMappingFromDisk.getPluginId();
        TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
        this.selectedTokenGenerator = (TokenPluginInstance)tokenGeneratorManager.getInstance(pluginId);
        if (this.selectedTokenGenerator != null) {
            this.selectedTokenGeneratorId = this.selectedTokenGenerator.getId();
            this.connectionOverrideInstance = attributeMappingFromDisk.getConnectionOverrideInstance();
            this.setOverrideAdapterConnectionSettings(this.selectedTokenGenerator.isConnectionBasedPlugin());
        }
        this.populate();
        this.getParent().reconfigureTransitions(this);
        this.newTokenGenerator = false;
    }

    private void populate() {
        this.createTokenGeneratorAttributeList();
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping attributeMappingToDisk = (TokenPluginAttributeMapping)dataToDisk;
        attributeMappingToDisk.setPluginId(this.selectedTokenGenerator.getId());
        AttributeMapping attrMapping = new AttributeMapping();
        attributeMappingToDisk.setAttributeMapping(attrMapping);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
        this.selectedTokenGenerator = null;
        this.selectedTokenGeneratorId = null;
        this.attributeList = null;
        this.newTokenGenerator = true;
    }

    @Override
    public void onResumeDraft() {
        if (this.selectedTokenGenerator == null && this.selectedTokenGeneratorId != null) {
            this.selectedTokenGenerator = (TokenPluginInstance)MgmtFactory.getTokenGeneratorManager().getInstance(this.selectedTokenGeneratorId);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedTokenGenerator == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("You_must_select_a_token_generator"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.selectedTokenGenerator = (TokenPluginInstance)MgmtFactory.getTokenGeneratorManager().getInstance(this.selectedTokenGeneratorId);
        this.populate();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedTokenGenerator != null) {
            if (this.isOverrideSettingUnchecked()) {
                PluginMappingApi pluginMappingApi = (PluginMappingApi)((Object)this.getParent());
                TokenPluginInstance selectedGenerator = this.getSelectedTokenGenerator();
                TokenPluginInstance parentGenerator = (TokenPluginInstance)((TokenGeneratorManager)GlobalRegistry.getService(TokenGeneratorManager.class)).getInstance(selectedGenerator.getParentId());
                this.setSelectedTokenGenerator(parentGenerator);
                pluginMappingApi.removeConnectionOverride();
            }
            this.createTokenGeneratorAttributeList();
        } else {
            this.attributeList = null;
        }
        if (this.getTaskletToEdit() != null) {
            this.setTaskletToEditToNull();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Selected_token_generator"), this.selectedTokenGenerator.getName(), this));
    }

    @Override
    public String getNoteKey() {
        if (this.isNewTokenGenerator()) {
            return this.getTaskletStateId() + "New";
        }
        return super.getNoteKey();
    }

    public void createTokenGeneratorAttributeList() {
        TokenPluginInstance instance = this.getSelectedTokenGenerator();
        if (instance != null) {
            PluginMappingApi pluginMappingApi = (PluginMappingApi)((Object)this.getParent());
            if (pluginMappingApi.isOverridePluginPopulated()) {
                this.attributeList = pluginMappingApi.getPluginContract();
            } else {
                instance = pluginMappingApi.isOverridePluginConnectionSettings() && this.connectionOverrideInstance != null ? this.connectionOverrideInstance : this.getSelectedTokenGenerator();
                AttributeContract contract = instance.getAttributeContract();
                this.selectedTokenGeneratorId = instance.getId();
                this.attributeList = new ArrayList<String>(contract.getAllAttrNamesSorted());
            }
        }
    }

    public StringPairPropertySelectionModel getTokenGeneratorList() {
        StringPairPropertySelectionModel tokenGeneratorList = new StringPairPropertySelectionModel(true);
        WsTrustTokenGeneratorMappingTasklet wsTrustTokenGeneratorMappingTasklet = (WsTrustTokenGeneratorMappingTasklet)this.getParent();
        List<String> generatorsInUseByConnection = wsTrustTokenGeneratorMappingTasklet.getGeneratorsInUseByConnection();
        ArrayList<ConfigurablePluginInstance> connectionBasedRelatedPlugins = new ArrayList<ConfigurablePluginInstance>();
        TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
        for (ConfigurablePluginInstance pluginInstance : tokenGeneratorManager.getInstances()) {
            String parentId;
            ConfigurablePluginInstance parentInstance;
            boolean generatorInUse = generatorsInUseByConnection.contains(pluginInstance.getId());
            if (generatorInUse && pluginInstance.isConnectionBasedPlugin() && (parentInstance = tokenGeneratorManager.getInstance(parentId = pluginInstance.getParentId())) != null) {
                connectionBasedRelatedPlugins.add(parentInstance);
            }
            if (generatorInUse || pluginInstance.isConnectionBasedPlugin()) continue;
            tokenGeneratorList.add(pluginInstance.getName(), pluginInstance);
        }
        for (ConfigurablePluginInstance instance : connectionBasedRelatedPlugins) {
            tokenGeneratorList.remove(instance.getName());
        }
        return tokenGeneratorList;
    }

    public TokenPluginInstance getSelectedTokenGenerator() {
        return this.selectedTokenGenerator;
    }

    public void setSelectedTokenGenerator(TokenPluginInstance selectedInstance) {
        this.selectedTokenGenerator = selectedInstance;
        this.selectedTokenGeneratorId = this.selectedTokenGenerator != null ? this.selectedTokenGenerator.getId() : null;
    }

    public List<String> getAttributeList() {
        return this.attributeList;
    }

    public boolean isNewTokenGenerator() {
        return this.newTokenGenerator;
    }

    public void setNewTokenGenerator(boolean newTokenGen) {
        this.newTokenGenerator = newTokenGen;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return this.getSelectedTokenGenerator() != null;
    }

    public String getSelectedTokenGeneratorId() {
        return this.selectedTokenGeneratorId;
    }

    public boolean isOverrideAdapterConnectionSettings() {
        return this.overrideAdapterConnectionSettings;
    }

    public void setOverrideAdapterConnectionSettings(boolean overrideAdapterConnectionSettings) {
        PluginMappingApi parent = (PluginMappingApi)((Object)this.getParent());
        parent.removeConnectionOverride();
        this.overrideAdapterConnectionSettings = overrideAdapterConnectionSettings;
    }

    public boolean isOverrideSettingUnchecked() {
        return !this.isOverrideAdapterConnectionSettings() && this.getSelectedTokenGenerator() != null && this.getSelectedTokenGenerator().isConnectionBasedPlugin();
    }
}

