/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.SpWsTrustProtocolSettingsValidator;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;

public class WsTrustSpProtocolSettingsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private SpConnection spConnection;
    private Set<String> appliesToUrls = new TreeSet<String>();
    private boolean holderOfKeyConfirmationMethod;
    private boolean encryptSaml20;
    private boolean enableOAuthSAMLBearer;
    private boolean isEditingAppliesTo = false;
    private String updateAppliesTo;
    private String updateAppliesToOriginalValue;
    private String newAppliesTo;
    private String selectedDefaultTokenType = Saml20SecurityToken.TYPE;
    private Map<String, String> name2ContextMap;
    private final StringPairPropertySelectionModel hookTypes = new StringPairPropertySelectionModel();
    private LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> messageHooks = new LinkedHashMap();
    private boolean isEditingHook;
    private String selectedHookType;
    private String selectedHookExpr;
    private String linkContextName;
    private boolean showAdvanced;

    public WsTrustSpProtocolSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Protocol Settings");
        this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(false, false);
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (this.hookTypes.getOptionCount() == 0) {
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.appliesToUrls.clear();
        for (AppliesTo appliesTo : this.spConnection.getWsTrustSettings().getAppliesTo()) {
            this.appliesToUrls.add(appliesTo.toString());
        }
        this.holderOfKeyConfirmationMethod = this.spConnection.getWsTrustSettings().isUseSamlHoK();
        this.encryptSaml20 = this.spConnection.getWsTrustSettings().isEncryptAssertion();
        this.enableOAuthSAMLBearer = this.spConnection.getWsTrustSettings().isEnableOAuthAssertionProfiles();
        this.selectedDefaultTokenType = this.spConnection.getWsTrustSettings().getTokenType();
        if (this.isExpressionEnabled()) {
            this.showAdvanced = false;
            this.isEditingHook = false;
            this.selectedHookType = null;
            this.selectedHookExpr = null;
            this.linkContextName = null;
            this.messageHooks.clear();
            MessageCustomizationCard.populateMessageHooks(this.name2ContextMap, this.messageHooks, this.spConnection.getWsTrustMessageCustomizationHooks());
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    public boolean isExpressionEnabled() {
        return ExpressionManager.getInstance().isEvaluateExpressionsOn();
    }

    @Override
    public boolean save(Object dataToDisk) {
        SpConnection spConn = (SpConnection)dataToDisk;
        if (!this.appliesToUrls.isEmpty()) {
            HashSet<AppliesTo> convertedAppliesTo = new HashSet<AppliesTo>();
            for (String appliesToStr : this.appliesToUrls) {
                convertedAppliesTo.add(new AppliesTo(appliesToStr));
            }
            spConn.getWsTrustSettings().setAppliesTo(convertedAppliesTo);
        }
        spConn.getWsTrustSettings().setUseSamlHoK(this.holderOfKeyConfirmationMethod);
        spConn.getWsTrustSettings().setEncryptAssertion(this.encryptSaml20);
        spConn.getWsTrustSettings().setEnableOAuthAssertionProfiles(this.enableOAuthSAMLBearer);
        spConn.getWsTrustSettings().setTokenType(this.selectedDefaultTokenType);
        if (this.isExpressionEnabled()) {
            MessageCustomizationCard.saveWsTrustMsgHooks((ConnectionBase)spConn, this.name2ContextMap, this.messageHooks);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        SpWsTrustProtocolSettingsValidator validator;
        if (this.isEditingAppliesTo()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        String connectionId = null;
        if (spConnTasklet.getSpConnection() != null) {
            connectionId = spConnTasklet.getSpConnection().getId();
        }
        if (!(validator = new SpWsTrustProtocolSettingsValidator(connectionId, new ArrayList<String>(this.appliesToUrls))).validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        StringBuffer appliesToStr = new StringBuffer();
        for (String alias : this.appliesToUrls) {
            if (appliesToStr.length() > 0) {
                appliesToStr.append("\n");
            }
            appliesToStr.append(alias);
        }
        summaryList.add(new SummaryInfo(this.getMessage("Partner_service_id_summary"), appliesToStr.toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Enable_oauth_saml_bearer_summary"), new Boolean(this.enableOAuthSAMLBearer).toString(), this));
        String selectedTokenTypeDesc = this.getDefaultTokenTypeList().getDescription(this.selectedDefaultTokenType);
        summaryList.add(new SummaryInfo(this.getMessage("Default_token_type_desc"), selectedTokenTypeDesc, this));
        summaryList.add(new SummaryInfo(this.getMessage("Generate_key_saml_summary"), new Boolean(this.holderOfKeyConfirmationMethod).toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Encrypt_saml_20_summary"), new Boolean(this.encryptSaml20).toString(), this));
        if (this.isExpressionEnabled()) {
            for (MessageCustomizationCard.MessageHookEntry msgHookEntry : this.getMessageHooks().values()) {
                if (msgHookEntry.isDeleted()) continue;
                String msg = "Expression for variable '" + msgHookEntry.getName() + "'";
                summaryList.add(new SummaryInfo(this.getMessage("message_customization"), msg, this));
            }
        }
    }

    @Override
    public void reset() {
        this.appliesToUrls.clear();
        this.holderOfKeyConfirmationMethod = false;
        this.encryptSaml20 = false;
        this.enableOAuthSAMLBearer = false;
        this.messageHooks.clear();
        this.showAdvanced = false;
        this.isEditingHook = false;
        this.selectedHookType = null;
        this.selectedHookExpr = null;
        this.linkContextName = null;
    }

    public Set<String> getAppliesToUrls() {
        return this.appliesToUrls;
    }

    public Set<String> getAppliesToUrlsCopy() {
        Set<String> appliesToUrlsCopy = this.appliesToUrls.stream().collect(Collectors.toSet());
        return appliesToUrlsCopy;
    }

    public void setAppliesToUrls(Set<String> appliesToUrls) {
        this.appliesToUrls = appliesToUrls;
    }

    public boolean isHolderOfKeyConfirmationMethod() {
        return this.holderOfKeyConfirmationMethod;
    }

    public void setHolderOfKeyConfirmationMethod(boolean holderOfKeyConfirmationMethod) {
        this.holderOfKeyConfirmationMethod = holderOfKeyConfirmationMethod;
    }

    public boolean isEncryptSaml20() {
        return this.encryptSaml20;
    }

    public void setEncryptSaml20(boolean encryptSaml20) {
        this.encryptSaml20 = encryptSaml20;
    }

    public boolean isEnableOAuthSAMLBearer() {
        return this.enableOAuthSAMLBearer;
    }

    public void setEnableOAuthSAMLBearer(boolean enableOAuthSAMLBearer) {
        this.enableOAuthSAMLBearer = enableOAuthSAMLBearer;
    }

    public boolean isEditingAppliesTo() {
        return this.isEditingAppliesTo;
    }

    public void setEditingAppliesTo(boolean isEditingAppliesTo) {
        this.isEditingAppliesTo = isEditingAppliesTo;
    }

    public String getUpdateAppliesTo() {
        return this.updateAppliesTo;
    }

    public void setUpdateAppliesTo(String updateAppliesTo) {
        this.updateAppliesTo = StringUtils.trimToNull((String)updateAppliesTo);
    }

    public String getUpdateAppliesToOriginalValue() {
        return this.updateAppliesToOriginalValue;
    }

    public void setUpdateAppliesToOriginalValue(String updateAppliesToOriginalValue) {
        this.updateAppliesToOriginalValue = updateAppliesToOriginalValue;
    }

    public String getNewAppliesTo() {
        return this.newAppliesTo;
    }

    public void setNewAppliesTo(String newAppliesTo) {
        this.newAppliesTo = StringUtils.trimToNull((String)newAppliesTo);
    }

    public boolean isUpdatingAppliesTo(String appliesTo) {
        return appliesTo.equals(this.updateAppliesToOriginalValue);
    }

    public StringPairPropertySelectionModel getDefaultTokenTypeList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        model.add("SAML 2.0", Saml20SecurityToken.TYPE);
        model.add("SAML 1.1", Saml11SecurityToken.TYPE);
        model.add("SAML 1.1 for Office 365", Saml11O365SecurityToken.TYPE);
        return model;
    }

    public String getSelectedDefaultTokenType() {
        return this.selectedDefaultTokenType;
    }

    public void setSelectedDefaultTokenType(String selectedDefaultTokenType) {
        this.selectedDefaultTokenType = selectedDefaultTokenType;
    }

    public boolean isEditMode() {
        if (this.isExpressionEnabled()) {
            for (MessageCustomizationCard.MessageHookEntry entry : this.getMessageHooks().values()) {
                if (!entry.isEditing()) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks() {
        return this.messageHooks;
    }

    public boolean getShowAdvanced() {
        return this.showAdvanced;
    }

    public void setShowAdvanced(boolean adv) {
        this.showAdvanced = adv;
    }

    public Map<String, String> getName2ContextMap() {
        return this.name2ContextMap;
    }

    public boolean getIsEditingHook() {
        return this.isEditingHook;
    }

    public void setIsEditingHook(boolean editing) {
        this.isEditingHook = editing;
    }

    public StringPairPropertySelectionModel getHookTypes() {
        return this.hookTypes;
    }

    public String getSelectedHookType() {
        return this.selectedHookType;
    }

    public void setSelectedHookType(String selectedHookType) {
        this.selectedHookType = selectedHookType;
    }

    public String getSelectedHookExpression() {
        return this.selectedHookExpr;
    }

    public void setSelectedHookExpression(String selectedHookExpr) {
        this.selectedHookExpr = selectedHookExpr;
    }

    public String getLinkContextName() {
        return this.linkContextName;
    }

    public void setLinkContextName(String linkName) {
        this.linkContextName = linkName;
    }

    public void updateKeyContext(boolean isWsFedJwt) {
        if (isWsFedJwt) {
            this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(true, false);
            this.name2ContextMap.remove("AssertionType");
        } else {
            this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(true, false);
        }
    }

    public boolean isAllowAdvanced() {
        return this.getCurrentUser().isExpressionAdmin() || !this.messageHooks.isEmpty();
    }
}

