/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustSpTasklet;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;

public class WsTrustSpState
extends SingleTaskletState {
    private static final long serialVersionUID = 1L;
    private SpConnection spConnection;
    private Object populateAllStatesData;

    public WsTrustSpState(Tasklet value) {
        super(value);
        this.setMenuName("WS-Trust STS");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        WsTrustSpTasklet tasklet = this.getTaskletToEdit(WsTrustSpTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(WsTrustSpTasklet.class);
            tasklet.configureTasklet();
            if (this.spConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.spConnection);
            }
            if (this.populateAllStatesData != null && ((SpConnection)this.populateAllStatesData).doesWsTrustSettingsExist()) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustFederatedWscSettings wsTrustSettings = new WsTrustFederatedWscSettings();
        SpConnection connectionToDisk = (SpConnection)dataToDisk;
        connectionToDisk.setWsTrustSettings(wsTrustSettings);
        return super.save(connectionToDisk);
    }

    public boolean isHolderOfKeyConfirmationMethod() {
        WsTrustSpTasklet tasklet = (WsTrustSpTasklet)this.getTasklet();
        return tasklet != null && tasklet.isHolderOfKeyConfirmationMethod();
    }

    public boolean isEncryptSaml20() {
        WsTrustSpTasklet tasklet = (WsTrustSpTasklet)this.getTasklet();
        return tasklet != null && tasklet.isEncryptSaml20();
    }
}

