/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import com.pingidentity.fsm.tasklet.impl.WsTrustUsersTasklet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class WsTrustStsHttpBasicAuthState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private transient Object componentState;
    private List<AdministrativeUser> users;

    public WsTrustStsHttpBasicAuthState(Tasklet value) {
        super(value);
        this.setMenuName("HTTP Basic Authentication");
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        this.componentState = null;
        this.users = null;
        WsTrustStsData wsTrustData = (WsTrustStsData)dataFromDisk;
        this.loadUsers(wsTrustData.getUsers());
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.users == null || this.users.isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("At_least_one_user"), ValidationConstraint.REQUIRED);
        } else if (!this.hasAtLeastOneUser()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("At_least_one_user"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void refreshState() {
        if (this.getTaskletToEdit() instanceof WsTrustUsersTasklet) {
            WsTrustUsersTasklet wsTrustUsersTasklet = (WsTrustUsersTasklet)this.getTaskletToEdit();
            AdministrativeUser user = wsTrustUsersTasklet.getUserChanges();
            for (int i = 0; i < this.getUsers().size(); ++i) {
                AdministrativeUser tempUser = this.getUsers().get(i);
                if (!tempUser.getUserName().equals(user.getUserName())) continue;
                this.getUsers().remove(i);
            }
            user.setAdminManager(Boolean.FALSE.booleanValue());
            user.setActive(Boolean.TRUE.booleanValue());
            this.getUsers().add(user);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataToDisk;
        HashMap<String, String> credentialsToSave = new HashMap<String, String>();
        for (AdministrativeUser user : this.getUsers()) {
            if (!user.isActive()) continue;
            credentialsToSave.put(user.getUserName(), user.getNewPassword());
        }
        wsTrustData.setUsers(credentialsToSave);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (AdministrativeUser user : this.getUsers()) {
            if (!user.isActive()) continue;
            summaryList.add(new SummaryInfo("User", user.getUserName(), this));
        }
    }

    public boolean doesUserExist(String username) {
        for (AdministrativeUser user : this.users) {
            if (!user.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cancel(Object data) {
        this.populateAllStates(data);
    }

    public List<AdministrativeUser> getUsers() {
        return this.users;
    }

    private void loadUsers(Map<String, String> existingUsers) {
        ArrayList<AdministrativeUser> tempUsers = new ArrayList<AdministrativeUser>();
        for (Map.Entry<String, String> user : existingUsers.entrySet()) {
            AdministrativeUser newUser = new AdministrativeUser();
            newUser.setUserName(user.getKey());
            newUser.setAdminManager(Boolean.FALSE.booleanValue());
            newUser.setActive(true);
            tempUsers.add(newUser);
        }
        this.users = tempUsers;
    }

    public boolean hasAtLeastOneUser() {
        if (this.users != null) {
            for (AdministrativeUser user : this.users) {
                if (!user.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getIsWsTrustAdminUserList() {
        return true;
    }

    public void setUsers(ArrayList<AdministrativeUser> users) {
        this.users = users;
    }

    public boolean isShowCreateUsersButton() {
        return true;
    }

    public boolean isShowAdminRoles() {
        return false;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public String getBasicAuthUsersStr() {
        ArrayList<String> userList = new ArrayList<String>();
        for (AdministrativeUser user : this.getUsers()) {
            if (!user.isActive()) continue;
            userList.add(user.getUserName());
        }
        return Util.listToCommaDelimString(userList);
    }
}

