/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSystemAuthTasklet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;

public class WsTrustStsSettingsState
extends SingleTaskletState {
    private static final long serialVersionUID = 1L;
    private WsTrustBasicAuthManager basicAuthnManager;
    private WsTrustClientCertAuthManager clientCertAuthManager;

    public WsTrustStsSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("WS-Trust STS Settings");
        this.basicAuthnManager = (WsTrustBasicAuthManager)GlobalRegistry.getService(WsTrustBasicAuthManager.class);
        this.clientCertAuthManager = (WsTrustClientCertAuthManager)GlobalRegistry.getService(WsTrustClientCertAuthManager.class);
    }

    @Override
    public boolean populateAllStates(Object data) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            tasklet = this.createTasklet(WsTrustStsSystemAuthTasklet.class);
            tasklet.populateAllStates(this.getDataForPopulate());
            this.setTasklet(tasklet);
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            this.populateAllStates(null);
        }
    }

    private WsTrustStsData getDataForPopulate() {
        WsTrustStsData wsTrustData = new WsTrustStsData();
        wsTrustData.setBasicAuthnEnabled(this.basicAuthnManager.isAuthenticationEnabled());
        wsTrustData.setUsers(this.getUsers());
        wsTrustData.setClientCertAuthnEnabled(this.clientCertAuthManager.isAuthenticationEnabled());
        wsTrustData.setRestrictBySubjectDn(this.clientCertAuthManager.isRestrictBySubjectDn());
        wsTrustData.setRestrictByIssuerCert(this.clientCertAuthManager.isRestrictByIssuerCert());
        wsTrustData.setAcceptableSubjectDnList(this.clientCertAuthManager.getAcceptableSubjectDnList());
        wsTrustData.setAcceptableIssuerCertAliases(this.clientCertAuthManager.getAcceptableIssuerCertAliases());
        return wsTrustData;
    }

    private Map<String, String> getUsers() {
        HashMap<String, String> users = new HashMap<String, String>();
        for (String id : this.basicAuthnManager.getIds()) {
            users.put(id, null);
        }
        return users;
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = new WsTrustStsData();
        if (this.getTaskletToEdit() != null) {
            super.save(wsTrustData);
        }
        this.saveToMgrs(wsTrustData);
        return true;
    }

    private void saveToMgrs(WsTrustStsData wsTrustData) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            boolean isBasicAuthnEnabled = wsTrustData.isBasicAuthnEnabled();
            this.basicAuthnManager.setAuthenticationEnabled(isBasicAuthnEnabled);
            if (isBasicAuthnEnabled) {
                this.basicAuthnManager.setCredentials(wsTrustData.getUsers());
            }
            boolean isClientCertAuthnEnabled = wsTrustData.isClientCertAuthnEnabled();
            this.clientCertAuthManager.setAuthenticationEnabled(isClientCertAuthnEnabled);
            if (isClientCertAuthnEnabled) {
                boolean isRestrictBySubjectDn = wsTrustData.isRestrictBySubjectDn();
                this.clientCertAuthManager.setRestrictBySubjectDn(isRestrictBySubjectDn);
                if (isRestrictBySubjectDn) {
                    this.clientCertAuthManager.setAcceptableSubjectDnList(wsTrustData.getAcceptableSubjectDnList());
                }
                boolean isRestrictByIssuerCert = wsTrustData.isRestrictByIssuerCert();
                this.clientCertAuthManager.setRestrictByIssuerCert(isRestrictByIssuerCert);
                if (isRestrictByIssuerCert) {
                    this.clientCertAuthManager.setAcceptableIssuerCertAliases(wsTrustData.getAcceptableIssuerCertAliases());
                }
            }
            auditLoggerScope.log(AdminAuditLogger.Component.SERVER_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet t = this.getTaskletToEdit();
        WsTrustStsSystemAuthTasklet wsTrustStsSystemAuthTasklet = (WsTrustStsSystemAuthTasklet)t;
        if (wsTrustStsSystemAuthTasklet != null && wsTrustStsSystemAuthTasklet.isAuthenticationEnabled()) {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    private WsTrustStsSystemAuthTasklet getChildTasklet() {
        Tasklet t = this.getTaskletToEdit();
        WsTrustStsSystemAuthTasklet wsTrustStsSystemAuthTasklet = (WsTrustStsSystemAuthTasklet)t;
        return wsTrustStsSystemAuthTasklet;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        this.doSummary(summaryList);
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null) {
            tasklet.getSummary(summaryList);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
        ArrayList<String> methods = new ArrayList<String>();
        if (this.isEnableHttpBasic()) {
            methods.add(this.getMessage("Require_http_basic_authentication"));
        }
        if (this.isEnableSsl()) {
            methods.add(this.getMessage("Require_mutual_ssl_authentication"));
        }
        if (!this.isEnableHttpBasic() && !this.isEnableSsl()) {
            methods.add(this.getMessage("None"));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Authentication_methods"), Util.listToCommaDelimString(methods), this));
    }

    public String getAuthnMethodsStr() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.getAuthnMethodsStr();
    }

    public boolean isEnableHttpBasic() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.isEnableHttpBasic();
    }

    public String getBasicAuthUsersStr() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.getBasicAuthUsersStr();
    }

    public boolean isEnableSsl() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.isEnableSsl();
    }

    public boolean isRestrictBySubjectDn() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.isRestrictBySubjectDn() && t.isEnableSsl();
    }

    public boolean isRestrictByIssuerCert() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.isRestrictByIssuerCert() && t.isEnableSsl();
    }

    public String getAuthnOptionsStr() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.getAuthnOptionsStr();
    }

    public List<String> getSubjectDNsList() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.getSubjectDNsList();
    }

    public String getIssuerCertsStr() {
        WsTrustStsSystemAuthTasklet t = this.getChildTasklet();
        return t.getIssuerCertsStr();
    }

    @Override
    public void setPopulateDate(Object data) {
    }

    @Override
    public void reset() {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null) {
            tasklet = this.createTasklet(WsTrustStsSystemAuthTasklet.class);
            tasklet.populateAllStates(this.getDataForPopulate());
            this.setTasklet(tasklet);
        }
    }
}

