/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import com.pingidentity.util.MappingUtil;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;

public class WsTrustTokenGeneratorContractFulfillmentState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String MODEL_TARGET_NAME = "Token Generator Contract";
    private SAML2MappingModel model = new SAML2MappingModel(this.getCurrentUser());
    private transient DataMap.Sources sources = new DataMap.Sources();
    private AttributeMapping attributeMapping;

    public WsTrustTokenGeneratorContractFulfillmentState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Token Generator Contract Fulfillment");
        this.model.setTargetName(MODEL_TARGET_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping tokenPluginAttributeMapping = (TokenPluginAttributeMapping)dataFromDisk;
        this.attributeMapping = tokenPluginAttributeMapping.getAttributeMapping();
        this.model = new SAML2MappingModel(MODEL_TARGET_NAME, this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping tokenPluginAttributeMapping = (TokenPluginAttributeMapping)dataToDisk;
        AttributeMapping outmap = tokenPluginAttributeMapping.getAttributeMapping();
        Map attrMap = this.model.getMapping().getAttributeMap();
        Set<String> targets = this.getTarget();
        HashSet<String> targetsToRemove = new HashSet<String>();
        for (Map.Entry e : attrMap.entrySet()) {
            String target = (String)e.getKey();
            if (targets.contains(target)) continue;
            targetsToRemove.add(target);
        }
        for (String ttm : targetsToRemove) {
            attrMap.remove(ttm);
        }
        outmap.setAttributeMap(attrMap);
        return true;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        WsTrustTokenGeneratorMappingTasklet parentTasklet = (WsTrustTokenGeneratorMappingTasklet)this.getParent();
        parentTasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        this.sources.addNoMappingSource("No Mapping");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        MappingUtil util = new MappingUtil();
        util.addExtendedPropertiesToSelectionSources(this.sources);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    @Override
    public void cancel(Object newData) {
        if (this.isViewOnly()) {
            return;
        }
        super.cancel(newData);
    }

    @Override
    public void reset() {
        this.model = new SAML2MappingModel(this.getCurrentUser());
        this.model.setTargetName(MODEL_TARGET_NAME);
    }

    public Set<String> getTarget() {
        return this.getTokenGeneratorContract() != null ? this.getTokenGeneratorContract() : new HashSet<String>();
    }

    private Set<String> getTokenGeneratorContract() {
        PluginMappingApi parentTasklet = (PluginMappingApi)((Object)this.getParent());
        if (parentTasklet.isOverridePluginPopulated()) {
            return new HashSet<String>(parentTasklet.getPluginContract());
        }
        AttributeSourceApi parent = this.findParent(AttributeSourceApi.class);
        return parent.getSelectedPlugin() != null ? parent.getSelectedPlugin().getAttributeContract().getAllAttributeNames() : null;
    }

    public DataMap.Sources getSources() {
        return this.sources;
    }

    public SAML2MappingModel getModel() {
        return this.model;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            super.appendErrors(delegate, component, fastFail);
            this.onStateActivated();
            this.model.validate(delegate, this.getTarget(), this.getSources(), this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        AttributeMapping map = this.model.getMapping();
        if (this.getTokenGeneratorContract() != null) {
            for (String target : this.getTokenGeneratorContract()) {
                AttrMappingValue v = map.getAttributeMapping(target);
                if (v != null) {
                    summaryList.add(new SummaryInfo(target, (String)(SourceType.NO_MAPPING.equals((Object)v.getType()) ? "No Mapping" : v.getValue() + " (" + v.getTypeString() + ")"), this));
                    continue;
                }
                summaryList.add(new SummaryInfo(target, "Not defined", this));
            }
        }
    }
}

