/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class WsTrustTokenProcessorMappingState
extends TaskletListState {
    private static final long serialVersionUID = 2L;
    private Collection<TokenPluginAttributeMapping> attributeMappings = new ArrayList<TokenPluginAttributeMapping>();

    public WsTrustTokenProcessorMappingState(Tasklet value) {
        super(value);
        this.setMenuName("IdP Token Processor Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustFederatedWscSettings settings = (WsTrustFederatedWscSettings)dataFromDisk;
        this.attributeMappings = new ArrayList<TokenPluginAttributeMapping>(settings.getTokenToAssertionMappings());
        this.populate(this.attributeMappings);
    }

    private void populate(Collection<TokenPluginAttributeMapping> mappings) {
        this.deleteAllTasklets();
        for (TokenPluginAttributeMapping mapping : mappings) {
            TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
            TokenPluginInstance tokenPluginInstance = (TokenPluginInstance)tokenProcessorManager.getInstance(mapping.getPluginId());
            if (tokenPluginInstance == null) continue;
            WsTrustTokenProcessorMappingTasklet tasklet = this.createTasklet(WsTrustTokenProcessorMappingTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(mapping);
            this.addTasklet(tasklet);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList<TokenPluginAttributeMapping> mappings = new ArrayList<TokenPluginAttributeMapping>();
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            TokenPluginAttributeMapping mapping = new TokenPluginAttributeMapping();
            mapping.setAttributeMapping(new AttributeMapping());
            t.save(mapping);
            mappings.add(mapping);
        }
        SpConnection conn = (SpConnection)dataToDisk;
        WsTrustFederatedWscSettings settings = conn.getWsTrustSettings();
        settings.setTokenToAssertionMappings(mappings);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.doesOneExist()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_required"), ValidationConstraint.REQUIRED);
        } else {
            this.removeDeletedTasklets();
            for (Tasklet tasklet : this.getTasklets()) {
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    private boolean doesOneExist() {
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            return true;
        }
        return false;
    }

    private void removeDeletedTasklets() {
        List<Tasklet> tasklets = this.getTasklets();
        ArrayList<Tasklet> taskletsToRemove = new ArrayList<Tasklet>();
        for (Tasklet t : tasklets) {
            if (t.isDraft() || !t.isItDeleted()) continue;
            taskletsToRemove.add(t);
        }
        for (Tasklet t : taskletsToRemove) {
            if (!tasklets.contains(t)) continue;
            tasklets.remove(t);
        }
    }

    @Override
    public void reset() {
        this.deleteAllTasklets();
        this.attributeMappings = new ArrayList<TokenPluginAttributeMapping>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenProcessorMappingTasklet t = (WsTrustTokenProcessorMappingTasklet)tasklet;
            summaryList.add(new SummaryInfo("Processor instance name", t.getSelectedPlugin().getName(), this));
        }
    }

    public Collection<TokenPluginAttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    public void setAttributeMappings(Collection<TokenPluginAttributeMapping> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public List<String> getProcessorsInUseByConnection() {
        ArrayList<String> processorsInUse = new ArrayList<String>();
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenProcessorMappingTasklet wsTrustTokenProcessorMappingTasklet = (WsTrustTokenProcessorMappingTasklet)tasklet;
            String selectedTokenProcessorId = wsTrustTokenProcessorMappingTasklet.getSelectedPluginId();
            if (selectedTokenProcessorId == null) continue;
            processorsInUse.add(selectedTokenProcessorId);
        }
        return processorsInUse;
    }

    public Tasklet getTaskletFromList(String identifier) {
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenProcessorMappingTasklet wsTrustTokenProcessorMappingTasklet = (WsTrustTokenProcessorMappingTasklet)tasklet;
            if (!wsTrustTokenProcessorMappingTasklet.getDescription().equals(identifier)) continue;
            wsTrustTokenProcessorMappingTasklet.initialize();
            return wsTrustTokenProcessorMappingTasklet;
        }
        return null;
    }

    public void delete(String mappingToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenProcessorMappingTasklet t = (WsTrustTokenProcessorMappingTasklet)tasklet;
            if (!t.getDescription().equals(mappingToDelete)) continue;
            tasklet.setItDeleted(true);
            return;
        }
    }

    public void undelete(String mappingToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenProcessorMappingTasklet t = (WsTrustTokenProcessorMappingTasklet)tasklet;
            if (!t.getDescription().equals(mappingToDelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }
}

