/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.wstrust.protocol.WSTrustVersion;

public class WsTrustVersionState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private String versionNumber = WSTrustVersion.v2005.getVersion();

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public WsTrustVersionState(IWizard owner) {
        super(owner);
        this.setMenuName("WS-Trust Version");
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        if (tempConnection instanceof SpConnection && ((SpConnection)tempConnection).getWsFedSettings() != null) {
            ((SpConnection)tempConnection).getWsFedSettings().setWsTrustVersion(this.versionNumber);
        }
        return super.save(dataToDisk);
    }

    @Override
    public void reset() {
        this.versionNumber = WSTrustVersion.v2005.getVersion();
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        if (connection instanceof SpConnection && ((SpConnection)connection).getWsFedSettings() != null && ((SpConnection)connection).getWsFedSettings().getWsTrustVersion() != null) {
            this.versionNumber = ((SpConnection)connection).getWsFedSettings().getWsTrustVersion();
        }
    }

    public StringPropertySelectionModel getWsTrustVersions() {
        ArrayList versions = new ArrayList();
        String[] versionArray = new String[WSTrustVersion.values().length];
        Arrays.asList(WSTrustVersion.values()).forEach(version -> versions.add(version.getVersion()));
        StringPropertySelectionModel model = new StringPropertySelectionModel(versions.toArray(versionArray));
        return model;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("WS-Trust Version", this.versionNumber, this));
    }
}

