/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.state.impl.SigningCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.SignXmlTasklet;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.saml20.domain.util.DsigUtil;

public class XmlFileSigningCertState
extends SigningCertState {
    private static final long serialVersionUID = 20050515L;
    private String errorMessage;
    private String signedXml;

    public XmlFileSigningCertState(Tasklet value) {
        super(value);
        this.certType = CertificateTypes.ValidTypes.dsigSigningCert;
        this.setMenuName("Digital Signature Settings");
        this.setIncludeKeyInfoVisible(true);
        this.setIncludeKeyInfo(true);
        this.setIncludeKeyValue(true);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        this.errorMessage = null;
        SignXmlTasklet parentTasklet = this.getParent(SignXmlTasklet.class);
        PkCert pkCert = (PkCert)parentTasklet.getSelectedCert();
        if (pkCert != null) {
            try {
                this.signedXml = DsigUtil.signXml((XmlObject)parentTasklet.getXmlObject(), (String)this.getSelectedSigningAlgType(), (PkCert)pkCert, (boolean)parentTasklet.isIncludeKeyInfo(), (boolean)parentTasklet.isIncludeKeyValue());
            }
            catch (SigningException e) {
                this.log.debug((Object)("Signing this file caused a Signing Exception! " + e));
                this.errorMessage = this.getMessage("Signing_exception");
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.errorMessage != null) {
            delegate.setFormComponent(null);
            delegate.record(this.errorMessage, ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public String getKeyInfoText() {
        return this.getMessage("Key_info_text");
    }

    @Override
    public String getKeyValueText() {
        return this.getMessage("Key_value_text");
    }

    public String getSignedXml() {
        return this.signedXml;
    }

    @Override
    public boolean isShowSecondaryCertDropDown() {
        return false;
    }
}

