/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.fragments;

import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AbstractPoliciesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.fragments.PolicyFragmentTasklet;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public class PolicyFragmentsState
extends AbstractPoliciesState {
    private static final long serialVersionUID = 12389L;
    private static final Comparator<Tasklet> COMPARE_BY_NAME_DOWN = (Comparator & Serializable)(o1, o2) -> {
        PolicyFragmentTasklet tasklet1 = (PolicyFragmentTasklet)o1;
        PolicyFragmentTasklet tasklet2 = (PolicyFragmentTasklet)o2;
        return tasklet1.getName().compareToIgnoreCase(tasklet2.getName());
    };

    public PolicyFragmentsState(IWizard owner) {
        super(owner);
    }

    @Override
    protected Tasklet initializeNewTasklet() {
        PolicyFragmentTasklet tasklet = this.createTaskletToLoad(PolicyFragmentTasklet.class);
        tasklet.setParentPoliciesState(this);
        tasklet.setMode(Mode.create);
        tasklet.initialize();
        return tasklet;
    }

    @Override
    public void populate(Object dataFromDisk) {
        PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();
        this.deleteAllTasklets();
        for (PolicyFragment fragment : fragmentManager.getFragments()) {
            PolicyFragmentTasklet tasklet = new PolicyFragmentTasklet(this.getVisit());
            tasklet.setMode(Mode.edit);
            tasklet.setParentTasklet(this.getParent());
            tasklet.setParentPoliciesState(this);
            tasklet.populate(fragment);
            this.addTasklet(tasklet);
        }
        this.sort(COMPARE_BY_NAME_DOWN);
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        super.setTaskletToEdit(taskletToEdit);
        this.sort(COMPARE_BY_NAME_DOWN);
    }

    @Override
    public void copyPolicy(int taskletIndex) {
        PolicyFragmentTasklet copyFromTasklet = (PolicyFragmentTasklet)this.getTasklet(taskletIndex);
        PolicyFragment fragment = copyFromTasklet.getCurrentPolicyFragment();
        fragment.setName(null);
        fragment.setId(AuthnPolicyUtil.getDefault().generateId());
        Tasklet tasklet = this.initializeNewTasklet();
        tasklet.populate(fragment);
        this.loadTasklet(tasklet);
    }

    @Override
    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        PolicyFragmentTasklet tasklet = (PolicyFragmentTasklet)this.getTasklet(indexToEdit);
        tasklet.refresh(cycle);
        this.loadTasklet(tasklet);
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        PolicyFragmentTasklet tasklet = (PolicyFragmentTasklet)this.getTasklet(taskletToDelete);
        tasklet.setItDeleted(true);
        tasklet.delete();
    }

    public void showAdapterLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowAdapterShortList(false);
    }

    public void hideAdapterLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowAdapterShortList(true);
    }

    public void showContractLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowContractsShortList(false);
    }

    public void hideContractLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowContractsShortList(true);
    }

    public void showSelectorLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowSelectorShortList(false);
    }

    public void hideSelectorLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((PolicyFragmentTasklet)item).getPolicyState().setShowSelectorShortList(true);
    }
}

