/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.DataStoreConfigTasklet;
import com.pingidentity.localidentity.DataStoreAttribute;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.LdapDataStoreAttribute;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.util.ExtStringPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class DataStoreMappingState
extends TaskletState {
    private Map<String, String> fieldsToDataStoreMap = new LinkedHashMap<String, String>();

    public DataStoreMappingState(IWizard owner) {
        super(owner);
        this.setMenuName("Data Store Mapping");
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.addFieldsToMap();
    }

    @Override
    public boolean save(Object dataToDisk) {
        DataStoreConfig mapping = ((LocalIdentityProfile)dataToDisk).getDataStoreConfig();
        this.removeInvalidFields();
        HashMap<String, LdapDataStoreAttribute> fieldMap = new HashMap<String, LdapDataStoreAttribute>(this.fieldsToDataStoreMap.size());
        for (Map.Entry<String, String> field : this.fieldsToDataStoreMap.entrySet()) {
            LdapDataStoreAttribute attribute = new LdapDataStoreAttribute(field.getValue(), Collections.emptyMap());
            fieldMap.put(field.getKey(), attribute);
        }
        mapping.setDataStoreMapping(fieldMap);
        return super.save(dataToDisk);
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        this.fieldsToDataStoreMap.clear();
        for (Map.Entry fieldMapping : policy.getDataStoreConfig().getDataStoreMapping().entrySet()) {
            this.fieldsToDataStoreMap.put((String)fieldMapping.getKey(), ((DataStoreAttribute)fieldMapping.getValue()).getName());
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ArrayList<String> availableFields = new ArrayList<String>(this.getCurrentConfiguredFields());
        availableFields.removeIf(fieldName -> StringUtils.isNotBlank((String)this.fieldsToDataStoreMap.get(fieldName)));
        if (!availableFields.isEmpty()) {
            if (availableFields.size() > 1) {
                String missingFields = StringUtils.join(availableFields, (String)", ");
                delegate.record(this.getMessage("missing_field_mappings", new Object[]{missingFields}), ValidationConstraint.REQUIRED);
            } else {
                delegate.record(this.getMessage("missing_field_mapping", new Object[]{availableFields.get(0)}), ValidationConstraint.REQUIRED);
            }
            return;
        }
        ArrayList seenAttributes = new ArrayList();
        this.fieldsToDataStoreMap.forEach((key, value) -> {
            if (seenAttributes.contains(value)) {
                delegate.record(this.getMessage("attribute_already_mapped", new Object[]{value}), ValidationConstraint.REQUIRED);
            } else {
                seenAttributes.add(value);
            }
        });
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        List<String> fields = this.getCurrentConfiguredFields();
        this.fieldsToDataStoreMap.forEach((key, value) -> {
            if (fields.contains(key)) {
                summaryList.add(new SummaryInfo("Field Mapping", "Field '" + key + "' maps to '" + value + "'", this));
            }
        });
    }

    private void addFieldsToMap() {
        List<String> currentFields = this.getCurrentConfiguredFields();
        LinkedHashMap<String, String> newFieldMap = new LinkedHashMap<String, String>();
        for (String field : currentFields) {
            String value = this.fieldsToDataStoreMap.getOrDefault(field, null);
            newFieldMap.put(field, value);
        }
        this.fieldsToDataStoreMap = newFieldMap;
    }

    private void removeInvalidFields() {
        List<String> fieldsToRemove = this.fieldsToDataStoreMap.keySet().stream().filter(field -> !this.getCurrentConfiguredFields().contains(field)).collect(Collectors.toList());
        fieldsToRemove.forEach(field -> {
            if (!this.getCurrentConfiguredFields().contains(field)) {
                String dataStoreValueToRemove = this.fieldsToDataStoreMap.get(field);
                this.getParent(DataStoreConfigTasklet.class).removeDataStoreAttribute(dataStoreValueToRemove);
                this.fieldsToDataStoreMap.remove(field);
            }
        });
    }

    private List<String> getCurrentConfiguredFields() {
        return this.findParent(DataStoreConfigTasklet.class).getContractToFulfill();
    }

    public Map<String, String> getFieldsToDataStoreMap() {
        return this.fieldsToDataStoreMap;
    }

    public Set<String> getFieldNames() {
        return this.fieldsToDataStoreMap.keySet();
    }

    public IPropertySelectionModel getSelectedDataStoreAttributes() {
        List<String> selectedAttributes = this.findParent(DataStoreConfigTasklet.class).getSelectedAttributes();
        return new ExtStringPropertySelectionModel(selectedAttributes.toArray(new String[0]));
    }
}

