/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.LdapDataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DataStoreSelectionState
extends SelectDataSourceState {
    public DataStoreSelectionState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Data Store");
    }

    @Override
    protected List<DataSource> loadDataSources() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        Predicate<LdapDataSource> supportedLdapTypes = source -> source.getLdapType().equals((Object)LdapInfo.LdapType.PingDirectory) || source.getLdapType().equals((Object)LdapInfo.LdapType.UnboundID);
        return dataMgr.getLdapDataSources().stream().filter(supportedLdapTypes).collect(Collectors.toList());
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        this.selectedDataSource = policy.getDataStoreConfig().getAttributeSource().getDataSource();
        this.populate();
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataToDisk;
        if (policy.getDataStoreConfig() == null) {
            AttributeSource attributeSource = AttributeSourceFactory.getAttributeSource((DataSource)this.selectedDataSource);
            LdapDataStoreConfig config = new LdapDataStoreConfig(attributeSource);
            policy.setDataStoreConfig((DataStoreConfig)config);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedDataSource == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Data_store_required"), ValidationConstraint.REQUIRED);
        }
    }
}

