/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.FieldConfigTasklet;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldType;
import com.pingidentity.util.EnumPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class FieldConfigState
extends TaskletState
implements TableEditor.TableEditorRowOrdering,
TableEditor.TableEditorListener {
    private static final long serialVersionUID = 12948832L;
    private static final SimpleFieldDescriptor OPTION_DESCRIPTOR = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Option", 240);
    private static final List<String> RESERVED_WORDS;
    private LocalIdentityFieldType type = LocalIdentityFieldType.TEXT;
    private LocalIdentityFieldType previousType;
    private String id;
    private String label;
    private String defaultValue;
    private boolean showOnProfile = true;
    private boolean showOnRegistration = true;
    private Map<String, Boolean> fieldAttributes = new HashMap<String, Boolean>();
    private List<TableRow> options = new ArrayList<TableRow>();
    private Boolean isNewField;
    private Object componentState;

    public FieldConfigState(IWizard owner, boolean isNewField) {
        super(owner);
        this.setMenuName("Field Configuration");
        this.setShowNote(false);
        this.isNewField = isNewField;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        FieldConfigTasklet parentTasklet = this.getParent(FieldConfigTasklet.class);
        summaryList.add(new SummaryInfo("ID", this.id, this));
        summaryList.add(new SummaryInfo("Label", this.label, this));
        summaryList.add(new SummaryInfo("Type", this.type.getLabel(), this));
        if (parentTasklet.isRegistrationAndProfileEnabled()) {
            summaryList.add(new SummaryInfo("Applies To Registration", Boolean.toString(this.showOnRegistration), this));
            summaryList.add(new SummaryInfo("Applies To Profile", Boolean.toString(this.showOnProfile), this));
        }
        List attributesSummary = this.fieldAttributes.keySet().stream().map(attribute -> new SummaryInfo("Parameter - " + attribute, Boolean.toString(this.fieldAttributes.get(attribute)), this)).collect(Collectors.toList());
        summaryList.addAll(attributesSummary);
        if (this.type.getField().getConfig().isShowDefaultValueField() && !this.isReadOnly()) {
            summaryList.add(new SummaryInfo("Default Value", this.defaultValue, this));
        }
        if (this.type.getField().getConfig().isShowOptionsField()) {
            List optionsSummary = this.options.stream().filter(option -> !option.isMarkedForDelete()).map(option -> new SummaryInfo("Option", this.getOptionFromRow((TableRow)option), this)).collect(Collectors.toList());
            summaryList.addAll(optionsSummary);
        }
    }

    private boolean isReadOnly() {
        return this.fieldAttributes.getOrDefault("Read-Only", false);
    }

    @Override
    public void moveUp(int index) {
        if (index > 0) {
            TableRow item = this.options.get(index);
            this.options.set(index, this.options.get(index - 1));
            this.options.set(index - 1, item);
        }
    }

    @Override
    public void moveDown(int index) {
        if (index < this.options.size() - 1) {
            TableRow item = this.options.get(index);
            this.options.set(index, this.options.get(index + 1));
            this.options.set(index + 1, item);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.showOnProfile = this.getParent(FieldConfigTasklet.class).isProfileEnabled();
        this.showOnRegistration = this.getParent(FieldConfigTasklet.class).isRegistrationEnabled();
        LocalIdentityField field = (LocalIdentityField)dataFromDisk;
        this.id = field.getData().getId();
        this.label = field.getData().getLabel();
        this.type = LocalIdentityFieldType.fromObject((LocalIdentityField)field);
        this.showOnRegistration = field.getData().isRegistrationPageField();
        this.showOnProfile = field.getData().isProfilePageField();
        this.fieldAttributes.clear();
        field.getConfig().getAttributes().forEach(attr -> this.fieldAttributes.put((String)attr, false));
        field.getData().getEnabledAttributes().forEach(attr -> this.fieldAttributes.put((String)attr, true));
        if (field.getConfig().isShowDefaultValueField()) {
            this.defaultValue = field.getData().getDefaultValue();
        }
        if (field.getConfig().isShowOptionsField()) {
            this.options = this.convertOptionsToRows(field.getData().getOptions());
        }
    }

    private List<TableRow> convertOptionsToRows(List<String> options) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        options.forEach(option -> {
            ArrayList<FieldItem> items = new ArrayList<FieldItem>();
            items.add(new FieldItem(OPTION_DESCRIPTOR, (String)option));
            rows.add(new TableRow(items));
        });
        return rows;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        LocalIdentityField field = this.toLocalIdentityField();
        delegate.setFormComponent(null);
        if (!this.type.getField().getConfig().isShowOptionsField()) {
            delegate.clearErrors();
        }
        this.validateIdField(this.id, delegate);
        this.validateLabel(this.label, delegate);
        this.validateEnabledPages(field, this.showOnProfile, this.showOnRegistration, delegate);
        this.validateAttributes(field, delegate);
        this.validateDefaultValue(field, this.defaultValue, this.getOptionsFromRows(), delegate);
        this.validateFieldOptions(field, this.getOptionsFromRows(), delegate);
    }

    private void validateAttributes(LocalIdentityField<?> field, IValidationDelegate delegate) {
        List errors = field.validateAttributes();
        if (errors.size() > 0) {
            errors.forEach(arg_0 -> ((IValidationDelegate)delegate).record(arg_0));
        }
    }

    private void validateDefaultValue(LocalIdentityField<?> field, String defaultValue, List<String> options, IValidationDelegate delegate) {
        List errors;
        if (StringUtils.isNotBlank((String)defaultValue) && (errors = field.validateDefaultValue(defaultValue, options)).size() > 0) {
            errors.forEach(arg_0 -> ((IValidationDelegate)delegate).record(arg_0));
        }
    }

    private void validateEnabledPages(LocalIdentityField<?> field, boolean profilePageField, boolean registrationPageField, IValidationDelegate delegate) {
        List errors = field.validatePages(profilePageField, registrationPageField);
        if (errors.size() > 0) {
            errors.forEach(arg_0 -> ((IValidationDelegate)delegate).record(arg_0));
        }
    }

    private void validateFieldOptions(LocalIdentityField<?> field, List<String> options, IValidationDelegate delegate) {
        List errors;
        if (field.getConfig().isShowOptionsField() && options.isEmpty()) {
            Object[] args = new Object[]{field.getName()};
            delegate.record(this.getMessage("options_value_required", args), ValidationConstraint.REQUIRED);
        }
        if (options != null && (errors = field.validateOptions(options)).size() > 0) {
            errors.forEach(arg_0 -> ((IValidationDelegate)delegate).record(arg_0));
        }
    }

    private void validateLabel(String label, IValidationDelegate delegate) {
        if (this.isReservedWord(label)) {
            Object[] objects = new Object[]{label};
            delegate.record(this.getMessage("reserved_word_label", objects), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)label)) {
            delegate.record(this.getMessage("Label_required"), ValidationConstraint.REQUIRED);
        }
    }

    private void validateIdField(String id, IValidationDelegate delegate) {
        Object[] objects;
        if (StringUtils.isBlank((String)id)) {
            delegate.record(this.getMessage("Id_required"), ValidationConstraint.REQUIRED);
            return;
        }
        if (this.isReservedWord(id)) {
            objects = new Object[]{id};
            delegate.record(this.getMessage("reserved_word_id", objects), ValidationConstraint.REQUIRED);
        }
        if (this.isIdInUse(id)) {
            objects = new Object[]{id};
            delegate.record(this.getMessage("id_in_use", objects), ValidationConstraint.REQUIRED);
        }
        if (!CommonValidator.isValidAdapterInstanceId((String)id)) {
            int max = 33;
            Object[] objects2 = new Object[]{max};
            delegate.record(this.getMessage("Invalid_id", objects2), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isIdInUse(String id) {
        int numIdsFound = 0;
        for (int i = 0; i < this.getFieldList().size(); ++i) {
            if (!this.getFieldList().get(i).getData().getId().equalsIgnoreCase(id)) continue;
            ++numIdsFound;
        }
        if (this.isNewField.booleanValue() && numIdsFound > 0) {
            return true;
        }
        return this.isNewField == false && numIdsFound > 1;
    }

    private boolean isReservedWord(String id) {
        return RESERVED_WORDS.stream().anyMatch(reservedWord -> reservedWord.equalsIgnoreCase(id));
    }

    public LocalIdentityFieldType getType() {
        return this.type;
    }

    public void setType(LocalIdentityFieldType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isShowOnProfile() {
        return this.showOnProfile;
    }

    public void setShowOnProfile(boolean showOnProfile) {
        this.showOnProfile = showOnProfile;
    }

    public boolean isShowOnRegistration() {
        return this.showOnRegistration;
    }

    public void setShowOnRegistration(boolean showOnRegistration) {
        this.showOnRegistration = showOnRegistration;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Set<String> getFieldAttributesNames() {
        return this.fieldAttributes.keySet();
    }

    public Map<String, Boolean> getFieldAttributes() {
        return this.fieldAttributes;
    }

    public void setFieldAttributes(Map<String, Boolean> fieldAttributes) {
        this.fieldAttributes = fieldAttributes;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public IPropertySelectionModel getTypeList() {
        Comparator<LocalIdentityFieldType> comparing = Comparator.comparing(LocalIdentityFieldType::getLabel);
        return EnumPropertySelectionModel.newInstance((Enum[])LocalIdentityFieldType.values(), comparing);
    }

    public List<SimpleFieldDescriptor> getOptionDescriptors() {
        return Collections.singletonList(OPTION_DESCRIPTOR);
    }

    public List<TableRow> getOptions() {
        return this.options;
    }

    public void setOptions(List<TableRow> options) {
        this.options = options;
    }

    public boolean isShowDefault() {
        return this.type.getField().getConfig().isShowDefaultValueField() && this.fieldAttributes.getOrDefault("Read-Only", false) == false;
    }

    public boolean isShowOptions() {
        return this.type.getField().getConfig().isShowOptionsField();
    }

    public LocalIdentityFieldType getPreviousType() {
        return this.previousType;
    }

    public void setPreviousType(LocalIdentityFieldType previousType) {
        this.previousType = previousType;
    }

    public void resetFieldAttributes() {
        List newFieldAttributes = this.type.getField().getConfig().getAttributes();
        newFieldAttributes.forEach(attr -> this.fieldAttributes.putIfAbsent((String)attr, false));
        List<String> attrsNoLongerNeeded = this.fieldAttributes.keySet().stream().filter(attr -> !newFieldAttributes.contains(attr)).collect(Collectors.toList());
        attrsNoLongerNeeded.forEach(attr -> this.fieldAttributes.remove(attr));
    }

    public LocalIdentityField toLocalIdentityField() {
        List<String> options = this.getOptionsFromRows();
        boolean isShowOnProfile = this.getParent(FieldConfigTasklet.class).isProfileEnabled() && this.showOnProfile;
        boolean isShowOnRegistration = this.getParent(FieldConfigTasklet.class).isRegistrationEnabled() && this.showOnRegistration;
        LocalIdentityField field = this.type.getField();
        String fixedDefaultValue = this.isShowDefault() ? this.defaultValue : null;
        List<String> fixedOptions = field.getConfig().isShowOptionsField() ? options : Collections.emptyList();
        LocalIdentityFieldData data = new LocalIdentityFieldData(this.id, this.label, fixedDefaultValue, this.fieldAttributes, fixedOptions, isShowOnRegistration, isShowOnProfile);
        return this.type.getField().newInstance(data);
    }

    private List<String> getOptionsFromRows() {
        if (this.options != null && this.options.size() > 0) {
            return this.options.stream().filter(field -> !field.isMarkedForDelete()).map(this::getOptionFromRow).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getOptionFromRow(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    public List<LocalIdentityField<?>> getFieldList() {
        return this.getParent(FieldConfigTasklet.class).getFieldList();
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        String newOption = this.getOptionFromRow(row);
        if (StringUtils.isEmpty((String)newOption)) {
            return Collections.singletonList(this.getMessage("option_cant_be_blank"));
        }
        int numMatches = this.getNumMatches(row, list);
        if (originalRow == null && numMatches > 0) {
            Object[] objects = new Object[]{newOption};
            return Collections.singletonList(this.getMessage("option_already_in_use", objects));
        }
        if (!(originalRow == null || numMatches <= 0 || numMatches == 1 && this.getOptionFromRow(row).equals(this.getOptionFromRow(originalRow)))) {
            Object[] objects = new Object[]{newOption};
            return Collections.singletonList(this.getMessage("option_already_in_use", objects));
        }
        return Collections.emptyList();
    }

    private int getNumMatches(TableRow row, List<TableRow> list) {
        String newValue = row.getFields().get(0).getValue();
        return (int)list.stream().filter(currRow -> newValue != null && newValue.trim().equals(this.getOptionFromRow((TableRow)currRow))).count();
    }

    @Override
    public boolean onStateExit() {
        this.isNewField = false;
        return super.onStateExit();
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    static {
        OPTION_DESCRIPTOR.setPlaceholderText("Insert Option");
        RESERVED_WORDS = Collections.unmodifiableList(Collections.singletonList("password"));
    }
}

