/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.admin.api.validator.localidentity.LdapCreatePatternValidator;
import com.pingidentity.admin.api.validator.localidentity.LdapObjectClassValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.DataStoreConfigTasklet;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class LdapWriteIdentityState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 2017110301L;
    private String createPattern;
    private String objectClass;
    private boolean isObjectClassDirty = false;
    private LdapDataSource dataSource;
    private transient StringPairPropertySelectionModel objClassList;
    private transient StringPairPropertySelectionModel auxObjClassList;
    private transient Object componentState;
    private final SimpleFieldDescriptor AUX_OBJECT_CLASS_NAME = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Auxiliary Object Class Name", 240);
    private final List<SimpleFieldDescriptor> auxiliaryClassesDescriptors = new ArrayList<SimpleFieldDescriptor>();
    private List<TableRow> auxiliaryClasses = new ArrayList<TableRow>();

    public LdapWriteIdentityState(IWizard owner) {
        super(owner);
        this.setMenuName("Identity Creation");
        this.auxiliaryClassesDescriptors.add(this.AUX_OBJECT_CLASS_NAME);
    }

    public String getCreatePattern() {
        return this.createPattern;
    }

    public void setCreatePattern(String createPattern) {
        this.createPattern = createPattern;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.isObjectClassDirty = objectClass == null || !objectClass.equals(this.objectClass);
        this.objectClass = objectClass;
    }

    public List<String> getAvailableValues() {
        DataStoreConfigTasklet parentTasklet = this.getParent(DataStoreConfigTasklet.class);
        List<String> contractToFulfill = parentTasklet.getContractToFulfill();
        List availableCustomAttributes = LocalIdentityStorageManager.getInstance((LdapInfo.LdapType)this.dataSource.getLdapType()).getAvailableCustomAttributes();
        contractToFulfill.addAll(availableCustomAttributes);
        contractToFulfill.sort(String::compareTo);
        return contractToFulfill;
    }

    public IPropertySelectionModel getObjClassList() {
        if (!(this.isViewOnly() || this.objClassList != null && this.objClassList.getOptionCount() != 0)) {
            this.objClassList = this.buildSelectionModel(this.dataSource.getStructuralObjectClasses());
        }
        return this.objClassList;
    }

    public IPropertySelectionModel getAuxObjClassList() {
        if (!(this.isViewOnly() || this.auxObjClassList != null && this.auxObjClassList.getOptionCount() != 0)) {
            this.auxObjClassList = this.buildSelectionModel(this.dataSource.getAuxiliaryObjectClasses());
        }
        return this.auxObjClassList;
    }

    private StringPairPropertySelectionModel buildSelectionModel(List<String> objClasses) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        String[] objects = objClasses.toArray(new String[0]);
        model.addAllStrings(objects);
        return model;
    }

    public List<TableRow> getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public void setAuxiliaryClasses(List<TableRow> auxiliaryClasses) {
        this.auxiliaryClasses = auxiliaryClasses;
    }

    public List<SimpleFieldDescriptor> getAuxiliaryClassesDescriptors() {
        return this.auxiliaryClassesDescriptors;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void onStateActivated() {
        DataStoreConfigTasklet tasklet = this.findParent(DataStoreConfigTasklet.class);
        LdapDataSource tempDataSource = (LdapDataSource)tasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
            this.dataSource = tempDataSource;
            this.resetAll();
        }
        this.AUX_OBJECT_CLASS_NAME.setModelValues(this.getAuxObjClassList());
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityProfile localIdentityProfile = (LocalIdentityProfile)dataFromDisk;
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        if (attributeSource != null) {
            this.dataSource = (LdapDataSource)attributeSource.getDataSource();
            this.createPattern = attributeSource.getParameter("create_pattern");
            this.objectClass = attributeSource.getParameter("object_class");
            this.isObjectClassDirty = false;
            this.auxiliaryClasses = this.createRowsForAuxObjectClasses(attributeSource);
        } else {
            this.resetAll();
        }
    }

    private List<TableRow> createRowsForAuxObjectClasses(AttributeSource attributeSource) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        if (attributeSource != null && attributeSource.getParameterMap().containsKey("auxiliary_object_classes")) {
            String[] auxClasses;
            for (String auxClass : auxClasses = StringUtils.split((String)attributeSource.getParameter("auxiliary_object_classes"), (char)',')) {
                ArrayList<FieldItem> items = new ArrayList<FieldItem>();
                items.add(new FieldItem(this.AUX_OBJECT_CLASS_NAME, auxClass));
                rows.add(new TableRow(items));
            }
        }
        return rows;
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile localIdentityProfile = (LocalIdentityProfile)dataToDisk;
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        attributeSource.setParameter("create_pattern", this.createPattern);
        attributeSource.setParameter("object_class", this.objectClass);
        String auxClassString = this.getAuxiliaryClassesString();
        if (StringUtils.isNotBlank((String)auxClassString)) {
            attributeSource.setParameter("auxiliary_object_classes", auxClassString);
        }
        this.isObjectClassDirty = false;
        return true;
    }

    @Override
    public void reset() {
        this.resetAll();
    }

    private void resetAll() {
        this.createPattern = "";
        this.objectClass = "";
        this.objClassList = new StringPairPropertySelectionModel();
        this.auxObjClassList = new StringPairPropertySelectionModel();
        this.isObjectClassDirty = true;
        this.auxiliaryClasses = new ArrayList<TableRow>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Relative DN Pattern", this.createPattern, this));
        summaryList.add(new SummaryInfo("Object Class", this.objectClass, this));
        for (TableRow row : this.auxiliaryClasses) {
            if (row.isMarkedForDelete()) continue;
            summaryList.add(new SummaryInfo("Auxiliary Object Class", row.getFields().get(0).getValue().trim(), this));
        }
        super.doSummary(summaryList);
    }

    private String getAuxiliaryClassesString() {
        return StringUtils.join(this.getAuxiliaryClassesList(), (char)',');
    }

    private List<String> getAuxiliaryClassesList() {
        List<String> names = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.auxiliaryClasses)) {
            names = this.auxiliaryClasses.stream().filter(field -> !field.isMarkedForDelete()).map(row -> row.getFields().get(0).getValue().trim()).collect(Collectors.toList());
        }
        return names;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        if (row.getFields().get(0).getValue() == null) {
            errors.add("Select an auxiliary object class from the dropdown.");
        } else {
            String newAuxClass = row.getFields().get(0).getValue().trim();
            if (this.getAuxiliaryClassesList().contains(newAuxClass)) {
                errors.add("Duplicate auxiliary object class '" + newAuxClass + "'.");
            }
        }
        return errors;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        LdapCreatePatternValidator ldapCreatePatternValidator;
        String fieldPath = "";
        if (this.isObjectClassDirty) {
            LdapObjectClassValidator ldapObjectClassVaidator = LdapObjectClassValidator.getInstance((String)this.objectClass, (LdapDataSource)this.dataSource, (String)"", (boolean)true);
            if (!ldapObjectClassVaidator.validate()) {
                this.recordErrors(ldapObjectClassVaidator.getErrors(), delegate);
            }
            this.isObjectClassDirty = false;
        }
        if (StringUtils.isBlank((String)this.createPattern)) {
            delegate.record(this.getMessage("create_pattern_required"), ValidationConstraint.REQUIRED);
            return;
        }
        LdapNameValidator ldapNameValidator = new LdapNameValidator(this.createPattern, this.getAvailableValues(), ApiMessageKey.local_identity_profile_data_store_create_pattern_malformed, ApiMessageKey.local_identity_profile_data_store_create_pattern_var_not_found, "");
        if (!ldapNameValidator.validate()) {
            this.recordErrors(ldapNameValidator.getErrors(), delegate);
        }
        if (!(ldapCreatePatternValidator = new LdapCreatePatternValidator(this.getCreatePattern(), this.getAvailableValues(), "")).validate()) {
            this.recordErrors(ldapCreatePatternValidator.getErrors(), delegate);
        }
    }
}

