/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityProfilesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.LocalIdentityProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityGeneralInfoState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private String id;
    private String name;
    private boolean profilePageEnabled = false;
    private boolean registrationEnabled = false;
    private String selectedApcName;
    private String selectedApcTypeAndId;

    public LocalIdentityGeneralInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("Profile Info");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.name)) {
            delegate.record(this.getMessage("name_empty"), ValidationConstraint.REQUIRED);
        } else if (this.isNameInUse()) {
            delegate.record(this.getMessage("duplicate_name", new Object[]{this.name}), ValidationConstraint.CONSISTENCY);
        }
        if (StringUtils.isBlank((String)this.selectedApcTypeAndId)) {
            delegate.record(this.getMessage("apc_required"), ValidationConstraint.REQUIRED);
        }
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        if (this.isProfilePageEnabled() && !localSettings.isEnableSP()) {
            delegate.record(this.getMessage("sp_role_required_for_profile"), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isNameInUse() {
        LocalIdentityProfilesState state = this.findParentState(LocalIdentityProfilesState.class);
        if (state != null) {
            return state.isDuplicateName((LocalIdentityProfileTasklet)this.getParent());
        }
        return false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Profile Name", this.name, this));
        summaryList.add(new SummaryInfo("Authentication Policy Contract", this.selectedApcName, this));
        summaryList.add(new SummaryInfo("Registration Enabled", Boolean.toString(this.registrationEnabled), this));
        summaryList.add(new SummaryInfo("Profile Management Enabled", Boolean.toString(this.profilePageEnabled), this));
    }

    @Override
    public void populate(Object obj) {
        LocalIdentityProfile profile = (LocalIdentityProfile)obj;
        this.id = profile.getId();
        this.name = profile.getName();
        this.profilePageEnabled = profile.isProfileEnabled();
        this.registrationEnabled = profile.isRegistrationEnabled();
        C2cContract contract = contractManager.getContract(profile.getContractId());
        this.setSelectedApcTypeAndId(new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT, contract.getId()).toString());
        this.setSelectedApcName(contract.getName());
    }

    @Override
    public boolean save(Object obj) {
        LocalIdentityProfile profile = (LocalIdentityProfile)obj;
        this.createIdIfNeeded();
        profile.setId(this.id);
        profile.setName(this.name);
        profile.setContractId(this.getSelectedApcId());
        profile.setProfileEnabled(this.profilePageEnabled);
        profile.setRegistrationEnabled(this.registrationEnabled);
        return true;
    }

    private void createIdIfNeeded() {
        if (this.id == null) {
            this.id = IDGenerator.rndAlphaNumeric((int)16);
        }
    }

    public String getSelectedApcId() {
        SelectedOption option = SelectionFilterList.parseSelectedOptionString(this.getSelectedApcTypeAndId());
        return option.getId();
    }

    public boolean isProfilePageEnabled() {
        return this.profilePageEnabled;
    }

    public void setProfilePageEnabled(boolean profilePageEnabled) {
        this.profilePageEnabled = profilePageEnabled;
    }

    public boolean isRegistrationEnabled() {
        return this.registrationEnabled;
    }

    public void setRegistrationEnabled(boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypesToAdd() {
        return Collections.singletonList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.AUTH_POLICY_CONTRACT);
    }

    public String getSelectedApcName() {
        return this.selectedApcName;
    }

    public void setSelectedApcName(String selectedApcName) {
        this.selectedApcName = selectedApcName;
    }

    public String getSelectedApcTypeAndId() {
        return this.selectedApcTypeAndId;
    }

    public void setSelectedApcTypeAndId(String selectedApcTypeAndId) {
        this.selectedApcTypeAndId = selectedApcTypeAndId;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (StringUtils.isBlank((String)this.selectedApcTypeAndId) || contractManager.getContract(this.getSelectedApcId()) == null) {
            this.setSelectedApcTypeAndId(null);
            this.setSelectedApcName(null);
        }
        super.setTaskletToEdit(taskletToEdit);
    }
}

