/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public class LocalIdentityProfilesState
extends TaskletListState {
    private static final long serialVersionUID = 12948832L;
    private final transient LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
    private static final Comparator<Tasklet> COMPARE_BY_NAME_DOWN = (Comparator & Serializable)(o1, o2) -> {
        LocalIdentityProfileTasklet tasklet1 = (LocalIdentityProfileTasklet)o1;
        LocalIdentityProfileTasklet tasklet2 = (LocalIdentityProfileTasklet)o2;
        return tasklet1.getProfileName().compareToIgnoreCase(tasklet2.getProfileName());
    };

    public LocalIdentityProfilesState(IWizard owner) {
        super(owner);
        this.setMenuName("Local Identity Profiles");
        this.buildTaskletList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.buildTaskletList();
    }

    private void buildTaskletList() {
        this.deleteAllTasklets();
        for (LocalIdentityProfile profile : this.profileManager.getProfiles()) {
            LocalIdentityProfileTasklet tasklet = this.createTaskletToLoad(LocalIdentityProfileTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(profile);
            this.addTasklet(tasklet);
        }
        this.sort(COMPARE_BY_NAME_DOWN);
    }

    public void createNewTasklet() {
        LocalIdentityProfileTasklet tasklet = this.createTaskletToLoad(LocalIdentityProfileTasklet.class, "LocalIdentityProfileTasklet", "Local Identity Profile");
        tasklet.setMode(Mode.create);
        tasklet.setFinishLabel("Save");
        tasklet.initialize();
        this.loadTasklet(tasklet);
    }

    public boolean isDuplicateName(LocalIdentityProfileTasklet currentTasklet) {
        for (Tasklet t : this.getTasklets()) {
            LocalIdentityProfileTasklet localIdentityProfileTasklet = (LocalIdentityProfileTasklet)t;
            if (currentTasklet.equals(localIdentityProfileTasklet) || !localIdentityProfileTasklet.getProfileName().equalsIgnoreCase(currentTasklet.getProfileName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        LocalIdentityProfileTasklet profileTasklet = (LocalIdentityProfileTasklet)this.getTasklet(taskletToDelete);
        profileTasklet.setItDeleted(true);
        String id = profileTasklet.getProfileId();
        if (id != null) {
            this.profileManager.deleteProfile(id);
        }
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        Tasklet tasklet = this.getTasklet(indexToEdit);
        tasklet.setFinishLabel("Save");
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            LocalIdentityProfileTasklet localIdentityProfileTasklet = (LocalIdentityProfileTasklet)t;
            if (localIdentityProfileTasklet.isItDeleted()) continue;
            localIdentityProfileTasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record("The Local Identity Profile " + localIdentityProfileTasklet.getProfileName() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }
}

