/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.ProfileConfig;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class ProfileConfigState
extends TaskletState {
    private boolean deleteIdentityEnabled;
    private String templateName;

    public ProfileConfigState(IWizard owner) {
        super(owner);
        this.setMenuName("Profile Management");
        this.templateName = "local.identity.profile.html";
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        ProfileConfig config = policy.getProfileConfig();
        if (config != null) {
            this.templateName = config.getTemplateName();
            this.deleteIdentityEnabled = config.isDeleteIdentityEnabled();
        } else {
            this.templateName = "local.identity.profile.html";
            this.deleteIdentityEnabled = false;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataToDisk;
        ProfileConfig config = policy.getProfileConfig();
        if (config == null) {
            config = new ProfileConfig();
            policy.setProfileConfig(config);
        }
        config.setTemplateName(this.templateName);
        config.setDeleteIdentityEnabled(this.deleteIdentityEnabled);
        return super.save(dataToDisk);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validateTemplateName(delegate);
    }

    private void validateTemplateName(IValidationDelegate delegate) {
        if (StringUtils.isBlank((String)this.templateName)) {
            delegate.record(this.getMessage("TemplateName_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        summaryList.add(new SummaryInfo("Profile Deletion Enabled", Boolean.toString(this.deleteIdentityEnabled), this));
        summaryList.add(new SummaryInfo("Profile Management Template", this.templateName, this));
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isDeleteIdentityEnabled() {
        return this.deleteIdentityEnabled;
    }

    public void setDeleteIdentityEnabled(boolean deleteIdentityEnabled) {
        this.deleteIdentityEnabled = deleteIdentityEnabled;
    }
}

