/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.ExecuteWorkflowSetting;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.RegistrationConfig;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class RegistrationConfigState
extends TaskletState {
    private static final PolicyFragmentManager policyFragmentManager = MgmtFactory.getPolicyFragmentManager();
    private static final CaptchaProviderPluginManager captchaProviderPluginManager = MgmtFactory.getCaptchaProviderPluginManager();
    private boolean enableCaptcha;
    private String captchaProviderId;
    private String templateName;
    private boolean enableMyDevice;
    private boolean createSessionPostRegistration = true;
    private String fieldForUsername;
    private String selectedRegistrationWorkflowTypeAndId;
    private String selectedRegistrationWorkflowName;
    private ExecuteWorkflowSetting executeWorkflowSetting = RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW;

    public RegistrationConfigState(IWizard owner) {
        super(owner);
        this.setMenuName("Registration");
        this.templateName = "local.identity.registration.html";
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        RegistrationConfig config = policy.getRegistrationConfig();
        this.templateName = config.getTemplateName();
        this.enableCaptcha = config.isCaptchaEnabled();
        this.captchaProviderId = config.getCaptchaProviderId();
        this.createSessionPostRegistration = config.isCreateSessionAfterRegistration();
        this.fieldForUsername = config.getFieldForUsername();
        this.enableMyDevice = config.isThisIsMyDeviceEnabled();
        PolicyFragment fragment = policyFragmentManager.getFragment(config.getRegistrationWorkflowFragmentId());
        if (fragment != null) {
            this.setSelectedRegistrationWorkflowName(fragment.getName());
            this.setSelectedRegistrationWorkflowTypeAndId(new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.POLICY_FRAGMENT, fragment.getId()).toString());
            this.executeWorkflowSetting = config.getExecuteWorkflowSetting();
            if (this.executeWorkflowSetting == null) {
                this.executeWorkflowSetting = RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW;
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataToDisk;
        RegistrationConfig config = policy.getRegistrationConfig();
        if (config == null) {
            config = new RegistrationConfig();
            policy.setRegistrationConfig(config);
        }
        config.setCaptchaEnabled(this.isEnableCaptcha());
        if (this.isEnableCaptcha()) {
            config.setCaptchaProviderId(this.captchaProviderId);
        }
        config.setTemplateName(this.templateName);
        config.setThisIsMyDeviceEnabled(this.enableMyDevice);
        config.setCreateSessionAfterRegistration(this.createSessionPostRegistration);
        if (this.createSessionPostRegistration) {
            config.setFieldForUsername(this.fieldForUsername);
        }
        if (this.getSelectedRegistrationWorkflowId() != null) {
            config.setRegistrationWorkflowFragmentId(this.getSelectedRegistrationWorkflowId());
            config.setExecuteWorkflowSetting(this.executeWorkflowSetting.getName());
        }
        return super.save(dataToDisk);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        summaryList.add(new SummaryInfo("Risk Enabled", Boolean.toString(this.enableCaptcha), this));
        if (this.isEnableCaptcha()) {
            String riskProviderLabel = "Risk Provider";
            if (StringUtils.isNotBlank((String)this.captchaProviderId)) {
                summaryList.add(new SummaryInfo(riskProviderLabel, this.getRiskProviderName(this.captchaProviderId), this));
            } else {
                summaryList.add(new SummaryInfo(riskProviderLabel, "Default", this));
            }
        }
        summaryList.add(new SummaryInfo("Registration Template", this.templateName, this));
        summaryList.add(new SummaryInfo("Enable 'This is My Device'", Boolean.toString(this.enableMyDevice), this));
        summaryList.add(new SummaryInfo("Create Session After Registration", Boolean.toString(this.createSessionPostRegistration), this));
        if (this.createSessionPostRegistration && StringUtils.isNotBlank((String)this.fieldForUsername)) {
            summaryList.add(new SummaryInfo("Username Field", this.fieldForUsername, this));
        }
        if (StringUtils.isNotEmpty((String)this.selectedRegistrationWorkflowName)) {
            summaryList.add(new SummaryInfo("Registration Workflow", this.selectedRegistrationWorkflowName, this));
            summaryList.add(new SummaryInfo("Execute Workflow", this.getExecuteWorkflowSetting().getFriendlyName(), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        String registrationTemplateName = "Registration Template";
        NotBlankValidator templateNameValidator = new NotBlankValidator(this.templateName, registrationTemplateName, null);
        if (!templateNameValidator.validate()) {
            this.recordErrors(templateNameValidator.getErrors(), delegate);
        }
        if (this.enableCaptcha) {
            CaptchaProviderInstance captchaProviderInstance = (CaptchaProviderInstance)captchaProviderPluginManager.getDefaultInstance();
            if (StringUtils.isBlank((String)this.captchaProviderId) && captchaProviderInstance == null) {
                this.recordErrorMsg(this.getMessage("Captcha_provider_required"));
            }
        }
        if (this.isCreateSessionPostRegistration() && StringUtils.isNotBlank((String)this.fieldForUsername) && !this.getCurrentFieldIds().contains(this.fieldForUsername)) {
            this.recordErrorMsg("The field selected as the username field no longer exists. Please choose another field or clear the field to accept default behavior");
        }
    }

    private List<String> getCurrentFieldIds() {
        List<LocalIdentityField<?>> fields = this.findParent(LocalIdentityProfileTasklet.class).getFields();
        return fields.stream().filter(field -> !field.isMarkedForDelete()).map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    public IPropertySelectionModel getFieldForUsernameSelectionList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        String[] fields = this.getCurrentFieldIds().toArray(new String[0]);
        model.addAllStrings(fields);
        return model;
    }

    public boolean isEnableCaptcha() {
        return this.enableCaptcha;
    }

    public void setEnableCaptcha(boolean enableCaptcha) {
        this.enableCaptcha = enableCaptcha;
    }

    public String getCaptchaProviderId() {
        return this.captchaProviderId;
    }

    public void setCaptchaProviderId(String captchaProviderId) {
        this.captchaProviderId = captchaProviderId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isShowCaptchaProvidersButton() {
        return this.enableCaptcha;
    }

    public boolean isEnableMyDevice() {
        return this.enableMyDevice;
    }

    public void setEnableMyDevice(boolean enableMyDevice) {
        this.enableMyDevice = enableMyDevice;
    }

    public boolean isCreateSessionPostRegistration() {
        return this.createSessionPostRegistration;
    }

    public void setCreateSessionPostRegistration(boolean createSessionPostRegistration) {
        this.createSessionPostRegistration = createSessionPostRegistration;
    }

    public String getFieldForUsername() {
        return this.fieldForUsername;
    }

    public void setFieldForUsername(String fieldForUsername) {
        this.fieldForUsername = fieldForUsername;
    }

    public String getSelectedRegistrationWorkflowTypeAndId() {
        return this.selectedRegistrationWorkflowTypeAndId;
    }

    public void setSelectedRegistrationWorkflowTypeAndId(String selectedRegistrationWorkflowTypeAndId) {
        this.selectedRegistrationWorkflowTypeAndId = selectedRegistrationWorkflowTypeAndId;
    }

    public String getSelectedRegistrationWorkflowId() {
        String registrationWorkflowId = this.getSelectedRegistrationWorkflowTypeAndId();
        if (registrationWorkflowId != null) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(this.getSelectedRegistrationWorkflowTypeAndId());
            return option.getId();
        }
        return null;
    }

    public String getSelectedRegistrationWorkflowName() {
        return this.selectedRegistrationWorkflowName;
    }

    public void setSelectedRegistrationWorkflowName(String selectedRegistrationWorkflowName) {
        this.selectedRegistrationWorkflowName = selectedRegistrationWorkflowName;
    }

    public void removeRegistrationWorkflow() {
        this.setSelectedRegistrationWorkflowName(null);
        this.setSelectedRegistrationWorkflowTypeAndId(null);
        this.setExecuteWorkflowSetting(RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW);
    }

    public ExecuteWorkflowSetting getExecuteWorkflowSetting() {
        return this.executeWorkflowSetting;
    }

    public void setExecuteWorkflowSetting(ExecuteWorkflowSetting executeWorkflowSetting) {
        this.executeWorkflowSetting = executeWorkflowSetting;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypesToAdd() {
        return Collections.singletonList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.POLICY_FRAGMENT);
    }

    public IPropertySelectionModel getCaptchaProviderSelectionList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel("Default");
        captchaProviderPluginManager.getInstances().forEach(instance -> model.add(instance.getName(), instance.getId()));
        model.sort();
        return model;
    }

    private String getRiskProviderName(String captchaProviderId) {
        return ((CaptchaProviderInstance)captchaProviderPluginManager.getInstance(captchaProviderId)).getName();
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (StringUtils.isBlank((String)this.selectedRegistrationWorkflowTypeAndId) || policyFragmentManager.getFragment(this.getSelectedRegistrationWorkflowId()) == null) {
            this.setSelectedRegistrationWorkflowTypeAndId(null);
            this.setSelectedRegistrationWorkflowName(null);
            this.setExecuteWorkflowSetting(RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW);
        }
        super.setTaskletToEdit(taskletToEdit);
    }
}

