/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity.fields;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.localidentity.FieldConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class FieldsConfigState
extends TaskletListState {
    private static final long serialVersionUID = 12948832L;
    private boolean maskOgnlValues = false;
    private String uniqueIdField;
    private boolean populated = false;
    private boolean stripSpaceFromUniqueField = true;

    public FieldsConfigState(IWizard owner) {
        super(owner);
        this.setMenuName("Fields");
    }

    public List<LocalIdentityField<?>> getFieldListCopy() {
        return this.getTasklets().stream().filter(tasklet -> !tasklet.isItDeleted()).map(tasklet -> ((FieldConfigTasklet)tasklet).getLocalIdentityField()).collect(Collectors.toList());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        delegate.setFormComponent(null);
        if (this.getFieldListCopy().isEmpty()) {
            delegate.record(this.getMessage("one_field_required"), ValidationConstraint.REQUIRED);
            return;
        }
        List<LocalIdentityField<?>> uniqueFields = this.getUniqueIdFields();
        if (uniqueFields.size() == 0) {
            delegate.record(this.getMessage("one_unique_field_required"), ValidationConstraint.REQUIRED);
        } else if (uniqueFields.size() > 1) {
            delegate.record(this.getMessage("only_one_unique_field_allowed"), ValidationConstraint.REQUIRED);
        }
        if (this.isRegistrationEnabled()) {
            if (uniqueFields.size() == 1 && !uniqueFields.get(0).getData().isRegistrationPageField()) {
                delegate.record(this.getMessage("one_registration_field_required"), ValidationConstraint.REQUIRED);
            }
            if (this.isRegistrationEnabled() && !this.hasOneFieldForRegistration()) {
                delegate.record(this.getMessage("one_registration_field_required"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile profile = (LocalIdentityProfile)dataToDisk;
        FieldConfig fieldConfig = new FieldConfig();
        fieldConfig.setMaskAllOgnlFields(this.maskOgnlValues);
        List fields = this.getTasklets().stream().filter(field -> !field.isItDeleted()).map(field -> ((FieldConfigTasklet)field).getLocalIdentityField()).collect(Collectors.toList());
        fieldConfig.setFieldList(fields);
        fieldConfig.setStripSpaceFromUniqueField(Boolean.valueOf(this.stripSpaceFromUniqueField));
        profile.setFieldConfig(fieldConfig);
        this.populated = false;
        return super.save(dataToDisk);
    }

    @Override
    public void onStateActivated() {
        if (!this.populated && this.getParent().isModeEdit()) {
            String lipId = this.getParent(LocalIdentityProfileTasklet.class).getProfileId();
            LocalIdentityProfile profile = MgmtFactory.getLocalIdentityProfileManager().getProfile(lipId);
            if (profile != null) {
                this.populate(profile);
            }
        }
        super.onStateActivated();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        super.populate(dataFromDisk);
        LocalIdentityProfile profile = (LocalIdentityProfile)dataFromDisk;
        this.getTasklets().clear();
        if (profile.getFieldConfig() != null && profile.getFieldConfig().getListOfAllFields() != null) {
            profile.getFieldConfig().getListOfAllFields().forEach(field -> {
                FieldConfigTasklet tasklet = new FieldConfigTasklet(this.getVisit(), false);
                tasklet.setMode(Mode.edit);
                tasklet.setParentTasklet(this.getParent());
                tasklet.populate(field);
                this.addTasklet(tasklet);
                if (field.isUniqueIdField()) {
                    this.uniqueIdField = field.getData().getId();
                }
            });
            this.stripSpaceFromUniqueField = profile.getFieldConfig().isStripSpaceFromUniqueField();
            this.maskOgnlValues = profile.getFieldConfig().isMaskAllOgnlFields();
        }
        this.populated = true;
    }

    private boolean hasOneFieldForRegistration() {
        return this.getFieldListCopy().stream().anyMatch(field -> field.getData().isRegistrationPageField());
    }

    public void createNewTasklet() {
        FieldConfigTasklet tasklet = this.createTaskletToLoad(FieldConfigTasklet.class);
        tasklet.setMode(Mode.create);
        tasklet.initialize();
        this.loadTasklet(tasklet);
    }

    private List<LocalIdentityField<?>> getUniqueIdFields() {
        return this.getFieldListCopy().stream().filter(LocalIdentityField::isUniqueIdField).collect(Collectors.toList());
    }

    public boolean isRegistrationEnabled() {
        return this.getParent(LocalIdentityProfileTasklet.class).isRegistrationEnabled();
    }

    public boolean isProfileEnabled() {
        return this.getParent(LocalIdentityProfileTasklet.class).isProfileEnabled();
    }

    public boolean isRegistrationAndProfileEnabled() {
        LocalIdentityProfileTasklet tasklet = this.getParent(LocalIdentityProfileTasklet.class);
        return tasklet.isRegistrationEnabled() && tasklet.isProfileEnabled();
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        Tasklet tasklet = this.getTasklet(indexToEdit);
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    public boolean isMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    public void setMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }

    public String getUniqueIdField() {
        return this.uniqueIdField;
    }

    public void setUniqueIdField(String uniqueIdField) {
        this.getTasklets().forEach(tasklet -> {
            FieldConfigTasklet fieldTasklet = (FieldConfigTasklet)tasklet;
            if (fieldTasklet.getFieldId().equals(uniqueIdField)) {
                fieldTasklet.setUnique(true);
            } else {
                fieldTasklet.setUnique(false);
            }
        });
        this.uniqueIdField = uniqueIdField;
    }

    public void moveUp(int index) {
        if (index > 0) {
            Tasklet item = this.getTasklets().get(index);
            this.getTasklets().set(index, this.getTasklets().get(index - 1));
            this.getTasklets().set(index - 1, item);
        }
    }

    public void moveDown(int index) {
        if (index < this.getTasklets().size() - 1) {
            Tasklet item = this.getTasklets().get(index);
            this.getTasklets().set(index, this.getTasklets().get(index + 1));
            this.getTasklets().set(index + 1, item);
        }
    }

    public void resetAppliesTo() {
        this.getTasklets().forEach(field -> {
            FieldConfigTasklet tasklet = (FieldConfigTasklet)field;
            tasklet.setShowOnProfile(this.isProfileEnabled());
            tasklet.setShowOnRegistration(this.isRegistrationEnabled());
        });
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void loadTasklet(Tasklet tasklet) {
        ((FieldConfigTasklet)tasklet).onLoad();
        super.loadTasklet(tasklet);
    }

    public boolean showOgnlBox() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        return expressionManager.isEvaluateExpressionsOn();
    }

    public boolean isStripSpaceFromUniqueField() {
        return this.stripSpaceFromUniqueField;
    }

    public void setStripSpaceFromUniqueField(boolean stripSpaceFromUniqueField) {
        this.stripSpaceFromUniqueField = stripSpaceFromUniqueField;
    }
}

