/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.BasePolicyManagementTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

@AutoSaveState
public abstract class BasePoliciesManagementState<T extends BasePolicyManagementTasklet>
extends TaskletListState {
    public BasePoliciesManagementState(IWizard owner) {
        super(owner);
    }

    public abstract void setDefaultId(String var1);

    public abstract String getDefaultId();

    public boolean isInUse(String id) {
        return false;
    }

    public List<Tasklet> getItems() {
        return this.getTasklets();
    }

    public Optional<T> getTaskletById(String id) {
        return this.getTasklets().stream().map(tasklet -> (BasePolicyManagementTasklet)tasklet).filter(tasklet -> StringUtils.equals((String)id, (String)tasklet.getId())).findFirst();
    }

    public void delete(String id) {
        this.getTaskletById(id).ifPresent(tasklet -> {
            tasklet.setItDeleted(true);
            tasklet.delete();
        });
    }

    public boolean isDefaultId(String id) {
        return StringUtils.equals((String)this.getDefaultId(), (String)id);
    }

    public boolean isDeleteAllowed(String id) {
        boolean moreThanOnePolicy = this.getTasklets().size() > 1;
        boolean defaultId = this.isDefaultId(id);
        return (!defaultId || !moreThanOnePolicy) && !this.isInUse(id);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        if (!this.isDefaultDefined()) {
            delegate.record(this.getMessage("Default_required"), ValidationConstraint.REQUIRED);
        }
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            BasePolicyManagementTasklet tasklet = (BasePolicyManagementTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record(tasklet.getId() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    private boolean isDefaultDefined() {
        int size = 0;
        for (Tasklet t : this.getTasklets()) {
            BasePolicyManagementTasklet tasklet = (BasePolicyManagementTasklet)t;
            if (tasklet.isItDeleted()) continue;
            ++size;
            if (!StringUtils.equals((String)tasklet.getId(), (String)this.getDefaultId())) continue;
            return true;
        }
        return size == 0;
    }
}

