/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.GeneratorGroupBasicsValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.oauth.exchange.GeneratorPoliciesManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class GeneratorPolicyManagementState
extends TaskletState {
    private static final String MENU_NAME = "Manage Generator Group";
    private static final long serialVersionUID = 2019103102L;
    private final transient TokenExchangeGeneratorPolicyManager generatorPolicyManager = MgmtFactory.getTokenExchangeGeneratorPolicyManager();
    private String id;
    private String name;
    private List<String> resourceUris = new ArrayList<String>();
    private transient Object resourceUrisComponentState;

    public GeneratorPolicyManagementState(IWizard owner) {
        super(owner);
        this.setMenuName(MENU_NAME);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getResourceUris() {
        return this.resourceUris;
    }

    public void setResourceUris(List<String> resourceUris) {
        this.resourceUris = resourceUris;
    }

    public Object getResourceUrisComponentState() {
        return this.resourceUrisComponentState;
    }

    public void setResourceUrisComponentState(Object resourceUrisComponentState) {
        this.resourceUrisComponentState = resourceUrisComponentState;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.resourceUrisComponentState = null;
        TokenExchangeGeneratorPolicy policy = (TokenExchangeGeneratorPolicy)dataFromDisk;
        this.id = policy.getId();
        this.name = policy.getName();
        this.resourceUris = new ArrayList<String>(policy.getResourceUris());
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenExchangeGeneratorPolicy policy = (TokenExchangeGeneratorPolicy)dataToDisk;
        this.fillDomain(policy);
        this.setDefaultIfNeeded(policy.getId());
        this.resourceUrisComponentState = null;
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("ID", this.getId(), this));
        summaryList.add(new SummaryInfo("Name", this.getName(), this));
        for (String item : this.resourceUris) {
            summaryList.add(new SummaryInfo("Resource URI", item, this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Set existingIds = this.generatorPolicyManager.getTokenExchangeGeneratorPolicies().getPolicyIds();
        Set existingNames = this.generatorPolicyManager.getTokenExchangeGeneratorPolicies().getPolicyNames();
        String currentName = this.generatorPolicyManager.getTokenExchangeGeneratorPolicies().containsInstance(this.id) ? this.generatorPolicyManager.getTokenExchangeGeneratorPolicies().getPolicy(this.id).getName() : null;
        GeneratorGroupBasicsValidator validator = new GeneratorGroupBasicsValidator(this.id, this.name, this.isCreateMode(), existingIds, existingNames, currentName, this.resourceUris);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    private void fillDomain(TokenExchangeGeneratorPolicy policy) {
        policy.setId(this.id);
        policy.setName(this.name);
        policy.setResourceUris(new ArrayList<String>(this.resourceUris));
    }

    private void setDefaultIfNeeded(String id) {
        this.getParent().getParentTasklet().getStateList().stream().filter(taskletState -> taskletState instanceof GeneratorPoliciesManagementState).map(taskletState -> (GeneratorPoliciesManagementState)taskletState).findFirst().ifPresent(state -> {
            if (StringUtils.isEmpty((String)state.getDefaultId())) {
                state.setDefaultId(id);
            }
        });
    }
}

