/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.GeneratorGroupTokenTypeValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.util.TokenExchangeTokenTypeLookupUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class GeneratorTokenTypeState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final String MENU_NAME = "Requested Token Type Mapping";
    private final TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
    private List<TableRow> tokenTypeTableRows = new ArrayList<TableRow>();
    private final SimpleFieldDescriptor TOKEN_TYPE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Token Type", 300);
    private final SimpleFieldDescriptor TOKEN_GENERATOR = new TokenGeneratorDescriptor("Token Generator", 300, this.tokenGeneratorManager);
    protected Object componentState;

    public GeneratorTokenTypeState(IWizard owner) {
        super(owner);
        this.setMenuName(MENU_NAME);
    }

    public List<TableRow> getTokenTypeTableRows() {
        return this.tokenTypeTableRows;
    }

    public void setTokenTypeTableRows(List<TableRow> tokenTypeTableRows) {
        this.tokenTypeTableRows = tokenTypeTableRows;
    }

    public List<SimpleFieldDescriptor> getTokenTypeDescriptors() {
        return Arrays.asList(this.TOKEN_GENERATOR, this.TOKEN_TYPE);
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> messages = new ArrayList<String>();
        if (row.getField(this.TOKEN_TYPE) == null || StringUtils.isBlank((String)row.getField(this.TOKEN_TYPE).getValue())) {
            messages.add("Token Type is required.");
        }
        if (row.getField(this.TOKEN_GENERATOR) == null || StringUtils.isBlank((String)row.getField(this.TOKEN_GENERATOR).getValue())) {
            messages.add("Token Generator is required.");
        }
        boolean performTokenTypeDuplicateValidation = true;
        if (originalRow != null && originalRow.getField(this.TOKEN_TYPE) != null && originalRow.getField(this.TOKEN_TYPE).getValue() != null && originalRow.getField(this.TOKEN_TYPE).getValue().equals(row.getField(this.TOKEN_TYPE).getValue())) {
            performTokenTypeDuplicateValidation = false;
        }
        if (performTokenTypeDuplicateValidation && row.getField(this.TOKEN_TYPE) != null) {
            list.stream().filter(item -> {
                FieldItem field = item.getField(this.TOKEN_TYPE);
                return field.getValue() != null && field.getValue().equals(row.getField(this.TOKEN_TYPE).getValue());
            }).findFirst().ifPresent(item -> {
                String msg = String.format("'%s' Token Type already exists", row.getField(this.TOKEN_TYPE).getValue());
                messages.add(msg);
            });
        }
        return messages;
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenExchangeGeneratorPolicy policy = (TokenExchangeGeneratorPolicy)dataFromDisk;
        Function<TokenExchangeGeneratorMapping, TableRow> tokenExchangeGeneratorMapping2TableRowFunction = mapping -> {
            boolean isDefault = policy.getDefaultTokenType().equals(mapping.getTokenType());
            FieldItem tokenTypeField = new FieldItem(this.TOKEN_TYPE, mapping.getTokenType());
            FieldItem tokenGeneratorIdField = new FieldItem(this.TOKEN_GENERATOR, mapping.getTokenGeneratorId());
            TableRow tableRow = new TableRow(Arrays.asList(tokenGeneratorIdField, tokenTypeField));
            tableRow.setDefault(isDefault);
            return tableRow;
        };
        this.tokenTypeTableRows = policy.getMappings().stream().map(tokenExchangeGeneratorMapping2TableRowFunction).collect(Collectors.toList());
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenExchangeGeneratorPolicy policy = (TokenExchangeGeneratorPolicy)dataToDisk;
        this.tokenTypeTableRows.stream().filter(row -> !row.isMarkedForDelete()).filter(TableRow::isDefault).findFirst().ifPresent(row -> policy.setDefaultTokenType(row.getField(this.TOKEN_TYPE).getValue()));
        Function<TableRow, TokenExchangeGeneratorMapping> tableRow2TokenExchangeGeneratorMappingFunction = row -> {
            String tokenType = row.getField(this.TOKEN_TYPE).getValue();
            String tokenGeneratorId = row.getField(this.TOKEN_GENERATOR).getValue();
            TokenExchangeGeneratorMapping mapping = new TokenExchangeGeneratorMapping();
            mapping.setTokenType(StringUtils.trim((String)tokenType));
            mapping.setTokenGeneratorId(tokenGeneratorId);
            return mapping;
        };
        policy.setMappings(this.tokenTypeTableRows.stream().filter(row -> !row.isMarkedForDelete()).map(tableRow2TokenExchangeGeneratorMappingFunction).collect(Collectors.toList()));
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        Function<TableRow, SummaryInfo> tableRow2SummaryInfoFunction = row -> {
            Object name = row.isDefault() ? row.getField(this.TOKEN_TYPE).getValue() + " (default)" : row.getField(this.TOKEN_TYPE).getValue();
            String tokenGeneratorId = row.getField(this.TOKEN_GENERATOR).getValue();
            TokenGeneratorInstance tokenGeneratorInstance = (TokenGeneratorInstance)this.tokenGeneratorManager.getInstance(tokenGeneratorId);
            String value = tokenGeneratorInstance != null ? tokenGeneratorInstance.getName() : "";
            return new SummaryInfo((String)name, value, this);
        };
        summaryList.addAll(this.tokenTypeTableRows.stream().filter(row -> !row.isMarkedForDelete()).map(tableRow2SummaryInfoFunction).collect(Collectors.toList()));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        String defaultTokenType = null;
        ArrayList<GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair> pairs = new ArrayList<GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair>();
        for (TableRow tableRow : this.tokenTypeTableRows) {
            if (tableRow.isMarkedForDelete()) continue;
            if (tableRow.getField(this.TOKEN_TYPE) != null && tableRow.isDefault()) {
                defaultTokenType = tableRow.getField(this.TOKEN_TYPE).getValue();
            }
            if (tableRow.getField(this.TOKEN_TYPE) == null || tableRow.getField(this.TOKEN_GENERATOR) == null) continue;
            pairs.add(new GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair(tableRow.getField(this.TOKEN_TYPE).getValue(), tableRow.getField(this.TOKEN_GENERATOR).getValue()));
        }
        GeneratorGroupTokenTypeValidator validator = new GeneratorGroupTokenTypeValidator(this.tokenGeneratorManager, defaultTokenType, pairs);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        TableRow updateItem = ((TableEditor.State)this.componentState).getUpdateItem();
        TableRow newItem = ((TableEditor.State)this.componentState).getNewItem();
        boolean isEditMode = ((TableEditor.State)this.componentState).isEditMode();
        if (isEditMode) {
            if (updateItem.getField(this.TOKEN_TYPE) != null && updateItem.getField(this.TOKEN_GENERATOR) != null) {
                this.autoPopulateTokenType(updateItem);
            }
        } else if (newItem != null && newItem.getField(this.TOKEN_TYPE) != null && newItem.getField(this.TOKEN_GENERATOR) != null) {
            this.autoPopulateTokenType(newItem);
        }
    }

    private void autoPopulateTokenType(TableRow updateItem) {
        TokenExchangeTokenTypeLookupUtil util = new TokenExchangeTokenTypeLookupUtil();
        String tokenGenerator = updateItem.getField(this.TOKEN_GENERATOR).getValue();
        String tokenValue = updateItem.getField(this.TOKEN_TYPE).getValue();
        if (StringUtils.isNotBlank((String)tokenGenerator) && StringUtils.isBlank((String)tokenValue)) {
            updateItem.getField(this.TOKEN_TYPE).setValue(util.getTokenGeneratorTokenExchangeTokenType(tokenGenerator, this.tokenGeneratorManager));
        }
    }

    private static class TokenGeneratorDescriptor
    extends SimpleFieldDescriptor {
        private final TokenGeneratorManager tokenGeneratorManager;

        TokenGeneratorDescriptor(String name, int width, TokenGeneratorManager tokenGeneratorManager) {
            super(SimpleFieldDescriptor.FieldType.DROPDOWN, name, width, false, true);
            this.tokenGeneratorManager = tokenGeneratorManager;
        }

        @Override
        public IPropertySelectionModel getModelValues() {
            StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
            for (TokenGeneratorInstance instance : this.tokenGeneratorManager.getInstances()) {
                model.add(instance.getName(), instance.getId());
            }
            return model;
        }
    }
}

