/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.pingone.InvalidAccessTokenException;
import com.pingidentity.pingone.PingOneAdminService;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractConnectToP1State
extends TaskletState {
    PingOneAdminService service = MgmtFactory.getPingOneAdminService();
    private String authKey;
    private String authKeyURL = this.service.getMetadata().getActivationKeyUrl();

    public AbstractConnectToP1State(IWizard owner) {
        super(owner);
    }

    protected boolean associateWithKey(String authKey, IValidationDelegate delegate) {
        try {
            this.service.associate(authKey, this.getLoginUrl());
            return true;
        }
        catch (InvalidAccessTokenException e) {
            this.log.debug((Object)("Invalid access token while creating association with remote admin service: " + e));
            delegate.setFormComponent(null);
            delegate.record(this.getMessageWithFullKey("shared_message_activation_key_invalid"), ValidationConstraint.REQUIRED);
            return false;
        }
        catch (IOException e) {
            this.log.error((Object)"Unexpected error while creating association with remote admin service", (Throwable)e);
            delegate.setFormComponent(null);
            delegate.record(this.getMessageWithFullKey("shared_message_service_unavailable"), ValidationConstraint.REQUIRED);
            return false;
        }
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = StringUtils.trim((String)authKey);
    }

    public String getAuthKeyURL() {
        return this.authKeyURL;
    }

    public boolean isAssociated() {
        return this.service.isAssociated();
    }

    public void dissociate() {
        this.service.disassociate();
    }

    public String getLoginUrl() {
        return this.getRequestContext().getRequestURL().toString();
    }

    public void disconnect(IRequestCycle requestCycle) {
        this.clearState();
        this.dissociate();
    }

    public String getCompanyName() {
        return this.service.getMetadata().getPingOneCompanyName();
    }

    abstract void clearState();
}

