/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractDirectoryConfigState;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.InitialSetupTasklet;
import com.pingidentity.pingone.PingOneSpConnectionBuilder;
import com.pingidentity.util.ProvisionerGlobalSettingsHelper;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdentitiesConfigState
extends AbstractDirectoryConfigState {
    private static final String DIRECTORY_TYPE = "directory";
    private static final String SIMPLE_TYPE = "simple";
    private String identitiesType = "";
    private boolean showSpConnTemplate = false;
    private String directoryNote = "Please complete these fields to use LDAP for user lookup and credential validation";
    private String simplePcvNote = "If you are using PingID with VPN or you want to quickly get PingFederate functioning as a test identity repository, you don't need to connect to a directory.";

    public IdentitiesConfigState(IWizard owner) {
        super(owner);
        this.setMenuName("Identities");
        this.setNoteKey("IdentitiesConfigState_Note");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.identitiesType)) {
            IdentitiesConfigState.recordErrorMsg("You must select an option.", delegate);
        }
        if (this.isDirectorySelected()) {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.isDirectorySelected()) {
            return super.save(dataToDisk);
        }
        return true;
    }

    @Override
    public boolean onStateExit() {
        if (this.isDirectorySelected()) {
            return super.onStateExit();
        }
        return true;
    }

    @Override
    public boolean isDirectoryConfigured() {
        return this.isDirectorySelected();
    }

    public boolean isDirectorySelected() {
        return DIRECTORY_TYPE.equals(this.getIdentitiesType());
    }

    public static String getDirectoryType() {
        return DIRECTORY_TYPE;
    }

    public static String getSimpleType() {
        return SIMPLE_TYPE;
    }

    public String getIdentitiesType() {
        return this.identitiesType;
    }

    public void setIdentitiesType(String identitiesType) {
        if (identitiesType.equals(SIMPLE_TYPE)) {
            this.resetOutgoingTransitions();
        }
        if (identitiesType.equals(DIRECTORY_TYPE)) {
            this.addOutgoingTransitions();
        }
        this.identitiesType = identitiesType;
    }

    private void addOutgoingTransitions() {
        if (!this.doesLdapConfirmPageExist() && this.getLdapsState() != null) {
            this.getLdapsState().addOutgoingTransition(this.getOutgoingTransition());
            this.clearOutgoingTransitions();
            this.addOutgoingTransition(this.getParent(), this.getLdapsState());
        }
    }

    private void resetOutgoingTransitions() {
        if (this.doesLdapConfirmPageExist()) {
            this.clearOutgoingTransitions();
            this.addOutgoingTransition(this.getParent(), this.getParent(InitialSetupTasklet.class).getIdentitiesDefaultNextState());
        }
    }

    @Override
    public boolean isNextEnabled() {
        if (StringUtils.isBlank((String)this.getIdentitiesType())) {
            return false;
        }
        return !this.isDirectorySelected() || super.isNextEnabled();
    }

    public boolean isShowSpConnTemplate() {
        return this.showSpConnTemplate;
    }

    public void showSpConnTemplate(boolean showSpConnTemplate) {
        this.showSpConnTemplate = showSpConnTemplate;
    }

    public String getDirectoryNote() {
        return this.directoryNote;
    }

    public void setDirectoryNote(String directoryNote) {
        this.directoryNote = directoryNote;
    }

    public String getSimplePcvNote() {
        return this.simplePcvNote;
    }

    public void setSimplePcvNote(String simplePcvNote) {
        this.simplePcvNote = simplePcvNote;
    }

    public void goToPrePopulatedSPConnection() {
        PingOneSpConnectionBuilder pingOneSpConnectionBuilder = null;
        try {
            pingOneSpConnectionBuilder = new PingOneSpConnectionBuilder(this.isActiveDirectory());
            SpConnection spConnection = pingOneSpConnectionBuilder.getConnection();
            AbstractPingOneSetupTasklet tasklet = this.findParent(AbstractPingOneSetupTasklet.class);
            tasklet.saveEntityIdState();
            if (ProvisionerGlobalSettingsHelper.canEnableProvisioning()) {
                ProvisionerGlobalSettingsHelper.enableProvisioning();
                MgmtFactory.getPingOneAdminService().getSpConnectionFactory().addProvisioningToConnection(spConnection, null);
            }
        }
        catch (IOException e) {
            this.recordErrorMsg(this.getMessageWithFullKey("IdentityStoreConfigState_unable_to_get_conn"));
            return;
        }
        SpConnectionConfigTasklet spConnTasklet = new SpConnectionConfigTasklet(this.getVisit());
        spConnTasklet.populate(pingOneSpConnectionBuilder.getConnection());
        spConnTasklet.setExistingConnection(false);
        spConnTasklet.setSummaryStateClickable(false);
        this.getParent().swapTasklet(spConnTasklet);
        spConnTasklet.getCurrentState().onStateActivated();
    }
}

