/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.validator.KerberosRealmValidator;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.common.util.KerberosUtilFactory;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KerberosAuthenticationState
extends AbstractSetupState {
    static final String SELECT_OPTION = "- Select - ";
    private static final Set<String> SELECT_OPTION_LIST = new HashSet<String>(Collections.singletonList("- Select - "));
    private boolean configureKerberos;
    private KerberosRealm realm;
    private String realmName;
    private String realmUsername;
    private String realmPassword;
    private String kdcHostname;
    private String currentHostname;
    private String selectedHostname;
    private String ipRange;
    private String currentRange;
    private String selectedRange;
    private List<String> hostnames = new LinkedList<String>();
    private Set<String> ipRanges = new HashSet<String>();
    private final KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
    private boolean testSuccessful = false;

    public KerberosAuthenticationState(IWizard owner) {
        super(owner);
        this.setMenuName("Kerberos Authentication");
        this.realm = new KerberosRealm();
        this.realm.setId("KERB-" + HexBin.bytesToString((byte[])IDGenerator.generateBytes((int)20)));
        this.realm.setKeyDistributionCenters(this.hostnames);
        this.setNoteKey("KerberosAuthenticationState_note");
    }

    @Override
    public void populate(Object dataFromDisk) {
        KerberosStateData kerbData = (KerberosStateData)((Map)dataFromDisk).get(this.getClass().getCanonicalName());
        if (kerbData != null) {
            this.realm = kerbData.getRealm();
            this.realmName = this.realm.getKerberosRealmName();
            this.realmPassword = this.realm.getKerberosPassword();
            this.realmUsername = this.realm.getKerberosUsername();
            this.hostnames = this.realm.getKeyDistributionCenters();
            this.setConfigureKerberos(kerbData.isKerberosEnabled());
            this.ipRanges = kerbData.getIpRanges();
        }
    }

    public KerberosStateData getCurrentData() {
        KerberosStateData currentData = new KerberosStateData();
        currentData.setKerberosEnabled(this.configureKerberos);
        currentData.setRealm(this.realm);
        currentData.setIpRanges(this.ipRanges);
        return currentData;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isConfigureKerberos()) {
            this.checkKerbSettings();
            if (this.ipRanges != SELECT_OPTION_LIST && this.ipRanges.size() < 1) {
                this.recordErrorMsg(this.getMessage("need_at_least_one_iprange"));
            }
        }
    }

    private boolean checkKerbSettings() {
        KerberosRealmValidator validator = new KerberosRealmValidator.Builder().setConnectionType(KerberosConnectionType.DIRECT).setKerberosRealmName(this.getRealmName()).setKerberosUsername(this.getRealmUsername()).setKerberosPassword(this.getRealmPassword()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
            return false;
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.isConfigureKerberos()) {
            this.kerberosRealmManager.saveKerberosRealm(this.realm);
        }
        return super.save(dataToDisk);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Enabled"), Boolean.toString(this.isConfigureKerberos()), this));
        if (this.isConfigureKerberos()) {
            summaryList.add(new SummaryInfo(this.getMessage("realm_name"), this.getRealmName(), this));
            summaryList.add(new SummaryInfo(this.getMessage("realm_username"), this.getRealmUsername(), this));
            if (this.getIpRanges() != SELECT_OPTION_LIST) {
                for (String range : this.getIpRanges()) {
                    summaryList.add(new SummaryInfo(this.getMessage("ip_range"), range, this));
                }
            }
            if (this.getHostnames() != SELECT_OPTION_LIST) {
                for (String hostname : this.getHostnames()) {
                    summaryList.add(new SummaryInfo(this.getMessage("kdc_hostname"), hostname, this));
                }
            }
        }
        super.doSummary(summaryList);
    }

    public boolean isConfigureKerberos() {
        return this.configureKerberos;
    }

    public void setConfigureKerberos(boolean configureKerberos) {
        this.configureKerberos = configureKerberos;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realm.setKerberosRealmName(realmName);
        this.realmName = realmName;
    }

    public String getRealmUsername() {
        return this.realmUsername;
    }

    public void setRealmUsername(String realmUsername) {
        this.realm.setKerberosUsername(realmUsername);
        this.realmUsername = realmUsername;
    }

    public String getRealmPassword() {
        return this.realmPassword;
    }

    public void setRealmPassword(String realmPassword) {
        this.realm.setKerberosPassword(realmPassword);
        this.realmPassword = realmPassword;
    }

    public String getKdcHostname() {
        return this.kdcHostname;
    }

    public void setKdcHostname(String kdcHostname) {
        this.kdcHostname = kdcHostname;
    }

    public String getIpRange() {
        return this.ipRange;
    }

    public void setIpRange(String ipRange) {
        this.ipRange = ipRange;
    }

    public void addHostname() {
        if (!StringUtils.isBlank((String)this.getKdcHostname())) {
            this.hostnames.add(this.getKdcHostname());
        }
        this.setKdcHostname(null);
    }

    public void deleteHostname() {
        this.hostnames.remove(this.selectedHostname);
    }

    public void addIpRange() {
        if (!StringUtils.isBlank((String)this.getIpRange())) {
            try {
                new SubnetUtils(this.getIpRange());
                this.ipRanges.add(this.getIpRange());
                this.setIpRange(null);
            }
            catch (IllegalArgumentException ex) {
                this.recordErrorMsg(this.getMessage("invalid_ip_range"));
            }
        }
    }

    public void deleteIpRange() {
        this.ipRanges.remove(this.selectedRange);
    }

    public Set<String> getIpRanges() {
        if (this.ipRanges.isEmpty()) {
            return SELECT_OPTION_LIST;
        }
        return this.ipRanges;
    }

    public String getCurrentRange() {
        return this.currentRange;
    }

    public void setCurrentRange(String currentRange) {
        this.currentRange = currentRange;
    }

    public boolean getIsRangeSelected() {
        return false;
    }

    public void setIsRangeSelected(String ipRangeSelected) {
        if (Boolean.parseBoolean(ipRangeSelected)) {
            this.selectedRange = this.getCurrentRange();
        }
    }

    public Set<String> getHostnames() {
        if (this.hostnames.isEmpty()) {
            return SELECT_OPTION_LIST;
        }
        return new HashSet<String>(this.hostnames);
    }

    public String getCurrentHostname() {
        return this.currentHostname;
    }

    public void setCurrentHostname(String currentHostname) {
        this.currentHostname = currentHostname;
    }

    public boolean isHostnameSelected() {
        return false;
    }

    public boolean getIsHostnameSelected() {
        return false;
    }

    public void setIsHostnameSelected(String hostnameSelected) {
        if (Boolean.parseBoolean(hostnameSelected)) {
            this.selectedHostname = this.getCurrentHostname();
        }
    }

    public KerberosRealm getKerberosRealm() {
        return this.realm;
    }

    public void testRealm() {
        if (this.checkKerbSettings()) {
            try {
                KerberosUtil kerberosUtil = KerberosUtilFactory.getKerberosUtil((KerberosRealm)this.getKerberosRealm());
                KerberosRealmsSettings kerberosRealmsSettings = new KerberosRealmsSettings();
                kerberosRealmsSettings.setDebugLogOutput("debug");
                kerberosRealmsSettings.setForceTcp("true");
                kerberosRealmsSettings.setKdcTimeout("15000");
                kerberosRealmsSettings.setKdcRetries("3");
                kerberosUtil.testKerberosRealm(kerberosRealmsSettings, true);
                this.testSuccessful = true;
            }
            catch (KerberosException ex) {
                String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                this.recordErrorMsg(this.getMessageWithFullKey("KerberosRealmState_Error_testing_kerberos_realm", new Object[]{message}));
                this.testSuccessful = false;
            }
        }
    }

    public boolean isTestSuccessful() {
        return this.testSuccessful;
    }

    public void setTestSuccessful(boolean ignore) {
        if (!this.getParent().getCycle().isRewinding()) {
            this.testSuccessful = false;
        }
    }

    private static class KerberosStateData {
        private boolean isKerberosEnabled;
        private KerberosRealm realm;
        private Set<String> ipRanges;

        private KerberosStateData() {
        }

        public boolean isKerberosEnabled() {
            return this.isKerberosEnabled;
        }

        public void setKerberosEnabled(boolean kerberosEnabled) {
            this.isKerberosEnabled = kerberosEnabled;
        }

        public KerberosRealm getRealm() {
            return this.copyRealm(this.realm);
        }

        public void setRealm(KerberosRealm currentRealm) {
            this.realm = this.copyRealm(currentRealm);
        }

        private KerberosRealm copyRealm(KerberosRealm realm) {
            KerberosRealm copiedRealm = new KerberosRealm();
            copiedRealm.setId(realm.getId());
            copiedRealm.setKeyDistributionCenters(new LinkedList(realm.getKeyDistributionCenters()));
            copiedRealm.setKerberosPassword(realm.getKerberosPassword());
            copiedRealm.setKerberosRealmName(realm.getKerberosRealmName());
            copiedRealm.setKerberosUsername(realm.getKerberosUsername());
            return copiedRealm;
        }

        public Set<String> getIpRanges() {
            return this.ipRanges;
        }

        public void setIpRanges(Set<String> ipRanges) {
            this.ipRanges = new HashSet<String>(ipRanges);
        }
    }
}

