/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.validator.LdapConfigValidator;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Set;
import javax.naming.NamingException;
import javax.net.ssl.X509TrustManager;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class LdapsConfirmationState
extends AbstractSetupState {
    private transient IUploadFile certFile;
    private Cert certificate;
    private String certFilename;
    private boolean isNonSSLConnectionAvailable;
    private boolean needToImportCertificate;
    private boolean continueWithoutSSL;
    private String rootIssuerDN;
    private final LdapDataSource ldapDataSource;
    private static final LdapConfigValidator ldapConfigValidator = new LdapConfigValidator();
    private final TrustedCAsManager trustedCAManager = MgmtFactory.getTrustedCAsManager();

    public LdapsConfirmationState(IWizard owner, LdapDataSource ldapDataSource) {
        super(owner);
        this.setMenuAndNote();
        this.ldapDataSource = ldapDataSource;
    }

    @Override
    public void onStateActivated() {
        this.setMenuAndNote();
        super.onStateActivated();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.certificate != null) {
            return this.addCertificateToTrustedCAs(this.certificate);
        }
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.certificate != null) {
            summaryList.add(new SummaryInfo("Imported Certificate", "", this, true));
            summaryList.add(new SummaryInfo(this.getMessage("subject_dn"), this.getCertSubjectDN(), this));
            summaryList.add(new SummaryInfo(this.getMessage("not_before"), this.getCertNotBeforeDate(), this));
            summaryList.add(new SummaryInfo(this.getMessage("not_after"), this.getCertExpirationDate(), this));
        }
    }

    public String getCertExpirationDate() {
        return this.certificate.getX509Certificate().getNotAfter().toString();
    }

    public String getCertNotBeforeDate() {
        return this.certificate.getX509Certificate().getNotBefore().toString();
    }

    public String getCertSubjectDN() {
        return this.certificate.getX509Certificate().getSubjectDN().getName();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validateCertificate(delegate);
        if (!this.isShowNonSslWarning()) {
            if (this.isNonSSLConnectionAvailable()) {
                if (this.certificate == null && !this.isContinueWithoutSSL()) {
                    LdapsConfirmationState.recordErrorMsg(this.getMessage("cert_or_non_ssl_required"), delegate);
                }
                if (this.certificate != null && this.isContinueWithoutSSL()) {
                    LdapsConfirmationState.recordErrorMsg(this.getMessage("only_one_option_allowed"), delegate);
                    this.reset();
                }
            } else if (this.certificate == null) {
                LdapsConfirmationState.recordErrorMsg(this.getMessage("cert_required"), delegate);
            }
        }
    }

    public void validateCertificate() {
        this.validateCertificate((IValidationDelegate)this.getDelegate());
    }

    public void validateCertificate(IValidationDelegate delegate) {
        if (this.certFile != null && this.certFile.getSize() > 0L) {
            this.certFilename = this.certFile.getFileName();
            InputStream stream = this.certFile.getStream();
            CertificateValidator validator = new CertificateValidator(stream, null, this.trustedCAManager.getTrustedCAs(), true);
            if (!validator.validate()) {
                this.resetCertificates();
                this.recordErrors(validator.getErrors(), delegate);
                return;
            }
            this.certificate = validator.getCert();
            try {
                this.testConnectionWithNewCert();
            }
            catch (SecretManagerException | NamingException e) {
                this.resetCertificates();
                LdapsConfirmationState.recordErrorMsg(this.getMessage("Unable_to_communicate_with_datastore"), delegate);
            }
        }
    }

    @Override
    public void reset() {
        this.resetCertificates();
        this.setContinueWithoutSSL(false);
        super.reset();
    }

    private void resetCertificates() {
        this.certFile = null;
        this.certificate = null;
        this.certFilename = "";
    }

    public boolean testConnection() {
        try {
            if (this.certificate != null) {
                this.testConnectionWithNewCert();
            } else {
                this.ldapDataSource.isConnectionSuccessful();
            }
        }
        catch (SecretManagerException | NamingException e) {
            this.log.error((Object)"Test connection failure", e);
            return false;
        }
        return true;
    }

    private void testConnectionWithNewCert() throws NamingException, SecretManagerException {
        this.log.debug((Object)("Testing LDAP connection with the certificate (" + this.certificate.getX509Certificate().getSubjectDN() + ") as a trusted CA."));
        PingSslClientTrustManager sslSocketFactory = PingSslClientTrustManager.getInstance();
        Set trustedCAs = this.trustedCAManager.getTrustedCaX509s();
        trustedCAs.addAll(this.trustedCAManager.getJmvTrustedCAs());
        trustedCAs.add(this.certificate.getX509Certificate());
        X509TrustManager trustManager = sslSocketFactory.createTrustManagerWithCAs(trustedCAs);
        this.ldapDataSource.setUseSSL(true);
        ldapConfigValidator.testConnection(this.ldapDataSource, ldapConfigValidator.getSslSocketFactory(trustManager));
    }

    public boolean addCertificateToTrustedCAs(Cert certificate) {
        if (certificate != null) {
            try {
                this.log.debug((Object)("Importing cert for " + certificate.getX509Certificate().getSubjectDN() + " as trusted certificate authority."));
                Cert cert = Cert.importCert((byte[])certificate.getEncoded());
                this.trustedCAManager.saveTrustedCA(cert);
            }
            catch (CertificateException e) {
                this.log.error((Object)"Error importing certificate.");
                return false;
            }
        } else {
            this.log.debug((Object)"No server cert was found to import, skipping.");
        }
        return true;
    }

    private void setMenuAndNote() {
        if (this.isShowNonSslWarning()) {
            this.setMenuName("Unsecure Connection");
            this.setNoteKey("DirectorySetupTasklet_LdapsConfirmationState_non_secure");
        } else {
            this.setMenuName("Certificate Error");
            if (this.isNonSSLConnectionAvailable()) {
                this.setNoteKey("DirectorySetupTasklet_LdapsConfirmationState_certificate_with_optout");
            } else {
                this.setNoteKey("DirectorySetupTasklet_LdapsConfirmationState_certificate");
            }
        }
    }

    public boolean shouldNextButtonBeEnabled() {
        return this.isShowNonSslWarning() || this.certificate != null || this.continueWithoutSSL;
    }

    public IUploadFile getCertFile() {
        return this.certFile;
    }

    public void setCertFile(IUploadFile certFile) {
        this.certFile = certFile;
    }

    public void setNonSSLConnectionAvailable(boolean isNonSSLConnectionAvailable) {
        this.isNonSSLConnectionAvailable = isNonSSLConnectionAvailable;
    }

    public void setNeedToImportCertificate(boolean needToImportCertificate) {
        this.needToImportCertificate = needToImportCertificate;
    }

    public boolean isShowNonSslWarning() {
        return this.isNonSSLConnectionAvailable && !this.needToImportCertificate;
    }

    public Cert getCertificate() {
        return this.certificate;
    }

    public boolean isNonSSLConnectionAvailable() {
        return this.isNonSSLConnectionAvailable;
    }

    public String getRootIssuerDN() {
        return this.rootIssuerDN;
    }

    public void setRootIssuerDN(String rootIssuerDN) {
        this.rootIssuerDN = rootIssuerDN;
    }

    public boolean isContinueWithoutSSL() {
        return this.continueWithoutSSL;
    }

    public void setContinueWithoutSSL(boolean continueWithoutSSL) {
        this.continueWithoutSSL = continueWithoutSSL;
    }

    public boolean isValidCertificatePresent() {
        return this.certificate != null;
    }

    public String getCertFilename() {
        return this.certFilename;
    }
}

