/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractConnectToP1State;
import com.pingidentity.fsm.tasklet.impl.setup.InitialSetupTasklet;
import com.pingidentity.pingone.PingOneAdminServiceSettings;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.util.license.LicenseManager;

public class PingOneAccountState
extends AbstractConnectToP1State {
    public static final String SETUP_TYPE_P1 = "p1";
    public static final String SETUP_TYPE_STANDALONE = "standalone";
    private String license = "";
    private String setupType = "";
    private String prevSetupType = "";

    public PingOneAccountState(IWizard owner) {
        super(owner);
        this.setMenuName("PingOne Account");
        this.setShowNote(true);
        this.setNoteKey("PingOneAccountState_note_no_association");
    }

    @Override
    public void disconnect(IRequestCycle cycle) {
        InitialSetupTasklet initialSetup = this.findParent(InitialSetupTasklet.class);
        if (initialSetup == null) {
            throw new RuntimeException("Cannot find InitialSetupTasklet");
        }
        initialSetup.logoutCurrentUser();
        initialSetup.loginAsTempUser(cycle.getRequestContext().getRequest());
        super.disconnect(cycle);
        this.getParent().resetAllStates();
    }

    @Override
    public boolean onStateExit() {
        InitialSetupTasklet tasklet;
        if (this.isAssociated() && this.getSetupType().equals(SETUP_TYPE_STANDALONE)) {
            this.disconnect(this.getParent().getCycle());
        }
        if ((tasklet = this.findParent(InitialSetupTasklet.class)) == null) {
            throw new RuntimeException("Cannot find InitialSetupTasklet");
        }
        if (!this.prevSetupType.equals(this.getSetupType())) {
            if (this.prevSetupType.equals(SETUP_TYPE_P1)) {
                this.license = "";
            }
            tasklet.clearEntityId();
        }
        this.prevSetupType = this.getSetupType();
        return super.onStateExit();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isSetupTypeChosen()) {
            delegate.setFormComponent(null);
            this.recordErrorMsg("You must select an option.");
        }
        if (this.getSetupType().equals(SETUP_TYPE_P1) && !this.isAssociated() && StringUtils.isBlank((String)this.getAuthKey())) {
            delegate.setFormComponent(null);
            this.recordErrorMsg("An activation key is required when connecting to PingOne for Enterprise.");
        }
        if (this.getSetupType().equals(SETUP_TYPE_P1)) {
            if (!delegate.getHasErrors() && !this.isAssociated()) {
                boolean isAuthKeyProvided;
                super.appendErrors(delegate, component, fastFail);
                boolean bl = isAuthKeyProvided = !StringUtils.isBlank((String)this.getAuthKey());
                if (isAuthKeyProvided) {
                    boolean success = this.associateWithKey(this.getAuthKey(), delegate);
                    if (success) {
                        PingOneAdminServiceSettings settings = this.service.getSettings();
                        settings.setEnableAdminConsoleSso(true);
                        this.service.saveSettings(settings);
                    } else {
                        this.clearState();
                        return;
                    }
                }
            }
            if (!LicenseManager.isValidForGui() && StringUtils.isBlank((String)this.license) && this.isAssociated()) {
                this.getLicenseFromPingOne();
            }
        }
    }

    @Override
    void clearState() {
        this.setAuthKey(null);
    }

    @Override
    public boolean isNextEnabled() {
        return this.isSetupTypeChosen();
    }

    private boolean isSetupTypeChosen() {
        return StringUtils.isNotBlank((String)this.getSetupType());
    }

    public String getSetupType() {
        return this.setupType;
    }

    public void setSetupType(String setupType) {
        boolean updateTransitions = !this.setupType.equals(setupType);
        this.setupType = setupType;
        if (updateTransitions) {
            this.getParent().reconfigureTransitions();
        }
    }

    public boolean isPingOneSelected() {
        return this.getSetupType().equals(SETUP_TYPE_P1);
    }

    public static String getSetupTypeP1() {
        return SETUP_TYPE_P1;
    }

    public static String getSetupTypeStandalone() {
        return SETUP_TYPE_STANDALONE;
    }

    private void getLicenseFromPingOne() {
        try {
            this.log.debug((Object)"Downloading license from PingOne.");
            this.license = this.service.downloadLicense();
            this.log.debug((Object)"Successfully retrieved license from PingOne.");
            ArrayList errors = new ArrayList();
            LicenseManager.testLicenseForImport((String)this.license, errors, null);
            if (!errors.isEmpty()) {
                PingOneAccountState.recordErrorMsg("Error retrieving a license from PingOne, see the logs for more details.", (IValidationDelegate)this.delegate);
                this.log.error((Object)"License retrieved from PingOne is not valid, the errors are below.");
                for (String error : errors) {
                    this.log.error((Object)error);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to retrieve license from PingOne.", (Throwable)e);
            this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
            this.recordErrorMsg("Unable to download your PingFederate license from PingOne. Please see the logs for more details.");
            return;
        }
    }

    public String getPingOneLicense() {
        return this.license;
    }
}

