/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.draft.ConnectionDraft;
import com.pingidentity.draft.Draft;
import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.helper.ImportProvisioningConnectionHelper;
import com.pingidentity.fsm.state.impl.setup.AbstractConfirmationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ConnectionItem;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.PingIDSetupWizard;
import com.pingidentity.fsm.tasklet.impl.setup.PingOneSsoWizard;
import com.pingidentity.pingid.PingIdSpConnectionBuilder;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.PingOneSpConnectionBuilder;
import com.pingidentity.plugins.HtmlFormAdapterBuilder;
import com.pingidentity.plugins.KerberosAdapterBuilder;
import com.pingidentity.plugins.LdapPcvBuilder;
import com.pingidentity.plugins.PingIdRadiusPCVBuilder;
import com.pingidentity.plugins.PingOneAuthnSelectorBuilder;
import com.pingidentity.plugins.SimplePCVBuilder;
import com.pingidentity.provisioner.channel.runner.ProvisionerRunner;
import com.pingidentity.provisioner.domain.mgmt.SpringApplicationContext;
import com.pingidentity.util.ProvisionerGlobalSettingsHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ProvisioningParameters;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneConfirmationState
extends AbstractConfirmationState {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PCV_NAME = "PingOne LDAP PCV";
    private static final String DEFAULT_HTML_FORM_ADAPTER_NAME = "PingOne HTML Form Adapter";
    private static final String DEFAULT_KERBEROS_ADAPTER_NAME = "PingOne Kerberos Adapter";
    private static final String DEFAULT_SIMPLE_PCV_NAME = "PingOne Simple PCV";
    private static final PingOneAdminService service = MgmtFactory.getPingOneAdminService();
    private transient PingIDSetupWizard pingIDSetupWizard;
    private transient PingOneSsoWizard pingOneSsoWizard;
    private transient ImportProvisioningConnectionHelper provisioningConnectionHelper = new ImportProvisioningConnectionHelper();
    private transient LdapPcvBuilder pcv;
    private transient HtmlFormAdapterBuilder htmlFormAdapter;
    private transient PingOneSpConnectionBuilder spConnectionBuilder;
    private transient KerberosAdapterBuilder kerberosAdapter;
    private transient PingOneAuthnSelectorBuilder authenticationSelector;
    private transient PingIdRadiusPCVBuilder pingIdRadiusPCV;
    private transient PingIdSpConnectionBuilder pingIdSpConnectionBuilder;
    private transient SimplePCVBuilder simplePCVBuilder;
    private boolean isPingoneSSOUsecase = false;
    private boolean isPingIdUseCase = false;
    private boolean failed;

    public PingOneConfirmationState(Tasklet value) {
        super(value);
        this.setMenuName("Confirmation");
        this.setShowNote(false);
    }

    @Override
    public void onStateActivated() {
        HashSet<String> attributes;
        this.failed = false;
        boolean ldapPcvCreated = false;
        if (this.isPingoneSSOUsecase()) {
            attributes = new HashSet<String>(PingOneSpConnectionBuilder.getP1ToPfAttributes((boolean)this.getPingOneSsoWizard().isActiveDirectory()).values());
            if (this.getPingOneSsoWizard().isDirectoryConfigured()) {
                this.pcv = new LdapPcvBuilder(this.getDirectory().getId(), this.getPingOneSsoWizard().getSearchBase(), this.getPingOneSsoWizard().getSearchFilter(), attributes);
                this.pcv.setNameAndId(DEFAULT_PCV_NAME);
                ldapPcvCreated = true;
                this.createSSOPlugins(attributes);
            } else {
                this.createSamplePlugins(attributes);
            }
            try {
                this.spConnectionBuilder = new PingOneSpConnectionBuilder((IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin(), this.kerberosAdapter == null ? null : (IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin(), this.getProvisioningParameters(), this.getPingOneSsoWizard().isActiveDirectory());
                if (this.getPingOneSsoWizard().isDirectoryConfigured() && this.getPingOneSsoWizard().isKerberosConfigured()) {
                    LdapAttributeSource activeDirectorySource = this.spConnectionBuilder.createAttributeSource(this.getDirectory(), this.getPingOneSsoWizard().getSearchBase(), this.getPingOneSsoWizard().getSearchFilter());
                    this.spConnectionBuilder.mapKerberoseAdapter((IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin(), (AttributeSource)activeDirectorySource, true);
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to create SP Connection.", (Throwable)e);
                this.setFailed(true);
                this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
                this.recordErrorMsg(this.getMessage("unable_to_get_data_from_p1"));
                return;
            }
            String entityId = this.spConnectionBuilder.getConnection().getEntityId();
            EntityIdDuplicateValidator duplicateValidator = new EntityIdDuplicateValidator(entityId);
            if (duplicateValidator.isEntityIdInUse()) {
                this.setFailed(true);
                this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
                this.recordErrorMsg(this.getMessage("entity_id_in_use", new Object[]{entityId, duplicateValidator.getNameUsingEntityId()}));
                return;
            }
        }
        if (this.isPingIdUseCase()) {
            attributes = new HashSet(PingOneSpConnectionBuilder.getP1ToPfAttributes((boolean)this.getPingIDSetupWizard().isActiveDirectory()).values());
            if (this.getPingIDSetupWizard().isDirectoryConfigured()) {
                this.createPingIDProvisioningConnection();
                if (!ldapPcvCreated && this.getPingIDSetupWizard().isValidateUserCredentials()) {
                    this.pcv = new LdapPcvBuilder(this.getDirectory().getId(), this.getPingIDSetupWizard().getSearchBase(), this.getPingIDSetupWizard().getSearchFilter(), attributes);
                    this.pcv.setNameAndId(DEFAULT_PCV_NAME);
                }
            }
            this.buildPingIdPCV(this.getPingIDSetupWizard().getSearchBase(), this.getPingIDSetupWizard().getSearchFilter(), this.getPingIDSetupWizard().isDirectoryConfigured());
        }
    }

    private void createEntityId() {
        PingOneAdminService service = MgmtFactory.getPingOneAdminService();
        if (service.isAssociated()) {
            LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
            LocalSettings settings = localSettingsManager.getLocalSettings();
            if (StringUtils.isEmpty((String)settings.getEntityId())) {
                settings.setEntityId(service.getSpConnectionFactory().getFactoryMetadata().getGlobalEntityId());
            }
            localSettingsManager.saveLocalSettings(settings);
        }
    }

    private void createPingIDProvisioningConnection() {
        if (this.getPingIDSetupWizard().isPingIDProvisioningEnabled()) {
            SpConnection pingIdConnection = this.provisioningConnectionHelper.createProvisioningConnection();
            ProvisioningParameters params = this.getPingIdProvisioningParameters();
            this.pingIdSpConnectionBuilder = new PingIdSpConnectionBuilder(params, pingIdConnection);
        }
    }

    public ProvisioningParameters getPingIdProvisioningParameters() {
        ProvisioningParameters params = null;
        if (this.getPingIDSetupWizard().isPingIDProvisioningEnabled()) {
            params = new ProvisioningParameters(this.getPingIDSetupWizard().getDirectoryDataSource(), this.getPingIDSetupWizard().getSearchBase(), this.getPingIDSetupWizard().getPingIDProvisioningGroupDn(), this.getPingIDSetupWizard().isPingIDProvisioningNested());
        }
        return params;
    }

    private void createSamplePlugins(Set<String> attributes) {
        this.simplePCVBuilder = new SimplePCVBuilder();
        this.simplePCVBuilder.setNameAndId(DEFAULT_SIMPLE_PCV_NAME);
        this.htmlFormAdapter = new HtmlFormAdapterBuilder(((PasswordCredentialValidatorInstance)this.simplePCVBuilder.getPlugin()).getId(), attributes, false, true);
        this.htmlFormAdapter.setNameAndId(DEFAULT_HTML_FORM_ADAPTER_NAME);
    }

    private void createSSOPlugins(Set<String> attributes) {
        this.htmlFormAdapter = new HtmlFormAdapterBuilder(((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getId(), attributes, false, false);
        this.htmlFormAdapter.setNameAndId(DEFAULT_HTML_FORM_ADAPTER_NAME);
        if (LdapInfo.LdapType.ActiveDirectory.equals((Object)this.getPingOneSsoWizard().getDirectoryDataSource().getLdapType()) && this.getPingOneSsoWizard().isKerberosConfigured()) {
            this.createKerberosConfig();
        }
    }

    private void buildPingIdPCV(String searchBase, String searchFilter, boolean isDirectoryConfigured) {
        if (this.isPingIdUseCase()) {
            String delegetePcvId = this.pcv == null ? null : ((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getId();
            this.pingIdRadiusPCV = new PingIdRadiusPCVBuilder(this.pingIDSetupWizard.getRadiusClientIp(), this.pingIDSetupWizard.getRadiusClientSecret(), this.pingIDSetupWizard.getRadiusAuthnPort(), this.downloadPingIdProperties(), this.pingIDSetupWizard.getPingIdUsernameAttribute(), isDirectoryConfigured ? this.getDirectoryID() : null, searchBase, searchFilter, this.pingIDSetupWizard.isValidateUserCredentials(), delegetePcvId, true);
            this.pingIdRadiusPCV.setNameAndId("PingID PCV");
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (!this.isFailed()) {
            boolean saveLdapPcv = true;
            this.enableProvisioning();
            if (!this.getParent().isLicensed() && this.getParent().isInitialSetup()) {
                this.getParent(AbstractPingOneSetupTasklet.class).importLicense((IValidationDelegate)this.getDelegate());
            }
            this.createEntityId();
            if (this.isPingIdUseCase()) {
                if (this.getPingIDSetupWizard().isDirectoryConfigured()) {
                    if (this.getPingIDSetupWizard().isValidateUserCredentials()) {
                        this.pcv.save();
                        saveLdapPcv = false;
                    }
                    if (this.getPingIDSetupWizard().isPingIDProvisioningEnabled() && this.pingIdSpConnectionBuilder != null) {
                        try {
                            this.activateProvisioning();
                            this.pingIdSpConnectionBuilder.save();
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Error occurred while saving Provisioning SP connection to PingID and activating provisioning", (Throwable)e);
                            this.recordErrorMsg(this.getMessage("save_failed"));
                            this.setFailed(true);
                            return false;
                        }
                    }
                }
                this.pingIdRadiusPCV.save();
            }
            if (this.isPingoneSSOUsecase()) {
                this.savePingOneSSOSettings(saveLdapPcv);
                boolean connectionSaved = this.saveConnection();
                if (!connectionSaved) {
                    return false;
                }
            }
        }
        return true;
    }

    private void savePingOneSSOSettings(boolean saveLdapPcv) {
        if (this.getPingOneSsoWizard().isDirectoryConfigured()) {
            if (saveLdapPcv) {
                this.pcv.save();
            }
            this.htmlFormAdapter.save();
            if (this.getPingOneSsoWizard().isKerberosConfigured()) {
                this.kerberosAdapter.save();
                this.authenticationSelector.save();
            }
        } else {
            this.simplePCVBuilder.save();
            this.htmlFormAdapter.save();
        }
    }

    private boolean saveConnection() {
        if (this.spConnectionBuilder != null) {
            try {
                if (this.getProvisioningParameters() != null) {
                    this.activateProvisioning();
                }
                this.spConnectionBuilder.save();
            }
            catch (Exception e) {
                this.log.error((Object)"Error occurred while saving SP connection settings and activating provisioning", (Throwable)e);
                this.recordErrorMsg(this.getMessage("save_failed"));
                this.setFailed(true);
                return false;
            }
            this.checkUploadIdpMetadata();
        }
        return true;
    }

    private String downloadPingIdProperties() {
        try {
            return service.downloadPingIdProperties();
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to download PingID properties file." + e.getMessage()));
            this.log.debug((Object)e.getStackTrace());
            return null;
        }
    }

    private void checkUploadIdpMetadata() {
        if (MgmtFactory.getMediator().isStandalone()) {
            SpConnectionFactory spConnFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();
            long startTime = System.currentTimeMillis();
            while (!spConnFactory.isMetadataUploadPending() && System.currentTimeMillis() - startTime < 10000L) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!spConnFactory.isMetadataUploadPending()) {
                this.log.warn((Object)"SP connection factory did not detect that metadata upload was required");
            } else {
                try {
                    spConnFactory.uploadIdpMetadata();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error uploading IdP metadata to PingOne", (Throwable)e);
                }
            }
        }
    }

    private ProvisioningParameters getProvisioningParameters() {
        ProvisioningParameters params = null;
        AbstractPingOneSetupTasklet tasklet = this.getParent(AbstractPingOneSetupTasklet.class);
        if (this.isProvisioningEnabled()) {
            params = new ProvisioningParameters(tasklet.getDirectoryDataSource(), tasklet.getSearchBase(), tasklet.getPingOneProvisioningGroupDn(), tasklet.isPingOneProvisioningNested());
        }
        return params;
    }

    private void enableProvisioning() {
        ProvisionerGlobalSettingsHelper.enableProvisioning();
    }

    private void activateProvisioning() throws Exception {
        ProvisionerRunner provisionerRunner = (ProvisionerRunner)SpringApplicationContext.getBean((String)"provisionerRunner", ProvisionerRunner.class);
        if (provisionerRunner == null) {
            throw new RuntimeException("Failed to get provisionerRunner bean from Spring application context");
        }
        provisionerRunner.activateProvisionerIfNecessary();
    }

    private void createKerberosConfig() {
        this.kerberosAdapter = new KerberosAdapterBuilder(this.getKerberosRealm().getId());
        this.kerberosAdapter.setNameAndId(DEFAULT_KERBEROS_ADAPTER_NAME);
        this.authenticationSelector = new PingOneAuthnSelectorBuilder((IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin(), (IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin(), this.getPingOneSsoWizard().getKerberosIpRanges());
    }

    private LdapDataSource getDirectory() {
        if (this.isPingoneSSOUsecase) {
            return this.getPingOneSsoWizard().getDirectoryDataSource();
        }
        if (this.isPingIdUseCase) {
            return this.getPingIDSetupWizard().getDirectoryDataSource();
        }
        return null;
    }

    private KerberosRealm getKerberosRealm() {
        return this.getPingOneSsoWizard().getKerberosRealm();
    }

    public String getSourceName() {
        return this.getDirectory().getDescription();
    }

    public String getDirectoryHostname() {
        return this.getDirectory().getHost();
    }

    public String getDirectoryID() {
        return this.getDirectory().getId();
    }

    public String getPcvName() {
        return ((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getName();
    }

    public String getPcvID() {
        return ((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getId();
    }

    public String getHtmlFormAdapterName() {
        return ((IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin()).getName();
    }

    public String getHtmlFormAdapterID() {
        return ((IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin()).getId();
    }

    public String getKerberosAdapterName() {
        return ((IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin()).getName();
    }

    public String getSpConnectionName() {
        return this.spConnectionBuilder.getConnection().getName();
    }

    public String getSpConnectionID() {
        return this.spConnectionBuilder.getConnection().getId();
    }

    public String getSigningCertDN() {
        SpConnectionFactory connFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();
        return connFactory.getFactoryMetadata().getSigningPkCertDn();
    }

    public String getCidrSelectorName() {
        return this.authenticationSelector.getCidrSelector().getName();
    }

    public boolean isProvisioningEnabled() {
        return this.getPingOneSsoWizard().isDirectoryConfigured() && this.getPingOneSsoWizard().isPingOneProvisioningEnabled();
    }

    private void setFailed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    public boolean isSampleConfig() {
        return this.isPingoneSSOUsecase() && !this.getPingOneSsoWizard().isDirectoryConfigured();
    }

    public String getSampleUsers() {
        if (this.simplePCVBuilder != null) {
            return this.simplePCVBuilder.getTestUsersForSummary();
        }
        return "";
    }

    private PingIDSetupWizard getPingIDSetupWizard() {
        if (this.pingIDSetupWizard != null) {
            return this.pingIDSetupWizard;
        }
        this.pingIDSetupWizard = this.findParent(PingIDSetupWizard.class);
        return this.pingIDSetupWizard;
    }

    private PingOneSsoWizard getPingOneSsoWizard() {
        if (this.pingOneSsoWizard != null) {
            return this.pingOneSsoWizard;
        }
        this.pingOneSsoWizard = this.findParent(PingOneSsoWizard.class);
        return this.pingOneSsoWizard;
    }

    public boolean isPingoneSSOUsecase() {
        return this.isPingoneSSOUsecase;
    }

    public void setPingoneSSOUsecase(boolean pingoneSSOUsecase) {
        this.isPingoneSSOUsecase = pingoneSSOUsecase;
    }

    public boolean isPingIdUseCase() {
        return this.isPingIdUseCase;
    }

    public void setPingIdUseCase(boolean pingIdUseCase) {
        this.isPingIdUseCase = pingIdUseCase;
    }

    private static class EntityIdDuplicateValidator {
        private final String entityId;
        private boolean validated;
        private String connectionName;

        public EntityIdDuplicateValidator(String entityId) {
            this.entityId = entityId;
        }

        public boolean isEntityIdInUse() {
            this.validated = true;
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            Collection spConnections = connectionManager.getFilteredSpConnections();
            for (SpConnection conn : spConnections) {
                if (!conn.getEntityId().equals(this.entityId)) continue;
                this.connectionName = conn.getName();
                return true;
            }
            DraftManager draftManager = DraftManagerImpl.getInstance();
            for (Draft draft : draftManager.getSpDrafts(true)) {
                if (!draft.getId().equals(this.entityId)) continue;
                this.connectionName = ((ConnectionDraft)draft).getConnectionName();
                return true;
            }
            return false;
        }

        public String getNameUsingEntityId() {
            if (this.validated) {
                return this.connectionName;
            }
            ConnectionItem conn = this.findConnectionUsingEntityId(this.entityId);
            if (conn != null) {
                return conn.getConnectionName();
            }
            return null;
        }

        private ConnectionItem findConnectionUsingEntityId(String entityId) {
            LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            Collection spConnections = connectionManager.getFilteredSpConnections();
            for (SpConnection conn : spConnections) {
                if (!conn.getEntityId().equals(entityId)) continue;
                this.connectionName = conn.getName();
                return new ConnectionItem(localSettings, (ConnectionBase)conn);
            }
            DraftManager draftManager = DraftManagerImpl.getInstance();
            for (Draft draft : draftManager.getSpDrafts(true)) {
                if (!draft.getId().equals(entityId)) continue;
                ConnectionDraft connDraft = (ConnectionDraft)draft;
                this.connectionName = connDraft.getConnectionName();
                return new ConnectionItem(connDraft);
            }
            return null;
        }
    }
}

