/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.validator.GroupDnValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;

public class ProvisioningSetupState
extends AbstractSetupState {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean configureProvisioning = false;
    private boolean nestedGroups;
    private String groupDN;
    private String groupDNLabelText = "Group DN";

    public ProvisioningSetupState(IWizard owner) {
        super(owner);
        this.setMenuName("Provisioning");
        this.setNoteKey("ProvisioningSetupState_note");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ProvisioningData provData = (ProvisioningData)((Map)dataFromDisk).get(this.getClass().getCanonicalName());
        if (provData != null) {
            this.configureProvisioning = provData.isEnabled();
            this.groupDN = provData.getGroupDN();
            this.nestedGroups = provData.isNested();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        GroupDnValidator groupDnValidator;
        super.appendErrors(delegate, component, fastFail);
        if (this.isConfigureProvisioning()) {
            if (StringUtils.isEmpty((String)this.getGroupDN())) {
                ProvisioningSetupState.recordErrorMsg(this.getMessage("group_dn_required"), delegate);
            } else {
                try {
                    new LdapName(this.groupDN);
                }
                catch (InvalidNameException e) {
                    this.log.error((Object)("Invalid Group DN due to: " + e.getMessage()));
                    ProvisioningSetupState.recordErrorMsg(this.getMessage("Invalid_group_dn"), delegate);
                }
            }
        }
        if (!(groupDnValidator = new GroupDnValidator("", this.getGroupDN())).validate()) {
            this.recordErrors(groupDnValidator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Enabled"), Boolean.toString(this.configureProvisioning), this));
        if (this.configureProvisioning) {
            summaryList.add(new SummaryInfo(this.getMessage("GroupDN"), this.getGroupDN(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Nested"), Boolean.toString(this.nestedGroups), this));
        }
    }

    public boolean isConfigureProvisioning() {
        return this.configureProvisioning;
    }

    public void setConfigureProvisioning(boolean configureProvisioning) {
        this.configureProvisioning = configureProvisioning;
    }

    public boolean isNestedGroups() {
        return this.nestedGroups;
    }

    public void setNestedGroups(boolean nestedGroups) {
        this.nestedGroups = nestedGroups;
    }

    public String getGroupDN() {
        return this.groupDN;
    }

    public void setGroupDN(String groupDN) {
        this.groupDN = groupDN;
    }

    public String getGroupDNLabelText() {
        return this.groupDNLabelText;
    }

    public void setGroupDNLabelText(String groupDNLabelText) {
        this.groupDNLabelText = groupDNLabelText;
    }

    public ProvisioningData getCurrentData() {
        ProvisioningData data = new ProvisioningData();
        data.setEnabled(this.isConfigureProvisioning());
        data.setGroupDN(this.getGroupDN());
        data.setNested(this.isNestedGroups());
        return data;
    }

    private static class ProvisioningData {
        private boolean isEnabled;
        private boolean isNested;
        private String groupDN;

        private ProvisioningData() {
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isNested() {
            return this.isNested;
        }

        public void setNested(boolean nested) {
            this.isNested = nested;
        }

        public String getGroupDN() {
            return this.groupDN;
        }

        public void setGroupDN(String groupDN) {
            this.groupDN = groupDN;
        }
    }
}

