/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.ProvisioningSetupState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.PingIDInitialSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.PingOneSsoSetupTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.util.PluginUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.util.license.LicenseManager;

public class UsecasesState
extends TaskletListState {
    private boolean pingOneSSOSelected = false;
    private boolean pingIdSelected = false;
    private boolean advancedSso = false;
    private PingOneSsoSetupTasklet pingSsoSetupTasklet;
    private PingIDInitialSetupTasklet pingIDInitialSetupTasklet;
    public static final String PING_ID_PCV_CLASSNAME = "com.pingidentity.plugins.pcvs.pingid.PingIdPCV";

    public UsecasesState(IWizard owner) {
        super(owner);
        this.setMenuName("Use Cases");
        this.setNoteKey("UsecasesState_Note");
        this.pingSsoSetupTasklet = this.createTaskletToLoad(PingOneSsoSetupTasklet.class);
        this.pingIDInitialSetupTasklet = this.createTaskletToLoad(PingIDInitialSetupTasklet.class);
        this.addTasklet(this.pingSsoSetupTasklet);
        this.addTasklet(this.pingIDInitialSetupTasklet);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        if (!this.isPingIdSelected() && !this.isPingOneSSOSelected()) {
            UsecasesState.recordErrorMsg("You must enable at least one use case.", delegate);
        }
        if (this.isPingOneSSOSelected() && this.getParentTasklet().isDirectoryConfigured() && this.advancedSso && !this.pingSsoSetupTasklet.isCompleted()) {
            UsecasesState.recordErrorMsg("Click 'Begin' and complete the configuration needed to enable PingOne SSO", delegate);
        }
        if (this.isPingIdSelected() && !this.pingIDInitialSetupTasklet.isCompleted()) {
            UsecasesState.recordErrorMsg("Click 'Begin' and complete the configuration needed to enable PingID VPN (RADIUS)", delegate);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.isPingOneSSOSelected() && this.isAdvancedSso()) {
            this.pingSsoSetupTasklet.save(dataToDisk);
        }
        if (this.isPingIdSelected()) {
            this.pingIDInitialSetupTasklet.save(dataToDisk);
        }
        return true;
    }

    public boolean isPingOneSSOSelected() {
        return this.pingOneSSOSelected;
    }

    public void setPingOneSSOSelected(boolean pingOneSSOSelected) {
        if (!LicenseManager.canAddConnection()) {
            pingOneSSOSelected = false;
        }
        this.pingOneSSOSelected = pingOneSSOSelected;
    }

    public boolean isPingIdSelected() {
        return this.pingIdSelected;
    }

    public void setPingIdSelected(boolean pingIdSelected) {
        this.pingIdSelected = pingIdSelected;
    }

    public void loadPingOneSSO() {
        this.pingSsoSetupTasklet.reconfigureTransitions();
        this.loadTasklet(this.pingSsoSetupTasklet);
    }

    public void loadPingIdTasklet() {
        this.pingIDInitialSetupTasklet.reconfigureTransitions();
        this.loadTasklet(this.pingIDInitialSetupTasklet);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PingIDInitialSetupTasklet getPingIDSetupTasklet() {
        return this.pingIDInitialSetupTasklet;
    }

    public ProvisioningSetupState getProvisioningState() {
        return this.pingSsoSetupTasklet.getProvisioningState();
    }

    public boolean isPingOneSsoComplete() {
        return this.pingSsoSetupTasklet.isCompleted();
    }

    public boolean isPingIdComplete() {
        return this.pingIDInitialSetupTasklet.isCompleted();
    }

    @Override
    public boolean isNextEnabled() {
        if (this.isPingOneSSOSelected()) {
            if (!this.getParentTasklet().isDirectoryConfigured()) {
                return true;
            }
            if (this.getParentTasklet().isDirectoryConfigured() && !this.isAdvancedSso()) {
                return true;
            }
            if (this.getParentTasklet().isDirectoryConfigured() && this.isAdvancedSso() && this.pingSsoSetupTasklet.isCompleted()) {
                return true;
            }
        }
        return this.isPingIdSelected() && this.pingIDInitialSetupTasklet.isCompleted();
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (!taskletToEdit.isCancelled()) {
            if (taskletToEdit instanceof PingOneSsoSetupTasklet) {
                taskletToEdit.setPopulateData(((PingOneSsoSetupTasklet)taskletToEdit).getCurrentData());
            }
            if (taskletToEdit instanceof PingIDInitialSetupTasklet) {
                taskletToEdit.setPopulateData(((PingIDInitialSetupTasklet)taskletToEdit).getCurrentData());
            }
        }
    }

    private AbstractPingOneSetupTasklet getParentTasklet() {
        return this.getParent(AbstractPingOneSetupTasklet.class);
    }

    public KerberosAuthenticationState getKerberosState() {
        return this.pingSsoSetupTasklet.getKerberosState();
    }

    public boolean isAdvancedSso() {
        return this.advancedSso;
    }

    public void setAdvancedSso(boolean advancedSso) {
        this.advancedSso = advancedSso;
    }

    public boolean isDisplayPingID() {
        PluginUtils<PluginDescriptor, PasswordCredentialValidatorInstance> pluginUtils = PluginUtils.newPasswordCredentialManagerUtils();
        return pluginUtils.isPluginInstalled(PING_ID_PCV_CLASSNAME);
    }
}

