/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.issuancecriteria.impl;

import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.util.MappingUtil;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class AbstractIssuanceCriteriaState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final String INVALID_VALUE = "--INVALID VALUE--";
    private List<IssuanceCriterion> issuanceCriteriaList = new ArrayList<IssuanceCriterion>();
    private IssuanceCriterion originalIssuanceCriterion;
    private String attributeSourceKeyToAdd = "";
    private String attributeNameToAdd = "";
    private String conditionIdToAdd = "";
    private String comparisonValueToAdd;
    private String errorResultToAdd;
    private int indexToEdit = -1;
    private String expressionToAdd = "";
    private String advancedErrorResultToAdd;
    private boolean showAdvanced;
    private boolean testingExpression;
    private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
    private transient DataMap.Sources sources = new DataMap.Sources();
    private StringPairPropertySelectionModel conditionsSelectionModel;
    private Object expressionTestState;
    private final transient ConnectionManager connManager = MgmtFactory.getConnectionManager();
    private final transient LocalIdentityManager localIdentityProfileManager = MgmtFactory.getLocalIdentityProfileManager();
    private final transient PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();

    public abstract void addSourcesToPropertySelectionSources(DataMap.Sources var1);

    public abstract Collection<String> getContractToFulfill();

    public AbstractIssuanceCriteriaState(IWizard owner) {
        super(owner, "issuanceCriteria");
        this.setMenuName("Issuance Criteria");
        this.setMessageSimpleName("IssuanceCriteriaState");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.issuanceCriteriaList.clear();
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        List criteria = mapping.getTokenAuthorizationIssuanceCriteria();
        if (criteria != null) {
            for (TokenAuthorizationIssuanceCriterion criterion : criteria) {
                IssuanceCriterion critToAdd = new IssuanceCriterion(criterion);
                this.issuanceCriteriaList.add(critToAdd);
                if (!critToAdd.isAdvanced()) continue;
                this.showAdvanced = true;
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping mapping = (AttributeMapping)dataToDisk;
        ArrayList<TokenAuthorizationIssuanceCriterion> criteriaToSave = new ArrayList<TokenAuthorizationIssuanceCriterion>();
        Iterator<IssuanceCriterion> issuanceCriterionIterator = this.issuanceCriteriaList.iterator();
        while (issuanceCriterionIterator.hasNext()) {
            IssuanceCriterion criterion = issuanceCriterionIterator.next();
            if (criterion.isMarkedForDelete()) {
                issuanceCriterionIterator.remove();
                continue;
            }
            TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion = criterion.clone();
            criteriaToSave.add(tokenAuthorizationIssuanceCriterion);
        }
        mapping.setTokenAuthorizationIssuanceCriteria(criteriaToSave);
        return true;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.addSourcesToPropertySelectionSources(this.sources);
        Collection<String> mappingAttributes = this.getContractToFulfill();
        if (mappingAttributes == null) {
            mappingAttributes = new ArrayList<String>();
        }
        this.sources.addPropertySelectionSource("Mapped Attributes", new StringPairPropertySelectionModel(true, mappingAttributes));
        ArrayList<TestDataItem> refreshedTestDataList = new ArrayList<TestDataItem>();
        for (Map.Entry<String, String> validSubstituterEntry : this.sources.getValidSubstituterValues().entrySet()) {
            String validSubstitutorKey = validSubstituterEntry.getKey();
            boolean foundIt = false;
            for (TestDataItem testDataItem : this.testDataList) {
                if (!validSubstitutorKey.equals(testDataItem.getFieldName())) continue;
                refreshedTestDataList.add(testDataItem);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            refreshedTestDataList.add(new TestDataItem(validSubstitutorKey, ""));
        }
        this.testDataList = refreshedTestDataList;
        this.validateSources();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String errorResult;
        StringBuilder sb;
        String critLabelKey = "Criterion";
        if (this.issuanceCriteriaList.isEmpty() || this.allMarkedAsDelete()) {
            summaryList.add(new SummaryInfo(this.getMessage("Criterion"), "(None)", this));
        }
        for (IssuanceCriterion criterion : this.issuanceCriteriaList) {
            if (criterion.isMarkedForDelete() || criterion.isAdvanced()) continue;
            sb = new StringBuilder();
            sb.append(criterion.getAttrSourceTypeForDisplay()).append(", ");
            sb.append(criterion.getAttrNameForDisplay()).append(", ");
            sb.append(criterion.getCondition().getDescription()).append(", ");
            sb.append(criterion.getComparisonValue());
            errorResult = criterion.getErrorResult();
            if (!StringUtils.isEmpty((String)errorResult)) {
                sb.append(", ").append(errorResult);
            }
            summaryList.add(new SummaryInfo(this.getMessage("Criterion"), sb.toString(), this));
        }
        for (IssuanceCriterion criterion : this.issuanceCriteriaList) {
            if (criterion.isMarkedForDelete() || !criterion.isAdvanced()) continue;
            sb = new StringBuilder();
            sb.append(criterion.getAttrSourceTypeForDisplay());
            errorResult = criterion.getErrorResult();
            if (!StringUtils.isEmpty((String)errorResult)) {
                sb.append(", ").append(errorResult);
            }
            summaryList.add(new SummaryInfo(this.getMessage("Criterion"), sb.toString(), this));
        }
    }

    protected boolean allMarkedAsDelete() {
        return (long)this.issuanceCriteriaList.size() == this.issuanceCriteriaList.stream().filter(IssuanceCriterion::isMarkedForDelete).count();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        List<String> errors;
        this.onStateActivated();
        if (!this.isTestingExpression() && this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.sources.getSourceMap().keySet().isEmpty()) {
            this.checkForDeletedAttributeSources(delegate);
        }
        if (!(errors = this.validateSources()).isEmpty()) {
            delegate.setFormComponent(null);
            errors.forEach(e -> delegate.record(e, ValidationConstraint.REQUIRED));
        }
    }

    private boolean isCriterionInvalid(IssuanceCriterion criterion) {
        SourceType sourceType = criterion.getAttrSourceType();
        if (sourceType == null) {
            return true;
        }
        return !criterion.isMarkedForDelete() && (sourceType.equals((Object)SourceType.ADAPTER) || sourceType.equals((Object)SourceType.MAPPED_ATTRIBUTES) || sourceType.equals((Object)SourceType.ASSERTION) || sourceType.equals((Object)SourceType.TOKEN) || sourceType.equals((Object)SourceType.PASSWORD_CREDENTIAL_VALIDATOR) || sourceType.equals((Object)SourceType.IDP_CONNECTION) || sourceType.equals((Object)SourceType.AUTHENTICATION_POLICY_CONTRACT) || sourceType.equals((Object)SourceType.CLAIMS) || sourceType.equals((Object)SourceType.LOCAL_IDENTITY_PROFILE) || sourceType.equals((Object)SourceType.EXTENDED_CLIENT_METADATA) || sourceType.equals((Object)SourceType.EXTENDED_PROPERTIES) || sourceType.equals((Object)SourceType.TRACKED_HTTP_PARAMS) || sourceType.equals((Object)SourceType.REQUEST) || sourceType.equals((Object)SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY) || sourceType.equals((Object)SourceType.SUBJECT_TOKEN) || sourceType.equals((Object)SourceType.ACTOR_TOKEN) || sourceType.equals((Object)SourceType.FRAGMENT) || sourceType.equals((Object)SourceType.INPUTS)) && !this.sources.isValidSourceValue(criterion.getAttrSourceTypeAsString(), criterion.getAttrName()) && !this.sources.isValidSourceValue(criterion.getAttrSourceKey(), criterion.getAttrName());
    }

    private void checkForDeletedAttributeSources(IValidationDelegate delegate) {
        ArrayList<String> errors = new ArrayList<String>();
        for (IssuanceCriterion criterion : this.issuanceCriteriaList) {
            if (criterion.isMarkedForDelete()) continue;
            if (criterion.isAdvanced()) {
                try {
                    Object parsedExpression = Ognl.parseExpression((String)criterion.getExpr());
                    OgnlHelper ognlHelper = new OgnlHelper();
                    ognlHelper.searchForAllVariableNames(parsedExpression);
                    Map<String, String> validSubstitutionValues = this.getSources().getValidSubstituterValues();
                    Map<String, String> substitutionValues = this.getRefreshedSubtitutionMap(validSubstitutionValues);
                    String invalidSubstitution = ognlHelper.containsInvalidSubstitutions(substitutionValues);
                    if (invalidSubstitution == null) continue;
                    String msg = "Error during expression evaluation: " + this.getMessage("Invalid_column", new Object[]{invalidSubstitution});
                    errors.add(msg);
                }
                catch (OgnlException e) {
                    this.log.debug((Object)"Error during expression evaluation: ", (Throwable)e);
                    String msg = "Error during expression evaluation: " + ExceptionUtil.toStringWithCauses((Throwable)e);
                    errors.add(msg);
                }
                continue;
            }
            if (this.sources.getSourceMap().keySet().contains(criterion.getAttrSourceKey())) continue;
            errors.add(this.getMessage("Invalid_source_type", new Object[]{criterion.getAttrSourceTypeForDisplay()}));
        }
        this.generateErrorMessages(delegate, errors);
    }

    private Map<String, String> getRefreshedSubtitutionMap(Map<String, String> validSubstitutionValues) {
        HashMap<String, String> substitutionValues = new HashMap<String, String>(validSubstitutionValues);
        for (String validSubstituterKey : validSubstitutionValues.keySet()) {
            if (!validSubstituterKey.startsWith("extproperties.") && !validSubstituterKey.startsWith("extclientmetadata.")) continue;
            String prefix = "extclientmetadata.";
            String suffix = "extproperties.";
            if (validSubstituterKey.startsWith("extclientmetadata.")) {
                prefix = "extproperties.";
                suffix = "extclientmetadata.";
            }
            String s = prefix + validSubstituterKey.substring(suffix.length());
            substitutionValues.put(s, s);
        }
        return substitutionValues;
    }

    private List<String> validateIssuanceCriterion(IssuanceCriterion issuanceCriterion) {
        ArrayList<String> errors = new ArrayList<String>();
        if (issuanceCriterion.isAdvanced()) {
            if (StringUtils.isEmpty((String)issuanceCriterion.getExpr())) {
                errors.add(this.getMessage("Required", new Object[]{this.getMessage("Expression")}));
            } else if (!this.isEaAdmin()) {
                errors.add(this.getMessage("Ea_role_required"));
            }
        } else {
            if (issuanceCriterion.getAttrSourceType() == null) {
                errors.add(this.getMessage("Required", new Object[]{this.getMessage("Source")}));
            }
            if (StringUtils.isEmpty((String)issuanceCriterion.getAttrName()) && StringUtils.isEmpty((String)issuanceCriterion.getExpr())) {
                errors.add(this.getMessage("Required", new Object[]{this.getMessage("Attr_name")}));
            }
            if (issuanceCriterion.getCondition() == null) {
                errors.add(this.getMessage("Required", new Object[]{this.getMessage("Condition")}));
            }
            if (StringUtils.isEmpty((String)issuanceCriterion.getComparisonValue())) {
                errors.add(this.getMessage("Required", new Object[]{this.getMessage("Comparison_value")}));
            }
        }
        if (errors.isEmpty()) {
            for (IssuanceCriterion ic : this.issuanceCriteriaList) {
                if (!ic.equals((Object)issuanceCriterion) || this.isEditMode() && ic.isEditMode()) continue;
                errors.add(this.getMessage("Dup_detected"));
                break;
            }
        }
        return errors.size() > 0 ? errors : null;
    }

    public void addIssuanceCriteria(boolean advancedCriterion) {
        IssuanceCriterion issuanceCriterionToAdd = new IssuanceCriterion();
        issuanceCriterionToAdd.setAdvanced(advancedCriterion);
        if (advancedCriterion) {
            issuanceCriterionToAdd.setAttrSourceType(SourceType.EXPRESSION);
            issuanceCriterionToAdd.setExpr(StringUtils.trimToEmpty((String)this.expressionToAdd));
            issuanceCriterionToAdd.setErrorResult(StringUtils.trimToEmpty((String)this.advancedErrorResultToAdd));
        } else {
            issuanceCriterionToAdd.setAttrSourceTypeAsString(DataMap.Sources.getSourceTypeFromKey(this.attributeSourceKeyToAdd));
            issuanceCriterionToAdd.setAttrSourceId(DataMap.Sources.getSourceIdFromKey(this.attributeSourceKeyToAdd));
            issuanceCriterionToAdd.setAttrName(this.attributeNameToAdd);
            issuanceCriterionToAdd.setConditionId(this.conditionIdToAdd);
            issuanceCriterionToAdd.setComparisonValue(StringUtils.trimToEmpty((String)this.comparisonValueToAdd));
            issuanceCriterionToAdd.setErrorResult(StringUtils.trimToEmpty((String)this.errorResultToAdd));
        }
        List<String> errorMessages = this.validateIssuanceCriterion(issuanceCriterionToAdd);
        if (errorMessages == null) {
            this.issuanceCriteriaList.add(issuanceCriterionToAdd);
            this.attributeSourceKeyToAdd = "";
            this.attributeNameToAdd = "";
            this.conditionIdToAdd = "";
            this.comparisonValueToAdd = null;
            this.errorResultToAdd = null;
            this.expressionToAdd = "";
            this.advancedErrorResultToAdd = null;
        } else {
            this.generateErrorMessages((IValidationDelegate)this.getDelegate(), errorMessages);
        }
    }

    private void generateErrorMessages(IValidationDelegate delegate, List<String> errorMessages) {
        delegate.setFormComponent(null);
        for (String errorMessage : errorMessages) {
            delegate.record(errorMessage, ValidationConstraint.REQUIRED);
        }
    }

    public void editIssuanceCriteria(int indexToEdit) {
        this.indexToEdit = indexToEdit;
        this.originalIssuanceCriterion = this.issuanceCriteriaList.get(indexToEdit).clone();
        this.issuanceCriteriaList.get(indexToEdit).setEditMode(true);
    }

    public void updateIssuanceCriteria() {
        IssuanceCriterion issuanceCriteriaToUpdate = this.issuanceCriteriaList.get(this.indexToEdit);
        issuanceCriteriaToUpdate.setComparisonValue(StringUtils.trimToEmpty((String)issuanceCriteriaToUpdate.getComparisonValue()));
        issuanceCriteriaToUpdate.setErrorResult(StringUtils.trimToEmpty((String)issuanceCriteriaToUpdate.getErrorResult()));
        issuanceCriteriaToUpdate.setExpr(StringUtils.trimToEmpty((String)issuanceCriteriaToUpdate.getExpr()));
        List<String> errorMessages = this.validateIssuanceCriterion(issuanceCriteriaToUpdate);
        if (errorMessages == null) {
            issuanceCriteriaToUpdate.setEditMode(false);
            this.indexToEdit = -1;
        } else {
            this.generateErrorMessages((IValidationDelegate)this.getDelegate(), errorMessages);
        }
    }

    public void cancelIssuanceCriteriaEdit() {
        this.issuanceCriteriaList.set(this.indexToEdit, this.originalIssuanceCriterion);
        this.indexToEdit = -1;
    }

    public void deleteIssuanceCriteria(int indexToDelete) {
        this.issuanceCriteriaList.get(indexToDelete).setMarkedForDelete(true);
    }

    public void unDeleteIssuanceCriteria(int indexToUnDelete) {
        this.issuanceCriteriaList.get(indexToUnDelete).setMarkedForDelete(false);
    }

    public boolean isEditMode() {
        for (IssuanceCriterion issuanceCriteria : this.issuanceCriteriaList) {
            if (!issuanceCriteria.isEditMode()) continue;
            return true;
        }
        return false;
    }

    public List<IssuanceCriterion> getIssuanceCriteriaList() {
        return Collections.unmodifiableList(this.issuanceCriteriaList);
    }

    public void setIssuanceCriteriaList(List<IssuanceCriterion> issuanceCriteriaList) {
        this.issuanceCriteriaList = issuanceCriteriaList;
    }

    public String getConditionIdToAdd() {
        return this.conditionIdToAdd;
    }

    public void setConditionIdToAdd(String conditionIdToAdd) {
        this.conditionIdToAdd = conditionIdToAdd;
    }

    public String getComparisonValueToAdd() {
        return this.comparisonValueToAdd;
    }

    public void setComparisonValueToAdd(String sourceToAdd) {
        this.comparisonValueToAdd = sourceToAdd;
    }

    public String getAttributeSourceKeyToAdd() {
        return this.attributeSourceKeyToAdd;
    }

    public void setAttributeSourceKeyToAdd(String attributeSourceKeyToAdd) {
        this.attributeSourceKeyToAdd = attributeSourceKeyToAdd == null ? "" : attributeSourceKeyToAdd;
    }

    public String getAttributeNameToAdd() {
        return this.attributeNameToAdd;
    }

    public void setAttributeNameToAdd(String attributeNameToAdd) {
        this.attributeNameToAdd = attributeNameToAdd == null ? "" : attributeNameToAdd;
    }

    public String getExpressionToAdd() {
        return this.expressionToAdd;
    }

    public void setExpressionToAdd(String expressionToAdd) {
        this.expressionToAdd = expressionToAdd;
    }

    public String getErrorResultToAdd() {
        return this.errorResultToAdd;
    }

    public void setErrorResultToAdd(String errorResultToAdd) {
        this.errorResultToAdd = errorResultToAdd;
    }

    public String getAdvancedErrorResultToAdd() {
        return this.advancedErrorResultToAdd;
    }

    public void setAdvancedErrorResultToAdd(String advancedErrorResultToAdd) {
        this.advancedErrorResultToAdd = advancedErrorResultToAdd;
    }

    public IPropertySelectionModel getConditionsSelectionModel() {
        if (this.conditionsSelectionModel == null) {
            this.conditionsSelectionModel = new StringPairPropertySelectionModel(true);
            this.conditionsSelectionModel.add(ConditionType.EQUALS.getDescription(), ConditionType.EQUALS.getId());
            this.conditionsSelectionModel.add(ConditionType.EQUALS_CASE_INSENSITIVE.getDescription(), ConditionType.EQUALS_CASE_INSENSITIVE.getId());
            this.conditionsSelectionModel.add(ConditionType.EQUALS_DN.getDescription(), ConditionType.EQUALS_DN.getId());
            this.conditionsSelectionModel.add(ConditionType.NOT_EQUAL.getDescription(), ConditionType.NOT_EQUAL.getId());
            this.conditionsSelectionModel.add(ConditionType.NOT_EQUAL_CASE_INSENSITIVE.getDescription(), ConditionType.NOT_EQUAL_CASE_INSENSITIVE.getId());
            this.conditionsSelectionModel.add(ConditionType.NOT_EQUAL_DN.getDescription(), ConditionType.NOT_EQUAL_DN.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_CONTAINS.getDescription(), ConditionType.MULTIVALUE_CONTAINS.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE.getDescription(), ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_CONTAINS_DN.getDescription(), ConditionType.MULTIVALUE_CONTAINS_DN.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN.getDescription(), ConditionType.MULTIVALUE_DOES_NOT_CONTAIN.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE.getDescription(), ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE.getId());
            this.conditionsSelectionModel.add(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN.getDescription(), ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN.getId());
        }
        return this.conditionsSelectionModel;
    }

    public IPropertySelectionModel getSourcesModel() {
        ArrayList<String> l = new ArrayList<String>(this.sources.getSourceMap().keySet());
        Collections.sort(l, String.CASE_INSENSITIVE_ORDER);
        StringPairPropertySelectionModel sourcesModel = new StringPairPropertySelectionModel(true);
        for (String sourceKey : l) {
            String sourceLabel = this.sources.getSourceKeysToLabels().get(sourceKey);
            if (sourceLabel == null) {
                sourceLabel = sourceKey;
            }
            sourcesModel.add(sourceLabel, sourceKey);
        }
        return sourcesModel;
    }

    public IPropertySelectionModel getValuesModelForAdd() {
        return this.getValuesModel(this.attributeSourceKeyToAdd);
    }

    public IPropertySelectionModel getValuesModelForEdit() {
        return this.getValuesModel(this.issuanceCriteriaList.get(this.indexToEdit).getAttrSourceKey());
    }

    private IPropertySelectionModel getValuesModel(String attrSource) {
        IPropertySelectionModel valuesModel = (IPropertySelectionModel)this.sources.get(attrSource);
        if (valuesModel == null) {
            valuesModel = new StringPairPropertySelectionModel(true);
        }
        return valuesModel;
    }

    public boolean isTestingExpression() {
        return this.testingExpression;
    }

    public void setTestingExpression(boolean testingExpression) {
        this.testingExpression = testingExpression;
    }

    public DataMap.Sources getSources() {
        return this.sources;
    }

    public String getExpressionToTest() {
        return this.issuanceCriteriaList.get(this.indexToEdit).getExpr();
    }

    public void setExpressionToTest(String expression) {
        this.issuanceCriteriaList.get(this.indexToEdit).setExpr(expression);
    }

    public List<TestDataItem> getTestDataList() {
        return this.testDataList;
    }

    public void setTestDataList(List<TestDataItem> testDataList) {
        this.testDataList = testDataList;
    }

    public boolean isAdvancedAllowed() {
        return ExpressionManager.getInstance().isEvaluateExpressionsOn() && (this.isEaAdmin() || !this.issuanceCriteriaList.isEmpty());
    }

    public boolean isShowAdvanced() {
        return this.showAdvanced;
    }

    public void setShowAdvanced(boolean showAdvanced) {
        this.showAdvanced = showAdvanced;
    }

    public Object getExpressionTestState() {
        return this.expressionTestState;
    }

    public void setExpressionTestState(Object state) {
        this.expressionTestState = state;
    }

    private List<String> validateSources() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.sources.getSourceMap().isEmpty()) {
            for (IssuanceCriterion criterion : this.issuanceCriteriaList) {
                if (!this.isCriterionInvalid(criterion)) continue;
                if (!errorMessages.contains(this.getMessage("Invalid_criteria"))) {
                    errorMessages.add(this.getMessage("Invalid_criteria"));
                }
                criterion.setAttrName(INVALID_VALUE);
            }
        }
        return errorMessages;
    }

    public boolean isEaAdmin() {
        AdministrativeUser currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isExpressionAdmin();
    }

    public void addExtendedPropertiesToSelectionSources(DataMap.Sources sources) {
        MappingUtil util = new MappingUtil();
        util.addExtendedPropertiesToSelectionSources(sources);
    }

    private class IssuanceCriterion
    extends TokenAuthorizationIssuanceCriterion {
        private static final long serialVersionUID = 1L;
        private boolean editMode;
        private boolean markedForDelete;
        private boolean advanced;

        public IssuanceCriterion() {
        }

        public IssuanceCriterion(TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion) {
            this.setAttrName(tokenAuthorizationIssuanceCriterion.getAttrName());
            this.setAttrSourceType(tokenAuthorizationIssuanceCriterion.getAttrSourceType());
            this.setAttrSourceId(tokenAuthorizationIssuanceCriterion.getAttrSourceId());
            this.setComparisonValue(tokenAuthorizationIssuanceCriterion.getComparisonValue());
            this.setCondition(tokenAuthorizationIssuanceCriterion.getCondition());
            this.setErrorResult(tokenAuthorizationIssuanceCriterion.getErrorResult());
            String expr = tokenAuthorizationIssuanceCriterion.getExpr();
            this.setExpr(expr);
            this.advanced = StringUtils.isNotEmpty((String)expr);
        }

        public IssuanceCriterion clone() {
            return new IssuanceCriterion(super.clone());
        }

        public boolean isEditMode() {
            return this.editMode;
        }

        public void setEditMode(boolean editMode) {
            this.editMode = editMode;
        }

        public boolean isMarkedForDelete() {
            return this.markedForDelete;
        }

        public void setMarkedForDelete(boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
        }

        public String getConditionId() {
            return this.getCondition() == null ? "" : this.getCondition().getId();
        }

        public void setConditionId(String conditionId) {
            this.setConditionById(conditionId);
        }

        public String getAttrSourceTypeForDisplay() {
            Object sourceTypeForDisplay = this.getAttrSourceTypeAsString();
            String attrSrcId = null;
            if (this.getAttrSourceType() == SourceType.IDP_CONNECTION && !StringUtils.isEmpty((String)this.getAttrSourceId())) {
                IdpConnection idpConn = AbstractIssuanceCriteriaState.this.connManager.getIdpConnectionBySystemId(this.getAttrSourceId());
                if (idpConn != null) {
                    attrSrcId = idpConn.getName();
                }
            } else if (this.getAttrSourceType() == SourceType.LOCAL_IDENTITY_PROFILE && !StringUtils.isEmpty((String)this.getAttrSourceId())) {
                LocalIdentityProfile localIdentityProfile = AbstractIssuanceCriteriaState.this.localIdentityProfileManager.getProfile(this.getAttrSourceId());
                if (localIdentityProfile != null) {
                    attrSrcId = localIdentityProfile.getName();
                }
                sourceTypeForDisplay = "Local Identity";
            } else if (this.getAttrSourceType() == SourceType.FRAGMENT && !StringUtils.isEmpty((String)this.getAttrSourceId())) {
                PolicyFragment fragment = AbstractIssuanceCriteriaState.this.fragmentManager.getFragment(this.getAttrSourceId());
                if (fragment != null) {
                    attrSrcId = fragment.getDisplayName();
                }
                sourceTypeForDisplay = "Fragment";
            } else {
                attrSrcId = this.getAttrSourceId();
            }
            if (!StringUtils.isEmpty((String)attrSrcId)) {
                sourceTypeForDisplay = (String)sourceTypeForDisplay + " (" + attrSrcId + ")";
            }
            return sourceTypeForDisplay;
        }

        public String getAttrNameForDisplay() {
            String attrNameForDisplay;
            if (this.getAttrSourceType() == SourceType.CONTEXT) {
                attrNameForDisplay = SourceContextType.getTypeFromId((String)this.getAttrName()).getDescription();
            } else {
                IPropertySelectionModel model = AbstractIssuanceCriteriaState.this.getValuesModel(this.getAttrSourceKey());
                attrNameForDisplay = this.getLabel(model, this.getAttrName());
                if (attrNameForDisplay == null) {
                    attrNameForDisplay = this.getAttrName();
                }
            }
            return attrNameForDisplay;
        }

        public String getAttrSourceKey() {
            return DataMap.Sources.createSourceKey(this.getAttrSourceTypeAsString(), this.getAttrSourceId());
        }

        public void setAttrSourceKey(String sourceKey) {
            this.setAttrSourceTypeAsString(DataMap.Sources.getSourceTypeFromKey(sourceKey));
            this.setAttrSourceId(DataMap.Sources.getSourceIdFromKey(sourceKey));
        }

        public boolean isAdvanced() {
            return this.advanced;
        }

        public void setAdvanced(boolean advanced) {
            this.advanced = advanced;
        }

        public boolean equals(Object object) {
            if (object instanceof IssuanceCriterion) {
                IssuanceCriterion issuanceCriterion = (IssuanceCriterion)((Object)object);
                String aSourceKey = issuanceCriterion.getAttrSourceKey();
                String aName = issuanceCriterion.getAttrName();
                ConditionType cond = issuanceCriterion.getCondition();
                String compVal = issuanceCriterion.getComparisonValue();
                String expVal = issuanceCriterion.getExpr();
                return (StringUtils.isEmpty((String)aSourceKey) ? StringUtils.isEmpty((String)this.getAttrSourceKey()) : aSourceKey.equals(this.getAttrSourceKey())) && (StringUtils.isEmpty((String)aName) ? StringUtils.isEmpty((String)this.getAttrName()) : aName.equals(this.getAttrName())) && (StringUtils.isEmpty((String)compVal) ? StringUtils.isEmpty((String)this.getComparisonValue()) : compVal.equals(this.getComparisonValue())) && (StringUtils.isEmpty((String)expVal) ? StringUtils.isEmpty((String)this.getExpr()) : expVal.equals(this.getExpr())) && cond == this.getCondition();
            }
            return false;
        }

        private String getLabel(IPropertySelectionModel model, String id) {
            if (model == null) {
                return null;
            }
            for (int i = 0; i < model.getOptionCount(); ++i) {
                if (!Objects.equals(model.getOption(i), id)) continue;
                return model.getLabel(i);
            }
            return null;
        }
    }
}

