/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet;

import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.IWizardTransition;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.DependencyErrorManagementState;
import com.pingidentity.fsm.tasklet.GuiTimingLog;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.TaskletTraversal;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.CertificateRevocationCheckingTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.DependencyErrorManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.validator.HasErrorsValidationDelegate;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.Protocol;
import org.springframework.core.annotation.AnnotationUtils;

public class Tasklet
extends Wizard
implements Comparable<Tasklet>,
TaskletTraversal {
    private static final Log log = LogFactory.getLog(Tasklet.class);
    private static final long serialVersionUID = 20050515L;
    protected static final String initialSetupTempUsername = "temporary";
    private Visit systemVisit;
    private Object populateData;
    private Tasklet parentTasklet;
    private String taskletName = "Tasklet";
    private String menuName = "Tasklet Menu Item";
    private String helpName = "helpName";
    private String messageSimpleName = this.getClass().getSimpleName();
    private String taskletId = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    private String gotoState;
    private ArrayList<SummaryInfo> summaryList;
    private ArrayList<SummaryInfo> summaryHeader;
    private transient IRequestCycle cycle;
    private boolean cancelAvailable;
    private boolean finishAvailable;
    private String finishLabel = "Done";
    protected boolean cancelled;
    private Mode mode = Mode.create;
    protected boolean itDeleted;
    protected boolean itPortal;
    private boolean postInstallWizard;
    private boolean globalEditInProgress;
    private boolean hasErrors;
    private boolean saveDraftAvailable = true;
    private boolean draft;
    private boolean protocolImgAvailable;
    private boolean skipPopToParent = false;
    protected List<TaskletState> stateList = new LinkedList<TaskletState>();
    private boolean previousNavMenuReload = false;
    private boolean navMenuReload = false;
    private String navMenuTarget = null;

    public Tasklet() {
        this.helpName = this.taskletName = this.getClass().getSimpleName();
    }

    public Tasklet(String taskletName) {
        this.taskletName = taskletName;
        this.helpName = taskletName;
    }

    public Tasklet(String taskletName, String menuName) {
        this.taskletName = taskletName;
        this.menuName = menuName;
        this.helpName = taskletName;
    }

    public void addState(TaskletState state) {
        this.stateList.add(state);
    }

    @Override
    public void onCancel(IRequestCycle cycle) {
        this.doCancel(cycle);
        this.popTaskletFromStack();
    }

    public void onCancelWithoutPop(IRequestCycle cycle) {
        this.doCancel(cycle);
        this.reconfigureTransitions();
        this.resetCurrentStateToSourceState();
        this.populate(null);
        if (this.gotoSummaryIfPopSkipped()) {
            this.gotoSummaryState(cycle);
        }
    }

    private void doCancel(IRequestCycle cycle) {
        this.cancel();
        this.wipeErrors(cycle);
    }

    public void cancel() {
        this.cancelled = true;
        if (this.populateData == null) {
            this.resetAllStates();
        } else {
            TaskletTransition tt;
            TaskletState state = (TaskletState)this.getSourceState();
            do {
                log.debug((Object)(this.getTaskletName() + " cancel:" + state.getMessageSimpleName()));
                state.setItClickable(true);
                this.cancel(state);
                tt = (TaskletTransition)state.getOutgoingTransition();
                if (tt == null) continue;
                state = (TaskletState)tt.getTarget();
            } while (tt != null);
        }
    }

    public void resetAllStates() {
        for (TaskletState tempState : this.stateList) {
            tempState.setPopulateDate(null);
            log.debug((Object)(this.getTaskletName() + " reset:" + tempState.getMessageSimpleName()));
            tempState.setItClickable(false);
            tempState.reset();
        }
        ((TaskletState)this.getSourceState()).setItClickable(true);
    }

    public void cancel(TaskletState state) {
        long start = System.currentTimeMillis();
        state.cancel(this.populateData);
        GuiTimingLog.log(start, state, this, "cancel");
    }

    public void goToTasklet(IRequestCycle cycle, String taskletMenuName) {
        Tasklet tos;
        this.wipeErrors(cycle);
        while (!this.systemVisit.empty() && !(tos = this.systemVisit.peek()).getMenuName().equals(taskletMenuName)) {
            tos.onCancel(cycle);
        }
    }

    public void goToState(IRequestCycle cycle) {
        if (this.gotoState != null) {
            this.goToState(this, cycle);
            this.gotoState = null;
        }
    }

    public boolean goToState(Tasklet taskletToSearch, IRequestCycle cycle) {
        boolean foundit = false;
        if (this.gotoState != null) {
            boolean moreStates = true;
            taskletToSearch.resetCurrentStateToSourceState();
            while (moreStates) {
                String currentSearchStateTaskletId = ((TaskletState)taskletToSearch.getCurrentState()).getTaskletId();
                if (this.gotoState.equals(currentSearchStateTaskletId)) {
                    foundit = true;
                    break;
                }
                moreStates = this.next(cycle);
            }
        }
        return foundit;
    }

    public void gotoSummaryState(IRequestCycle cycle) {
        if (this.populateData != null && this.getSummaryState() != null) {
            this.setGotoState(this.getSummaryState().getTaskletStateId());
            this.goToState(cycle);
        }
    }

    public TaskletState getSummaryState() {
        return null;
    }

    public void jumpToState(IRequestCycle cycle, Queue<String> returnPath) {
        String stateTaskletId = returnPath.poll();
        boolean moreStates = true;
        this.resetCurrentStateToSourceState();
        String tempTaskletId = ((TaskletState)this.getCurrentState()).getTaskletId();
        if (StringUtils.isNotBlank((String)stateTaskletId) && !stateTaskletId.equals(tempTaskletId)) {
            while (moreStates) {
                moreStates = this.next(cycle);
                tempTaskletId = ((TaskletState)this.getCurrentState()).getTaskletId();
                if (!stateTaskletId.equals(tempTaskletId)) continue;
                if (!returnPath.isEmpty()) {
                    ((TaskletState)this.getCurrentState()).jumpToState(cycle, returnPath);
                }
                break;
            }
        } else if (!returnPath.isEmpty()) {
            ((TaskletState)this.getCurrentState()).jumpToState(cycle, returnPath);
        }
    }

    protected void addAllStates(Set<TaskletState> states, TaskletState currentState) {
        states.add(currentState);
        IWizardTransition[] transitions = currentState.getOutgoingTransitions();
        if (transitions.length > 0) {
            for (IWizardTransition transition : transitions) {
                currentState = (TaskletState)transition.getTarget();
                this.addAllStates(states, currentState);
            }
        }
    }

    @Override
    public void initialize() {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            long start = System.currentTimeMillis();
            state.initialize();
            GuiTimingLog.log(start, state, this, "initialize");
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public void populate(Object dataFromDisk) {
        TaskletTransition tt;
        this.populateData = dataFromDisk;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            long start = System.currentTimeMillis();
            this.populate(state, dataFromDisk);
            GuiTimingLog.log(start, state, this, "populate");
            state.setItClickable(true);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public void populate(TaskletState state, Object dataFromDisk) {
        state.populate(dataFromDisk);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            state.appendErrors(delegate, component, fastFail);
            if (this.isDraft()) {
                if (delegate.getHasErrors()) {
                    this.setCurrentState(state);
                    break;
                }
                TaskletState currentState = (TaskletState)this.getCurrentState();
                if (state.getStateName().equals(currentState.getStateName())) {
                    delegate.clearErrors();
                    break;
                }
            }
            if (fastFail && delegate.getHasErrors()) break;
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public boolean checkForErrors() {
        TaskletState currentState = (TaskletState)this.getCurrentState();
        IRequestCycle reqCycle = this.cycle;
        if (reqCycle == null) {
            Tasklet parentTasklet = this;
            do {
                if ((parentTasklet = parentTasklet.getParentTasklet()) == null) continue;
                reqCycle = parentTasklet.getCycle();
            } while (parentTasklet != null && reqCycle == null);
        }
        BaseComponent component = null;
        if (this.cycle != null && currentState != null) {
            component = this.getBaseComponent(this.cycle, currentState, this);
        }
        HasErrorsValidationDelegate hasErrorDelegate = new HasErrorsValidationDelegate();
        this.appendErrors(hasErrorDelegate, component, true);
        boolean hasErrors = hasErrorDelegate.getHasErrors();
        this.setHasErrors(hasErrors);
        return hasErrors;
    }

    @Override
    public boolean populateAllStates(Object data) {
        for (TaskletState tempState : this.stateList) {
            if (!tempState.populateAllStates(data)) continue;
            tempState.setItClickable(true);
        }
        return true;
    }

    public void reconfigureTransitions() {
    }

    public void reconfigureTransitions(TaskletState curState) {
    }

    public void clearAllStatesOutgoingTransitions() {
        this.clearAllStatesOutgoingTransitions((TaskletState)this.getSourceState());
    }

    public void clearAllStatesOutgoingTransitions(TaskletState startState) {
        LinkedHashSet<TaskletState> statesToClear = new LinkedHashSet<TaskletState>();
        this.addAllStates(statesToClear, startState);
        for (TaskletState tempState : statesToClear) {
            tempState.clearOutgoingTransitions();
        }
    }

    public void grayAllStates() {
        this.grayAllStates((TaskletState)this.getSourceState());
    }

    public void grayAllStates(TaskletState startingState) {
        for (TaskletState tempState : this.stateList) {
            tempState.setItClickable(false);
        }
    }

    public boolean areAllStatesClicked() {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            if (!state.isItClickable()) {
                return false;
            }
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        boolean result = true;
        if (this.isAuthorizedForAction()) {
            TaskletTransition tt;
            TaskletState state = (TaskletState)this.getSourceState();
            do {
                result &= this.save(state, dataToDisk);
                state.setItClickable(true);
                tt = (TaskletTransition)state.getOutgoingTransition();
                if (tt == null) continue;
                state = (TaskletState)tt.getTarget();
            } while (tt != null && result);
        }
        return result;
    }

    public boolean save(TaskletState state, Object dataToDisk) {
        long start = System.currentTimeMillis();
        if (this.isAuthorizedForAction()) {
            return state.save(dataToDisk);
        }
        GuiTimingLog.log(start, state, this, "save");
        return true;
    }

    public boolean saveAllStates(Object dataToDisk) {
        boolean result = true;
        if (this.isAuthorizedForAction()) {
            LinkedHashSet<TaskletState> statesToPopulate = new LinkedHashSet<TaskletState>();
            TaskletState state = (TaskletState)this.getSourceState();
            this.addAllStates(statesToPopulate, state);
            for (TaskletState tempState : statesToPopulate) {
                result &= this.save(tempState, dataToDisk);
                tempState.setItClickable(true);
            }
        }
        return result;
    }

    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = true;
        ValidationDelegate delegate = this.getDelegate(cycle);
        TaskletState state = (TaskletState)this.getCurrentState();
        TaskletTransition tt = (TaskletTransition)state.getOutgoingTransition();
        if (tt == null) {
            long start = System.currentTimeMillis();
            continueProcessing = state.onStateExit();
            GuiTimingLog.log(start, state, this, "onStateExit");
            BaseComponent component = this.getBaseComponent(cycle, state, this);
            start = System.currentTimeMillis();
            state.appendComponentErrors((IValidationDelegate)delegate, component);
            GuiTimingLog.log(start, state, this, "appendComponentErrors");
            start = System.currentTimeMillis();
            state.appendErrors((IValidationDelegate)delegate, component, false);
            GuiTimingLog.log(start, state, this, "appendErrors");
            if (delegate.getHasErrors()) {
                continueProcessing = false;
            }
        } else {
            boolean moreStates = true;
            while (moreStates) {
                moreStates = this.next(cycle);
            }
            if (this.getCurrentState().getOutgoingTransition() != null) {
                continueProcessing = false;
            }
            if (delegate.getHasErrors()) {
                continueProcessing = false;
            }
        }
        if (continueProcessing) {
            ArrayList<SummaryInfo> summaryInfo = this.getSummary();
            for (SummaryInfo summaryObj : summaryInfo) {
                if (!summaryObj.getValidationDelegate().getHasErrors()) continue;
                continueProcessing = false;
                break;
            }
        }
        if (continueProcessing) {
            this.setHasErrors(false);
            this.finish();
        }
        return continueProcessing;
    }

    public void finish() {
        this.setCompleted(true);
        this.setCancelled(false);
        if (!this.isSkipPopToParent()) {
            this.popTaskletFromStack();
        } else {
            this.checkForClusterReplication();
            this.populate(null);
        }
    }

    public void checkForClusterReplication() {
        Mediator mediator = MgmtFactory.getMediator();
        mediator.reloadConfigChangeDate();
    }

    public void popTaskletFromStack() {
        DependencyErrorManagementState dependencyErrorManagementState;
        this.systemVisit.pop();
        if (this.systemVisit.size() == 1 || this.isAutoSaveTasklet(this.systemVisit)) {
            this.checkForClusterReplication();
        }
        ((TaskletState)this.systemVisit.peek().getCurrentState()).setTaskletToEdit(this);
        Tasklet currentTasklet = this.getSystemVisit().peek();
        IWizardState currentState = currentTasklet.getCurrentState();
        if (currentState instanceof DependencyErrorManagementState && !(dependencyErrorManagementState = (DependencyErrorManagementState)currentState).errorExists()) {
            ((DependencyErrorManagementTasklet)currentTasklet).setEmptyState();
        }
    }

    private boolean isAutoSaveTasklet(Visit systemVisit) {
        Tasklet topTasklet = systemVisit.peek();
        return topTasklet instanceof SingleStateTasklet && this.isAutoSaveState(topTasklet.getInitialState().getClass());
    }

    public boolean next(IRequestCycle cycle) {
        boolean traverseWorked = false;
        TaskletState taskletState = (TaskletState)this.getCurrentState();
        BaseComponent component = this.getBaseComponent(cycle, taskletState, this);
        ValidationDelegate delegate = this.getDelegate(cycle);
        long start = System.currentTimeMillis();
        taskletState.appendComponentErrors((IValidationDelegate)delegate, component);
        GuiTimingLog.log(start, taskletState, this, "appendComponentErrors");
        start = System.currentTimeMillis();
        taskletState.appendErrors((IValidationDelegate)delegate, component, false);
        GuiTimingLog.log(start, taskletState, this, "appendErrors");
        if (delegate.getHasErrors()) {
            return traverseWorked;
        }
        traverseWorked = this.traverseForward();
        ((TaskletState)this.getCurrentState()).setItClickable(true);
        return traverseWorked;
    }

    public void previous(IRequestCycle cycle) {
        this.wipeErrors(cycle);
        TaskletState currentState = (TaskletState)this.getCurrentState();
        currentState.onStateExitPrev();
        this.traverseBackward();
        TaskletState state = (TaskletState)this.getCurrentState();
        state.onStateRevisit();
    }

    public void swapTasklet(Tasklet taskletToSwap) {
        this.systemVisit.swapTasklet(taskletToSwap);
    }

    public Tasklet loadNewTasklet(Class<? extends Tasklet> newClass) {
        Tasklet newTasklet = this.createTaskletFromClass(newClass);
        this.loadTasklet(newTasklet);
        return newTasklet;
    }

    public Tasklet loadNewTasklet(String taskletName) {
        Tasklet newTasklet = null;
        try {
            Class<?> newClass = Class.forName(taskletName);
            newTasklet = (Tasklet)this.createTaskletFromClass(newClass);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        this.loadTasklet(newTasklet);
        return newTasklet;
    }

    public <T extends Tasklet> T createTaskletToLoad(Class<T> type, String taskletName, String menuName) {
        T newTasklet = this.createTaskletToLoad(type);
        ((Tasklet)newTasklet).setTaskletName(taskletName);
        ((Tasklet)newTasklet).setMenuName(menuName);
        ((Tasklet)newTasklet).setHelpName(taskletName);
        return newTasklet;
    }

    public <T extends Tasklet> T createTaskletToLoad(Class<T> newClass) {
        return this.createTaskletFromClass(newClass);
    }

    private <T extends Tasklet> T createTaskletFromClass(Class<T> newClass) {
        Tasklet newTasklet;
        Class[] parameters = new Class[]{Visit.class};
        try {
            Constructor<T> constructor = newClass.getConstructor(parameters);
            newTasklet = (Tasklet)constructor.newInstance(this.systemVisit);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Unable to create tasklet of type " + newClass, (Throwable)e);
        }
        newTasklet.setParentTasklet(this);
        newTasklet.setMode(this.mode);
        return (T)newTasklet;
    }

    public void loadTasklet(Tasklet tasklet) {
        if (!this.systemVisit.empty()) {
            Tasklet oldTasklet = this.systemVisit.peek();
            IWizardTransition iwt = oldTasklet.getCurrentState().getOutgoingTransition();
            tasklet.getCurrentState().setIncomingTransition(iwt);
        }
        this.systemVisit.push(tasklet);
        tasklet.getCurrentState().onStateActivated();
    }

    public void formListener(IRequestCycle cycle) {
        TaskletState state = (TaskletState)this.getCurrentState();
        state.setDelegate(this.getDelegate(cycle));
        state.executeSubmitRunnable();
        state.formListener(cycle);
    }

    public void executeSubmitListener(IRequestCycle cycle) {
        TaskletState state = (TaskletState)this.getCurrentState();
        state.setDelegate(this.getDelegate(cycle));
        long start = System.currentTimeMillis();
        state.executeSubmitListener(cycle);
        GuiTimingLog.log(start, state, this, "executeSubmitListener");
    }

    public boolean getHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public void wipeErrors(IRequestCycle cycle) {
        ValidationDelegate delegate = this.getDelegate(cycle);
        delegate.clear();
        delegate.clearErrors();
    }

    protected BaseComponent getBaseComponent(IRequestCycle cycle, TaskletState state, Tasklet tasklet) {
        String pageForCard = state.getPageName();
        IPage cardPage = cycle.getPage(pageForCard);
        String cardName = tasklet.getCurrentState().getStateName();
        return (BaseComponent)cardPage.getComponent(cardName);
    }

    public void onResumeDraft() {
        LinkedHashSet<TaskletState> states = new LinkedHashSet<TaskletState>();
        TaskletState sourceState = (TaskletState)this.getSourceState();
        this.addAllStates(states, sourceState);
        for (TaskletState tempState : states) {
            tempState.onResumeDraft();
        }
    }

    public void updateVisit(Visit freshVisit) {
        this.systemVisit = freshVisit;
        for (TaskletState tempState : this.stateList) {
            tempState.updateVisit(freshVisit);
        }
    }

    public ArrayList<SummaryInfo> getSummary() {
        this.summaryList = new ArrayList();
        LinkedBlockingQueue<String> path = new LinkedBlockingQueue<String>();
        this.setQueue(path);
        this.getSummary(this.summaryList);
        return this.summaryList;
    }

    public ArrayList<SummaryInfo> getSummaryHeader() {
        this.summaryHeader = new ArrayList();
        LinkedBlockingQueue<String> path = new LinkedBlockingQueue<String>();
        this.setQueue(path);
        this.getSummaryHeader(this.summaryHeader);
        return this.summaryHeader;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        SummaryInfo info = new SummaryInfo(this.menuName, "", state);
        info.setTaskletType(true);
        summaryList.add(info);
        do {
            long start = System.currentTimeMillis();
            state.getSummary(summaryList);
            GuiTimingLog.log(start, state, this, "getSummary");
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public void getSummaryHeader(ArrayList<SummaryInfo> summaryHeader) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            long start = System.currentTimeMillis();
            state.getSummaryHeader(summaryHeader);
            GuiTimingLog.log(start, state, this, "getSummaryHeader");
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public void setQueue(Queue<String> path) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            state.setQueue(path);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public ArrayList<SummaryInfo> getSummaryList() {
        return this.summaryList;
    }

    public Collection<TaskletState> getStateList() {
        ArrayList<TaskletState> al = new ArrayList<TaskletState>();
        this.getStateList(this, al);
        return al;
    }

    public void getStateList(Tasklet tasklet, ArrayList<TaskletState> al) {
        TaskletState state = (TaskletState)tasklet.getSourceState();
        al.add(state);
        TaskletTransition tt = (TaskletTransition)state.getOutgoingTransition();
        while (tt != null) {
            state = (TaskletState)tt.getTarget();
            al.add(state);
            tt = (TaskletTransition)state.getOutgoingTransition();
        }
    }

    public TaskletState getNextState(TaskletState initialState) {
        TaskletTransition tt = (TaskletTransition)initialState.getOutgoingTransition();
        return tt != null ? (TaskletState)tt.getTarget() : null;
    }

    public TaskletState findState(String stateName) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            if (state.getStateName().equals(stateName)) {
                return state;
            }
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
        return null;
    }

    public boolean isPreviousDisabled() {
        return ((TaskletState)this.getCurrentState()).getTaskletId().equals(((TaskletState)this.getSourceState()).getTaskletId());
    }

    public boolean isNextEnabled() {
        IWizardTransition[] transitionsArray = this.getCurrentState().getOutgoingTransitions();
        return transitionsArray.length > 0;
    }

    public boolean isStateActive(String menuName) {
        Tasklet tasklet = this.systemVisit.getInitialTasklet();
        String currentMenuName = ((TaskletState)tasklet.getCurrentState()).getMenuName();
        return currentMenuName.equals(menuName);
    }

    public boolean isCurrentTaskletActive(String menuName) {
        return this.menuName.equals(menuName);
    }

    public boolean isCurrentStateActive(String menuName) {
        String currentMenuName = ((TaskletState)this.getCurrentState()).getMenuName();
        return currentMenuName.equals(menuName);
    }

    public boolean isCurrentTaskletInitial() {
        return this.systemVisit.getInitialTasklet() == this.systemVisit.getCurrentTasklet();
    }

    public void resetCurrentStateToSourceState() {
        this.setCurrentState(this.getSourceState());
    }

    public boolean isCancelAvailable() {
        return this.cancelAvailable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setCancelAvailable(boolean cancelAvailable) {
        this.cancelAvailable = cancelAvailable;
    }

    public boolean isFinishAvailable() {
        this.finishAvailable = true;
        if (this.hideFinishButtonIfAuditor()) {
            this.finishAvailable = false;
        } else {
            TaskletTransition tt;
            TaskletState state = (TaskletState)this.getCurrentState();
            do {
                if (!state.isItClickable()) {
                    this.finishAvailable = false;
                    break;
                }
                tt = (TaskletTransition)state.getOutgoingTransition();
                if (tt == null) continue;
                state = (TaskletState)tt.getTarget();
            } while (tt != null);
        }
        return this.finishAvailable;
    }

    public void setFinishAvailable(boolean finishAvailable) {
        this.finishAvailable = finishAvailable;
    }

    public boolean getFinishAvailable() {
        return this.finishAvailable;
    }

    public boolean isNextAvailable() {
        return this.getCurrentState().getOutgoingTransition() != null;
    }

    public boolean isPreviousAvailable() {
        return this.getSourceState() != this.getCurrentState();
    }

    public boolean isSaveDraftAvailable() {
        return this.saveDraftAvailable;
    }

    public void setSaveDraftAvailable(boolean saveDraftAvailable) {
        this.saveDraftAvailable = saveDraftAvailable;
    }

    public Visit getSystemVisit() {
        return this.systemVisit;
    }

    public void setSystemVisit(Visit systemVisit) {
        this.systemVisit = systemVisit;
    }

    public AdministrativeUser getCurrentUser() {
        return this.getSystemVisit().getCurrentUser();
    }

    @Override
    public String getMenuName() {
        return this.menuName;
    }

    @Override
    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public void setTaskletName(String taskletName) {
        this.taskletName = taskletName;
    }

    public String getTaskletName() {
        return this.taskletName;
    }

    @Override
    public void clearErrors() {
    }

    public void setInitialState(TaskletState s) {
        this.setCurrentState(s);
        this.setSourceState(s);
        s.setItClickable(true);
    }

    public TaskletState getInitialState() {
        return (TaskletState)this.getSourceState();
    }

    public boolean isItDeleted() {
        return this.itDeleted;
    }

    public void setItDeleted(boolean itDeleted) {
        this.itDeleted = itDeleted;
    }

    public String getFinishId() {
        String finishLabel = this.getFinishLabel();
        if (finishLabel.contains(">")) {
            finishLabel = StringUtils.substringBefore((String)finishLabel, (String)">").trim();
        }
        return StringUtils.lowerCase((String)finishLabel) + "Button";
    }

    public String getFinishLabel() {
        return this.finishLabel;
    }

    public void setFinishLabel(String finishLabel) {
        this.finishLabel = finishLabel;
    }

    public <T> T findParent(Class<T> type) {
        for (Tasklet parent = ((TaskletState)this.getCurrentState()).getParent(); parent != null; parent = parent.getParentTasklet()) {
            if (!type.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }

    public Tasklet getParentTasklet() {
        return this.parentTasklet;
    }

    public void setParentTasklet(Tasklet parentTasklet) {
        this.parentTasklet = parentTasklet;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getTaskletName().toLowerCase().compareTo(o.getTaskletName().toLowerCase());
    }

    public String getClassType() {
        return this.itDeleted ? "disabled" : "plain";
    }

    public boolean isItPortal() {
        return this.itPortal;
    }

    public void setItPortal(boolean itPortal) {
        this.itPortal = itPortal;
    }

    @Override
    public String getTaskletId() {
        return this.taskletId;
    }

    public void setTaskletId(String taskletId) {
        this.taskletId = taskletId;
    }

    @Override
    public String getHelpName() {
        return this.helpName;
    }

    public void setHelpName(String helpName) {
        this.helpName = helpName;
    }

    public String getGotoState() {
        return this.gotoState;
    }

    public void setGotoState(String gotoState) {
        this.gotoState = gotoState;
    }

    public ValidationDelegate getDelegate(IRequestCycle cycle) {
        BasePage page = (BasePage)cycle.getPage("Home");
        return (ValidationDelegate)page.getBeans().getBean("delegate");
    }

    public ValidationDelegate getDelegate() {
        BasePage page = (BasePage)this.getCycle().getPage("Home");
        return (ValidationDelegate)page.getBeans().getBean("delegate");
    }

    public void setCycle(IRequestCycle cycle) {
        if (this.parentTasklet == null) {
            this.cycle = cycle;
        } else {
            this.parentTasklet.setCycle(cycle);
        }
    }

    public IRequestCycle getCycle() {
        if (this.parentTasklet == null) {
            return this.cycle;
        }
        return this.parentTasklet.getCycle();
    }

    public boolean isPostInstallWizard() {
        return this.postInstallWizard;
    }

    public void setPostInstallWizard(boolean postInstallWizard) {
        this.postInstallWizard = postInstallWizard;
    }

    public boolean isGlobalEditInProgress() {
        return this.globalEditInProgress;
    }

    public void setGlobalEditInProgress(boolean globalEditInProgress) {
        this.globalEditInProgress = globalEditInProgress;
    }

    public boolean showFinishButtonIfAuditor() {
        return this.hideFinishButtonIfAuditor();
    }

    public boolean hideFinishButtonIfAuditor() {
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return user.isAuditor();
    }

    public String getMessage(String key) {
        return this.systemVisit.getMessages().getMessage(this.getMessageSimpleName() + "_" + key);
    }

    public String getMessage(String key, Object[] argument) {
        return this.systemVisit.getMessages().format(this.getMessageSimpleName() + "_" + key, argument);
    }

    public String getMessage(String messageSimpleName, String key) {
        return this.systemVisit.getMessages().getMessage(messageSimpleName + "_" + key);
    }

    public String format(String key, Object argument) {
        return this.systemVisit.getMessages().format(this.getMessageSimpleName() + "_" + key, argument);
    }

    public String format(String key, Object argument1, Object argument2) {
        return this.systemVisit.getMessages().format(this.getMessageSimpleName() + "_" + key, argument1, argument2);
    }

    public String format(String key, Object argument1, Object argument2, Object argument3) {
        return this.systemVisit.getMessages().format(this.getMessageSimpleName() + "_" + key, argument1, argument2, argument3);
    }

    public String getMessageSimpleName() {
        return this.messageSimpleName;
    }

    public void setMessageSimpleName(String messageSimpleName) {
        this.messageSimpleName = messageSimpleName;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public Protocol getProtocolTypeEnum() {
        Tasklet t = this.systemVisit.getTasklet();
        if (t != null && t.findParent(ConnectionTasklet.class) != null) {
            Protocol protocol = null;
            ConnectionTasklet connectionTasklet = t.findParent(ConnectionTasklet.class);
            if (ConnectionType.IDP == connectionTasklet.getConnectionType()) {
                IdpConnectionConfigTasklet idp = (IdpConnectionConfigTasklet)connectionTasklet;
                protocol = idp.getProtocolType();
            } else if (ConnectionType.SP == connectionTasklet.getConnectionType()) {
                SpConnectionConfigTasklet sp = (SpConnectionConfigTasklet)connectionTasklet;
                protocol = sp.getProtocolType();
            }
            return protocol;
        }
        return null;
    }

    public List<ConnectionImageType> getConnectionImageTypes() {
        List<ConnectionImageType> connectionImageTypes = null;
        Tasklet t = this.systemVisit.getTasklet();
        if (t != null && t.findParent(ConnectionTasklet.class) != null) {
            ConnectionTasklet connectionTasklet = t.findParent(ConnectionTasklet.class);
            connectionImageTypes = connectionTasklet.getConnectionImageTypes();
        }
        return connectionImageTypes;
    }

    public void markProtocolImgAvailable(boolean displayImage) {
        TaskletTransition tt;
        this.setProtocolImgAvailable(displayImage);
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            state.markProtocolImgAvailable(displayImage);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public boolean isProtocolImgAvailable() {
        return this.protocolImgAvailable;
    }

    public void setProtocolImgAvailable(boolean protocolImgAvailable) {
        this.protocolImgAvailable = protocolImgAvailable;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isModeCreate() {
        return this.mode == Mode.create;
    }

    public boolean isModeEdit() {
        return this.mode == Mode.edit;
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
        TaskletState state = (TaskletState)this.getSourceState();
        if (state != null) {
            TaskletTransition tt;
            do {
                state.setMode(mode);
                tt = (TaskletTransition)state.getOutgoingTransition();
                if (tt == null) continue;
                state = (TaskletState)tt.getTarget();
            } while (tt != null);
        }
    }

    public Object getPopulateData() {
        return this.populateData;
    }

    public void setPopulateData(Object populateData) {
        this.populateData = populateData;
    }

    public boolean isAuthorizedForAction() {
        return !this.getCurrentUser().isAuditor();
    }

    @Override
    public void setCurrentState(IWizardState currentState) {
        super.setCurrentState(currentState);
        Visit v = this.getSystemVisit();
        if (log.isDebugEnabled() && !v.isSkipForUIPerformanceFlag()) {
            log.debug((Object)("Current state for: " + this.getClass().getSimpleName() + " is: " + currentState.getClass().getSimpleName()));
        }
    }

    public void prepareAllStatesForDraft() {
        ((TaskletState)this.getCurrentState()).prepareForTestDraft();
    }

    public boolean wasTestDraftSuccessful() {
        if (this.isAuthorizedForAction()) {
            this.prepareAllStatesForDraft();
            DraftManager draftManager = DraftManagerImpl.getInstance();
            Stack<Tasklet> stackToSerialize = this.getSystemVisit().getTaskletStack();
            return draftManager.testSerializeTaskletStack(stackToSerialize);
        }
        return false;
    }

    public boolean showSaveDraftButton() {
        return this.isSaveDraftAvailable() && this.isModeCreate() && this.wasTestDraftSuccessful();
    }

    public void addSuffixToStateHelpId(String suffix) {
        TaskletTransition tt;
        TaskletState state = (TaskletState)this.getSourceState();
        do {
            long start = System.currentTimeMillis();
            state.setHelpId(state.getHelpId() + "_" + suffix);
            GuiTimingLog.log(start, state, this, "populate");
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public boolean showSaveAll() {
        return this.isSaveAllAvailable() && this.isFinishAvailable() && "Done".equals(this.systemVisit.getCurrentTasklet().getFinishLabel());
    }

    public boolean hasConnectionWizard() {
        return this.systemVisit.getCurrentTasklet().findParent(ConnectionTasklet.class) != null;
    }

    public boolean hasServerSettingWizard() {
        return this.systemVisit.getCurrentTasklet().findParent(CertManagementTasklet.class) != null;
    }

    public boolean isSaveAllAvailable() {
        return this.isModeEdit();
    }

    public boolean isInitialSetup() {
        if (this.getParentTasklet() != null) {
            return this.getParentTasklet().isInitialSetup();
        }
        return false;
    }

    public boolean isLicensingAgreement() {
        if (this.getParentTasklet() != null) {
            return this.getParentTasklet().isLicensingAgreement();
        }
        return false;
    }

    public boolean isFullWidth() {
        if (this.getParentTasklet() != null) {
            return this.getParentTasklet().isFullWidth();
        }
        return false;
    }

    public boolean isLicensed() {
        return LicenseManager.isValidForGui();
    }

    public boolean isPrimaryAction(String buttonName) {
        if ("Save".equals(buttonName) && this.showSaveAll()) {
            return true;
        }
        if ("Done".equals(buttonName) && this.isFinishAvailable() && !this.showSaveAll()) {
            return true;
        }
        return "Next".equals(buttonName) && this.isNextAvailable() && this.isNextEnabled() && !this.isFinishAvailable() && !this.showSaveAll();
    }

    public boolean isBridgeMode() {
        return LicenseManager.getLicense().isBridgeMode();
    }

    protected boolean hasCertificateRevocationChecking() {
        return this.findParent(CertificateRevocationCheckingTasklet.class) != null;
    }

    public boolean isSkipPopToParent() {
        return this.skipPopToParent;
    }

    public void setSkipPopToParent(boolean skipPopToParent) {
        this.skipPopToParent = skipPopToParent;
    }

    public boolean gotoSummaryIfPopSkipped() {
        return false;
    }

    public boolean doNavMenuReload() {
        if (!this.previousNavMenuReload && this.navMenuReload) {
            this.previousNavMenuReload = true;
            return true;
        }
        return false;
    }

    public void setupNavMenuReload() {
        this.previousNavMenuReload = false;
        this.navMenuReload = true;
    }

    public String getNavMenuTarget() {
        return this.navMenuTarget;
    }

    public void setNavMenuTarget(String navMenuTarget) {
        this.navMenuTarget = navMenuTarget;
    }

    public boolean isAutoSaveState(Class clazz) {
        return AnnotationUtils.findAnnotation((Class)clazz, AutoSaveState.class) != null;
    }

    public boolean isMultitabWarningDisabled() {
        ConfigStore store = ConfigStoreFarm.getConfig((String)"com.pingidentity.page.Login");
        return store.getBooleanValue("disable-multitab-alert", false);
    }

    public boolean displayNotificationBanner() {
        return this.systemVisit.hasNotificationBannerContent();
    }

    public String getNotificationBannerContent() {
        NotificationBanner notificationBanner = this.systemVisit.consumeNotificationBanner();
        return notificationBanner.getType().getId() + ":" + notificationBanner.getMessage();
    }
}

