/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.GuiTimingLog;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.tapestry.IRequestCycle;

public class TaskletListState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private List<Tasklet> tasklets = new ArrayList<Tasklet>();
    private Comparator<Tasklet> comparator;

    public TaskletListState(IWizard owner, String name) {
        super(owner, name);
    }

    public TaskletListState(IWizard owner) {
        super(owner);
    }

    @Override
    public void onResumeDraft() {
        for (Tasklet tasklet : this.getTasklets()) {
            tasklet.onResumeDraft();
        }
    }

    @Override
    public void updateVisit(Visit freshVisit) {
        for (Tasklet tasklet : this.getTasklets()) {
            tasklet.updateVisit(freshVisit);
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        super.getSummary(summaryList);
        for (Tasklet tasklet : this.tasklets) {
            if (tasklet.isItDeleted()) continue;
            long start = System.currentTimeMillis();
            tasklet.getSummary(summaryList);
            GuiTimingLog.log(start, null, tasklet, "getSummary");
        }
    }

    @Override
    public void initialize() {
        for (Tasklet tasklet : this.tasklets) {
            long start = System.currentTimeMillis();
            tasklet.initialize();
            GuiTimingLog.log(start, null, tasklet, "initialize");
        }
    }

    @Override
    public void setQueue(Queue<String> returnPath) {
        super.setQueue(returnPath);
        for (Tasklet tasklet : this.tasklets) {
            LinkedBlockingQueue<String> temp = new LinkedBlockingQueue<String>(this.path);
            temp.add(tasklet.getTaskletId());
            tasklet.setQueue(temp);
        }
    }

    @Override
    public void jumpToState(IRequestCycle cycle, Queue<String> returnPath) {
        String taskletId = returnPath.poll();
        for (Tasklet tasklet : this.tasklets) {
            if (!taskletId.equals(tasklet.getTaskletId())) continue;
            Tasklet currentTasklet = (Tasklet)this.getWizard();
            currentTasklet.loadTasklet(tasklet);
            tasklet.jumpToState(cycle, returnPath);
            this.setTaskletToEdit(tasklet);
        }
    }

    public List<Tasklet> getTasklets() {
        return this.tasklets;
    }

    public List<Tasklet> getUndeletedTasklets() {
        ArrayList<Tasklet> undeletedTasklets = new ArrayList<Tasklet>();
        for (Tasklet tasklet : this.tasklets) {
            if (tasklet.isItDeleted()) continue;
            undeletedTasklets.add(tasklet);
        }
        return undeletedTasklets;
    }

    public Tasklet getTasklet(int index) {
        return this.tasklets.get(index);
    }

    public void setTasklets(ArrayList<Tasklet> tasklets) {
        this.tasklets = tasklets;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (!taskletToEdit.isCancelled() && !this.tasklets.contains(taskletToEdit)) {
            this.tasklets.add(taskletToEdit);
        }
    }

    public void addTasklet(Tasklet tasklet) {
        if (!this.tasklets.contains(tasklet)) {
            this.tasklets.add(tasklet);
        }
    }

    public void deleteTasklet(Tasklet tasklet) {
        if (this.tasklets.contains(tasklet)) {
            if (tasklet.isItDeleted()) {
                tasklet.setItDeleted(false);
            } else {
                tasklet.setItDeleted(true);
            }
        }
    }

    public void deleteTasklet(Integer taskletToDelete) {
        this.deleteTasklet(this.tasklets.get(taskletToDelete));
    }

    public void refreshTasklets() {
        Iterator<Tasklet> iter = this.tasklets.iterator();
        while (iter.hasNext()) {
            Tasklet tasklet = iter.next();
            if (!tasklet.isItDeleted()) continue;
            iter.remove();
        }
    }

    public void deleteAllTasklets() {
        this.tasklets.clear();
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.cancelTasklets();
    }

    @Override
    public void reset() {
        this.cancelTasklets();
    }

    @Override
    public boolean save(Object dataToDisk) {
        for (Tasklet tasklet : this.tasklets) {
            tasklet.save(dataToDisk);
        }
        return true;
    }

    public int getTaskletListSize() {
        return this.tasklets.size();
    }

    @Override
    public void setMode(Mode mode) {
        for (Tasklet tasklet : this.tasklets) {
            tasklet.setMode(mode);
        }
    }

    @Override
    public void markProtocolImgAvailable(boolean displayImage) {
        for (Tasklet t : this.getTasklets()) {
            t.markProtocolImgAvailable(displayImage);
        }
    }

    private void cancelTasklets() {
        for (Tasklet tasklet : this.tasklets) {
            long start = System.currentTimeMillis();
            if (tasklet.isItDeleted()) {
                this.deleteTasklet(tasklet);
            }
            tasklet.cancel();
            GuiTimingLog.log(start, null, tasklet, "cancel");
        }
    }

    public void sort(Comparator<Tasklet> c) {
        Collections.sort(this.tasklets, c);
        this.comparator = c;
    }

    protected void sort() {
        Collections.sort(this.tasklets);
        this.comparator = null;
    }

    public Comparator<Tasklet> getComparator() {
        return this.comparator;
    }
}

