/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.IWizardTransition;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.impl.WizardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.TaskletTraversal;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.documentation.DocumentationHelper;
import com.pingidentity.validator.HasErrorsValidationDelegate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMessages;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class TaskletState
extends WizardState
implements TaskletTraversal {
    private static final long serialVersionUID = 20050515L;
    protected transient Log log = LogFactory.getLog(this.getClass());
    protected static final String SELECT = "- Select -";
    protected static final String NONE = "None";
    private String pageName = "Holder";
    protected Class<? extends Tasklet> newTaskletClass;
    private Tasklet taskletToEdit;
    private boolean taskletToEditNew = true;
    private String menuName = "State Menu Item";
    private boolean itClickable;
    protected Queue<String> path;
    protected transient ValidationDelegate delegate;
    private boolean showNote = true;
    private String noteKey;
    private String messageSimpleName;
    private boolean viewOnly;
    private String helpId;
    private String keyContext;
    private transient Runnable submitRunnable;

    public TaskletState(IWizard owner) {
        super(owner, "");
        this.stateName = this.deriveComponentName();
        this.messageSimpleName = this.getClass().getSimpleName();
        ((Tasklet)owner).addState(this);
    }

    public TaskletState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.messageSimpleName = this.getClass().getSimpleName();
        ((Tasklet)owner).addState(this);
    }

    @Override
    public void setIncomingTransition(IWizardTransition value) {
        if (value != null && this.getParent() != null && value.getWizard() == this.getParent()) {
            super.setIncomingTransition(value);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void onStateActivated() {
    }

    @Override
    public void populate(Object dataFromDisk) {
    }

    @Override
    public boolean populateAllStates(Object data) {
        return false;
    }

    public void setPopulateDate(Object data) {
    }

    public void refreshState() {
    }

    @Override
    public boolean onStateExit() {
        return true;
    }

    public void onStateExitPrev() {
    }

    @Override
    public boolean save(Object dataToDisk) {
        return true;
    }

    @Override
    public void onCancel(IRequestCycle cycle) {
    }

    public void cancel(Object newData) {
        this.populate(newData);
    }

    public void reset() {
    }

    public Tasklet getTaskletToEdit() {
        return this.taskletToEdit;
    }

    public <T> T getTaskletToEdit(Class<T> type) {
        return (T)this.taskletToEdit;
    }

    public void setTaskletToEdit(Tasklet taskletToEdit) {
        this.taskletToEdit = taskletToEdit;
        if (!taskletToEdit.isCancelled()) {
            this.refreshState();
        }
    }

    public void setTaskletToEditToNull() {
        this.taskletToEdit = null;
    }

    public void loadTaskletToEdit() {
    }

    public Class<? extends Tasklet> getNewTaskletClass() {
        return this.newTaskletClass;
    }

    public void setNewTaskletClass(Class<? extends Tasklet> newTaskletClass) {
        this.newTaskletClass = newTaskletClass;
    }

    public boolean isTaskletToEditNew() {
        return this.taskletToEditNew;
    }

    public void setTaskletToEditNew(boolean taskletToEditNew) {
        this.taskletToEditNew = taskletToEditNew;
    }

    public void onResumeDraft() {
        this.log = LogFactory.getLog(this.getClass());
        if (this.taskletToEdit != null) {
            this.taskletToEdit.onResumeDraft();
        }
        this.onStateActivated();
    }

    public void updateVisit(Visit freshVisit) {
        if (this.taskletToEdit != null) {
            this.taskletToEdit.updateVisit(freshVisit);
        }
    }

    public boolean isSaveDraftAvailable() {
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.menuName, "", this, true));
        this.doSummary(summaryList);
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
    }

    @Override
    public void getSummaryHeader(ArrayList<SummaryInfo> summaryHeader) {
        this.doSummaryHeader(summaryHeader);
    }

    public void doSummaryHeader(ArrayList<SummaryInfo> summaryList) {
    }

    public void jumpToState(IRequestCycle cycle, Queue<String> path) {
    }

    @Override
    public void setQueue(Queue<String> returnPath) {
        this.path = new LinkedBlockingQueue<String>(returnPath);
        this.path.add(this.getTaskletId());
    }

    public Queue<String> getQueue() {
        return this.path;
    }

    public List<SummaryInfo> getSummaryList() {
        return null;
    }

    public void executeSubmitListener(IRequestCycle cycle) {
        IPage page = cycle.getPage(this.getPageName());
        String stateName = this.getStateName();
        TaskletCard component = (TaskletCard)page.getComponent(stateName);
        component.executeSubmitListener(cycle);
    }

    public void setSubmitListener(IRequestCycle cycle, IActionListener newListener) {
        IPage page = cycle.getPage(this.getPageName());
        String stateName = this.getStateName();
        TaskletCard component = (TaskletCard)page.getComponent(stateName);
        component.setSubmitListener(newListener);
    }

    public void formListener(IRequestCycle cycle) {
    }

    public void setSubmitRunnable(Runnable submitRunnable) {
        this.submitRunnable = submitRunnable;
    }

    public void executeSubmitRunnable() {
        if (this.submitRunnable != null) {
            this.submitRunnable.run();
            this.submitRunnable = null;
        }
    }

    public boolean isItClickable() {
        return this.itClickable;
    }

    public void setItClickable(boolean itClickable) {
        this.itClickable = itClickable;
    }

    public void addOutgoingTransition(IWizard owner, IWizardState target) {
        String name = owner.getClass().getSimpleName() + "-" + this.getClass().getSimpleName() + "-" + target.getClass().getSimpleName();
        this.addOutgoingTransition(new TaskletTransition(owner, name, target));
    }

    public void addOutgoingTransition(IWizard owner, String name, IWizardState target) {
        this.addOutgoingTransition(new TaskletTransition(owner, name, target));
    }

    public ValidationDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ValidationDelegate delegate) {
        this.delegate = delegate;
    }

    public void appendComponentErrors(IValidationDelegate delegate, BaseComponent component) {
        for (Object internalComponent : component.getComponents().values()) {
            if (!(internalComponent instanceof TaskletCard)) continue;
            TaskletCard c = (TaskletCard)((Object)internalComponent);
            c.appendComponentErrors(delegate);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
    }

    @Override
    public boolean checkForErrors() {
        IRequestCycle cycle = this.getParent().getCycle();
        IPage cardPage = cycle.getPage(this.getPageName());
        BaseComponent baseComponent = (BaseComponent)cardPage.getComponent(this.getStateName());
        HasErrorsValidationDelegate hasErrorDelegate = new HasErrorsValidationDelegate();
        this.appendErrors(hasErrorDelegate, baseComponent, true);
        return hasErrorDelegate.getHasErrors();
    }

    public String getMessageWithFullKey(String fullKey) {
        return this.getParent().getSystemVisit().getMessages().getMessage(fullKey, null);
    }

    public String getMessageWithFullKey(String fullKey, Object[] params) {
        String message = this.getParent().getSystemVisit().getMessages().getMessage(fullKey, null);
        if (message != null) {
            return this.getParent().getSystemVisit().getMessages().format(fullKey, params);
        }
        return null;
    }

    public String getMessage(String key) {
        return this.getMessage(this.getMessageSimpleName(), key, null);
    }

    private String getMessage(String messageSimpleName, String key, Object[] arguments) {
        String tryKey;
        String msg;
        String failoverKey = messageSimpleName + "_" + key;
        IMessages msgs = this.getParent().getSystemVisit().getMessages();
        if (this.keyContext != null && (msg = msgs.getMessage(tryKey = failoverKey + "_" + this.keyContext, null)) != null) {
            if (arguments == null) {
                return msg;
            }
            return msgs.format(tryKey, arguments);
        }
        if (arguments == null) {
            return msgs.getMessage(failoverKey);
        }
        return msgs.format(failoverKey, arguments);
    }

    public String getMessage(String key, Object[] arguments) {
        return this.getMessage(this.getMessageSimpleName(), key, arguments);
    }

    public String getMessage(String messageSimpleName, String key) {
        return this.getMessage(messageSimpleName, key, null);
    }

    public String getInlineHelpMessage(String key) {
        return this.getInlineHelpMessage(this.getMessageSimpleName(), key);
    }

    public String getInlineHelpMessage(String messageSimpleName, String key) {
        return this.getMessage(messageSimpleName, "inline_help_" + key);
    }

    public String format(String key, Object argument) {
        return this.getMessage(key, new Object[]{argument});
    }

    public String format(String key, Object argument1, Object argument2) {
        return this.getMessage(key, new Object[]{argument1, argument2});
    }

    public String format(String key, Object argument1, Object argument2, Object argument3) {
        return this.getMessage(key, new Object[]{argument1, argument2, argument3});
    }

    public Tasklet getParent() {
        return (Tasklet)this.getWizard();
    }

    public <T> T getParent(Class<T> type) {
        return (T)this.getWizard();
    }

    public <T> T findParent(Class<T> type) {
        for (Tasklet parent = this.getParent(); parent != null; parent = parent.getParentTasklet()) {
            if (!type.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }

    public <S> S findParentState(Class<S> state) {
        for (Tasklet parent = this.getParent(); parent != null; parent = parent.getParentTasklet()) {
            IWizardState currentState = parent.getCurrentState();
            if (!state.isInstance(currentState)) continue;
            return (S)currentState;
        }
        return null;
    }

    public <T extends Tasklet> T createTaskletToLoad(Class<T> type) {
        return this.getParent().createTaskletToLoad(type);
    }

    public <T extends Tasklet> T createTaskletToLoad(Class<T> type, String taskletName, String menuName) {
        return this.getParent().createTaskletToLoad(type, taskletName, menuName);
    }

    public <T extends Tasklet> T createTasklet(Class<T> type) {
        return this.getParent().createTaskletToLoad(type);
    }

    public void loadTasklet(Tasklet tasklet) {
        this.getParent().loadTasklet(tasklet);
    }

    @Override
    public String getMenuName() {
        return this.menuName;
    }

    @Override
    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    @Override
    public String getHelpName() {
        return DocumentationHelper.getDocumentationJavascript((String)("help_" + this.getHelpId()));
    }

    public String getHelpUrl() {
        return DocumentationHelper.getDocumentationUrl((String)("help_" + this.getHelpId()));
    }

    public String getHelpId() {
        return this.helpId == null ? this.getTaskletStateId() : this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }

    @Override
    public String getTaskletId() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public String getTaskletStateId() {
        if (this.getWizard() == null) {
            return this.getClass().getSimpleName();
        }
        return this.getParent().getHelpName() + "_" + this.getClass().getSimpleName();
    }

    public String deriveComponentName() {
        String cname = this.getClass().getSimpleName();
        if (cname.endsWith("State")) {
            cname = cname.substring(0, cname.length() - "State".length());
        }
        cname = cname.substring(0, 1).toLowerCase().concat(cname.substring(1));
        return cname;
    }

    public String getNoteKey() {
        if (this.noteKey != null) {
            return this.noteKey;
        }
        return this.getTaskletStateId();
    }

    public void setNoteKey(String noteKey) {
        this.noteKey = noteKey;
    }

    public boolean isShowNote() {
        return this.showNote;
    }

    public void setShowNote(boolean showNote) {
        this.showNote = showNote;
    }

    public Object[] getFormatObjects() {
        return null;
    }

    @Override
    public void processState() {
    }

    @Override
    public void resetBooleans() {
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    @Override
    public String getStateName() {
        return this.viewOnly ? this.stateName + "Vo" : this.stateName;
    }

    public void setViewOnly(boolean viewOnly, String noteKey) {
        this.setViewOnly(viewOnly);
        this.setNoteKey(noteKey);
    }

    public String getMessageSimpleName() {
        return this.messageSimpleName;
    }

    public void setMessageSimpleName(String messageSimpleName) {
        this.messageSimpleName = messageSimpleName;
    }

    public Visit getVisit() {
        return this.getParent().getSystemVisit();
    }

    @Override
    public void setMode(Mode mode) {
    }

    public void onStateRevisit() {
    }

    public void prepareForTestDraft() {
    }

    public void markProtocolImgAvailable(boolean displayImage) {
    }

    public AdministrativeUser getCurrentUser() {
        return this.getVisit().getCurrentUser();
    }

    public boolean isAuthorizedForAction() {
        return !this.getCurrentUser().isAuditor();
    }

    public void recordErrorMsg(String message) {
        TaskletState.recordErrorMsg(message, (IValidationDelegate)this.getDelegate());
    }

    public static void recordErrorMsg(String message, IValidationDelegate validationDelegate) {
        validationDelegate.setFormComponent(null);
        validationDelegate.record(message, ValidationConstraint.REQUIRED);
    }

    public static void recordErrorMsgs(List<String> messages, IValidationDelegate validationDelegate) {
        for (String message : messages) {
            TaskletState.recordErrorMsg(message, validationDelegate);
        }
    }

    public void recordErrors(List<ValidationError> errors, IValidationDelegate delegate) {
        for (String errorMessage : this.convertErrorMessages(errors)) {
            delegate.setFormComponent(null);
            delegate.record(errorMessage, ValidationConstraint.REQUIRED);
        }
    }

    public List<String> convertErrorMessages(List<ValidationError> errors) {
        ArrayList<String> result = new ArrayList<String>();
        for (ValidationError error : errors) {
            String uiSpecificMessage = null;
            uiSpecificMessage = error.getMessageParams() == null ? this.getMessageWithFullKey(error.getErrorId()) : this.getMessageWithFullKey(error.getErrorId(), error.getMessageParams());
            String errorMessage = uiSpecificMessage != null ? uiSpecificMessage : error.getMessage();
            result.add(errorMessage);
        }
        return result;
    }

    public Map<String, IComponent> getPageComponents() {
        IRequestCycle cycle = this.getParent().getCycle();
        IPage cardPage = cycle.getPage(this.getPageName());
        BaseComponent baseComponent = (BaseComponent)cardPage.getComponent(this.getStateName());
        return baseComponent.getComponents();
    }

    public HttpServletRequest getRequestContext() {
        return this.getParent().getCycle().getRequestContext().getRequest();
    }

    public String getKeyContext() {
        return this.keyContext;
    }

    public void setKeyContext(String keyContext) {
        this.keyContext = keyContext;
    }

    public boolean isEnableIdP() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableIdP();
    }

    public boolean isEnableSP() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableSP();
    }

    public boolean isEnableOauth() {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        return authzServerManager.isEnableOAuth();
    }

    public boolean isPartnerVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin() || user.isAuditor();
    }

    public boolean isSecurityVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isCryptoManager() || user.isAdmin() || user.isAuditor();
    }

    public boolean isNextEnabled() {
        return true;
    }
}

