/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.comparator;

import com.pingidentity.fsm.state.impl.PluginMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class PluginHierarchyComparator
implements Comparator<Tasklet> {
    private final HashMap<String, String> child2Parent = new HashMap();

    public PluginHierarchyComparator(PluginMgmtState<?, ?> pluginMgmtState) {
        String parentId;
        HashMap<String, String> id2Name = new HashMap<String, String>();
        for (ConfigurablePluginInstance configurablePluginInstance : pluginMgmtState.getInstances()) {
            id2Name.put(configurablePluginInstance.getId(), configurablePluginInstance.getName());
            parentId = configurablePluginInstance.getParentId();
            if (parentId == null) continue;
            this.child2Parent.put(configurablePluginInstance.getName(), parentId);
        }
        for (Map.Entry entry : this.child2Parent.entrySet()) {
            parentId = (String)entry.getValue();
            entry.setValue((String)id2Name.get(parentId));
        }
    }

    @Override
    public int compare(Tasklet o1, Tasklet o2) {
        PluginInstanceTasklet instanceTasklet1 = (PluginInstanceTasklet)o1;
        PluginInstanceTasklet instanceTasklet2 = (PluginInstanceTasklet)o2;
        Iterator ancestors1 = this.getAncestors(instanceTasklet1.getName()).iterator();
        Iterator ancestors2 = this.getAncestors(instanceTasklet2.getName()).iterator();
        while (ancestors1.hasNext()) {
            String pluginName1 = (String)ancestors1.next();
            if (!ancestors2.hasNext()) {
                return 1;
            }
            String pluginName2 = (String)ancestors2.next();
            if (pluginName1.equals(pluginName2)) continue;
            return pluginName1.compareToIgnoreCase(pluginName2);
        }
        if (ancestors2.hasNext()) {
            return -1;
        }
        return 0;
    }

    private LinkedList<String> getAncestors(String childName) {
        LinkedList<String> ancestors = new LinkedList<String>();
        String parentName = childName;
        while (parentName != null) {
            ancestors.addFirst(parentName);
            parentName = this.child2Parent.get(parentName);
        }
        return ancestors;
    }
}

