/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.CertificateService;
import java.io.Serializable;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class CertItem
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private transient CertificateService certService = (CertificateService)GlobalRegistry.getService(CertificateService.class);
    private Cert cert;
    private boolean itDeleted;
    private boolean active;
    private boolean activeSecondary;
    private boolean newCert;
    private boolean alreadyInUse;
    private boolean activeAdminSslCert;
    private boolean imported;
    private boolean defaultSslServerRuntime;
    private boolean defaultSslServerAdmin;

    public CertItem(Cert cert) {
        this.setCert(cert);
    }

    public boolean isItDeleted() {
        return this.itDeleted;
    }

    public void setItDeleted(boolean itDeleted) {
        this.itDeleted = itDeleted;
    }

    public Cert getCert() {
        return this.cert;
    }

    public void setCert(Cert cert) {
        this.cert = cert;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActiveSecondary() {
        return this.activeSecondary;
    }

    public void setActiveSecondary(boolean activeSecondary) {
        this.activeSecondary = activeSecondary;
    }

    public boolean isNewCert() {
        return this.newCert;
    }

    public boolean isActiveAdminSslCert() {
        return this.activeAdminSslCert;
    }

    public void setActiveAdminSslCert(boolean activeAdminSslCert) {
        this.activeAdminSslCert = activeAdminSslCert;
    }

    public void setNewCert(boolean newCert) {
        this.newCert = newCert;
    }

    public boolean isAlreadyInUse() {
        return this.alreadyInUse;
    }

    public void setAlreadyInUse(boolean alreadyInUse) {
        this.alreadyInUse = alreadyInUse;
    }

    public boolean isInUseAsDsigCert() {
        if (this.active) {
            return true;
        }
        return InUseDetectionUtil.getInstance().isDsigCertInUse(this.cert);
    }

    public boolean isInUseAsAuthCert() {
        if (this.active) {
            return true;
        }
        return InUseDetectionUtil.getInstance().isSslAuthCertInUse(this.cert);
    }

    public boolean isCertExpired() {
        try {
            if (this.cert != null) {
                this.cert.getX509Certificate().checkValidity(new Date());
                return false;
            }
        }
        catch (CertificateExpiredException cee) {
            return true;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        return false;
    }

    public boolean isCertNotYetValid() {
        try {
            if (this.cert != null) {
                this.cert.getX509Certificate().checkValidity(new Date());
                return false;
            }
        }
        catch (CertificateNotYetValidException cnyve) {
            return true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            // empty catch block
        }
        return false;
    }

    public boolean isKnownToBeRevoked() {
        return CertificateHelper.isKnownToBeRevoked((Cert)this.cert);
    }

    public String getDeletedButtonText() {
        if (this.itDeleted) {
            return "Undelete";
        }
        return "Delete";
    }

    public String getDeletedCssClass() {
        if (this.itDeleted) {
            return "disabled";
        }
        return "plain";
    }

    public String getStatusCssClass() {
        if (this.itDeleted) {
            return "disabled";
        }
        if (CertificateHelper.isKnownToBeRevoked((Cert)this.cert)) {
            return "revoked";
        }
        if (this.isCertExpired()) {
            return "expired";
        }
        if (this.isCertNotYetValid()) {
            return "notyetvalid";
        }
        return "active";
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public boolean isCertOfSupportedKey() {
        boolean supported = false;
        String certKeyAlgo = this.cert.getPublicKeyAlgorithm();
        Collection availableAlgorithms = this.certService.getAvailableKeyAlgorithms();
        boolean isSelfSigned = CertificateHelper.isSelfSigned((X509Certificate)this.cert.getX509Certificate());
        if (isSelfSigned) {
            for (String algo : availableAlgorithms) {
                if (!certKeyAlgo.equals(algo)) continue;
                supported = true;
                break;
            }
        }
        return supported;
    }

    public boolean isStoredOnHSM() {
        Boolean storedOnHSM = this.cert.isStoredOnHSM();
        if (storedOnHSM != null) {
            return storedOnHSM;
        }
        return false;
    }

    public boolean isDefaultSslServerRuntime() {
        return this.defaultSslServerRuntime;
    }

    public void setDefaultSslServerRuntime(boolean defaultSslServerRuntime) {
        this.defaultSslServerRuntime = defaultSslServerRuntime;
    }

    public boolean isDefaultSslServerAdmin() {
        return this.defaultSslServerAdmin;
    }

    public void setDefaultSslServerAdmin(boolean defaultSslServerAdmin) {
        this.defaultSslServerAdmin = defaultSslServerAdmin;
    }
}

