/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.crypto.CertificateType;
import java.util.HashMap;
import java.util.Map;

public interface CertificateTypes {

    public static enum KeyAlgorithms {
        RSA,
        DSA,
        EC;

    }

    public static enum ValidTypes {
        dsigVerificationCert,
        dsigSigningCert,
        sslCertAuth,
        sslCertVerification,
        trustedCAs,
        sslServerCerts,
        xmlEncryptionCert,
        xmlDecryptionCert,
        ocspDsigVerificationCert,
        wsTrustDsigVerificationCert;

        static final Map<CertificateType, ValidTypes> CERT_NOTIFICATION_TYPE_MAP;

        public static ValidTypes getCertType(CertificateType type) {
            return CERT_NOTIFICATION_TYPE_MAP.get(type);
        }

        static {
            CERT_NOTIFICATION_TYPE_MAP = new HashMap<CertificateType, ValidTypes>();
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.OCSP_DSIG_VERIFICATION, ocspDsigVerificationCert);
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.SSL_SERVER, sslServerCerts);
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.SSL_CLIENT, sslCertAuth);
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.DIGITAL_SIGNATURE_DECRYPTION, dsigSigningCert);
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.TRUSTED_CA, trustedCAs);
            CERT_NOTIFICATION_TYPE_MAP.put(CertificateType.STS_CLIENT_AUTH, wsTrustDsigVerificationCert);
        }
    }
}

