/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CheckboxModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<CheckboxItem> items = new ArrayList<CheckboxItem>();

    public CheckboxModel() {
    }

    public CheckboxModel(CheckboxModel cbm) {
        for (CheckboxItem cbi : cbm.getCheckboxItems()) {
            this.items.add(new CheckboxItem(cbi));
        }
    }

    public List<CheckboxItem> getCheckboxItems() {
        return this.items;
    }

    public void setCheckboxItems(List<CheckboxItem> items) {
        this.items = items;
    }

    public void add(String name) {
        this.add(name, false, false);
    }

    public void add(String name, boolean enableSubmitOnChange) {
        this.add(name, enableSubmitOnChange, false);
    }

    public void add(String name, boolean enableSubmitOnChange, boolean checked) {
        if (this.items == null) {
            this.items = new ArrayList<CheckboxItem>();
        }
        this.items.add(new CheckboxItem(name, enableSubmitOnChange, checked));
    }

    public void add(String name, boolean enableSubmitOnChange, boolean checked, boolean disabled) {
        if (this.items == null) {
            this.items = new ArrayList<CheckboxItem>();
        }
        this.items.add(new CheckboxItem(name, enableSubmitOnChange, checked, disabled));
    }

    public void addFirst(String name, boolean enableSubmitOnChange, boolean checked) {
        if (this.items == null) {
            this.items = new ArrayList<CheckboxItem>();
        }
        this.items.add(0, new CheckboxItem(name, enableSubmitOnChange, checked));
    }

    public boolean remove(String name) {
        boolean result = false;
        if (this.items != null) {
            Iterator<CheckboxItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                CheckboxItem item = iterator.next();
                if (!item.getName().equals(name)) continue;
                iterator.remove();
            }
        }
        return result;
    }

    public List<String> getSelectedNames() {
        ArrayList<String> selectedNames = new ArrayList<String>();
        if (this.items != null) {
            for (CheckboxItem item : this.items) {
                if (!item.isChecked()) continue;
                selectedNames.add(item.getName());
            }
        }
        return selectedNames;
    }

    public void updateCheckedListInPlace(List<String> checkList, List<String> checkedList, boolean enableSubmitOnChange) {
        HashSet<String> checkedItemsSet = new HashSet<String>();
        if (checkedList == null) {
            checkedItemsSet.addAll(this.getSelectedNames());
        } else {
            checkedItemsSet.addAll(checkedList);
        }
        if (this.items == null) {
            this.items = new ArrayList<CheckboxItem>();
        } else {
            this.clear();
        }
        for (String item : checkList) {
            this.items.add(new CheckboxItem(item, enableSubmitOnChange, checkedItemsSet.contains(item)));
        }
    }

    public boolean anySelected() {
        if (this.items != null) {
            for (CheckboxItem item : this.items) {
                if (!item.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    public void unSelectAll() {
        if (this.items != null) {
            for (CheckboxItem item : this.items) {
                item.setChecked(false);
            }
        }
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    public void setChecked(String name) {
        if (this.items != null) {
            for (CheckboxItem item : this.items) {
                if (!item.getName().equals(name)) continue;
                item.setChecked(true);
                break;
            }
        }
    }

    public void sortAlphabetically() {
        Collections.sort(this.items);
    }
}

