/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.request.IUploadFile;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.UploadFileFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class FieldItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20050515L;
    static final transient Log log = LogFactory.getLog(FieldItem.class);
    private static final String ENCRYPTED_FIELD_VALUE = "*****";
    private static final String FILE_UPLOADED_MESSAGE = "[File uploaded]";
    private transient FieldDescriptor fieldDescriptor;
    private String value;
    private String hashValue;
    private String inheritedValue;
    private boolean overridesParent = true;
    private boolean oldOverridesParent = true;
    private transient IUploadFile file;
    private boolean isAdvanced;

    public FieldItem(FieldDescriptor fieldDescriptor) {
        this.fieldDescriptor = fieldDescriptor;
    }

    public FieldItem(FieldDescriptor fieldDescriptor, FieldItem sourceItem) {
        this.fieldDescriptor = fieldDescriptor;
        this.value = sourceItem.value;
        this.inheritedValue = sourceItem.inheritedValue;
        this.overridesParent = sourceItem.overridesParent;
        this.oldOverridesParent = sourceItem.oldOverridesParent;
        this.file = sourceItem.file;
        this.isAdvanced = sourceItem.isAdvanced;
        this.hashValue = sourceItem.hashValue;
    }

    public FieldItem clone() {
        try {
            return (FieldItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e);
            return new FieldItem(this.fieldDescriptor);
        }
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        if (this.isUploadFile() && this.value == null && this.file != null && this.file.getSize() > 0L) {
            InputStream stream = this.file.getStream();
            byte[] bytes = new byte[(int)this.file.getSize()];
            try {
                int numRead;
                for (int offset = 0; offset < bytes.length && (numRead = stream.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            catch (IOException e) {
                log.error((Object)"Unexpected problem uploading file.", (Throwable)e);
            }
            finally {
                Closer.close((Closeable)stream);
            }
            this.value = this.isUploadFileEncrypted() ? Obfuscator.obfuscateBinary((byte[])bytes) : B64.encode((byte[])bytes);
        }
        return this.value;
    }

    public String getFileName() {
        String fileName = new String();
        if (StringUtils.isNotBlank((String)this.value)) {
            fileName = this.file != null ? this.file.getFileName() : FILE_UPLOADED_MESSAGE;
        }
        return fileName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public boolean hasHashValue() {
        return this.hashValue != null;
    }

    public boolean isTextField() {
        return this.fieldDescriptor instanceof TextFieldDescriptor || this.fieldDescriptor instanceof HashedTextFieldDescriptor;
    }

    public boolean isEncrypted() {
        if (this.fieldDescriptor instanceof TextFieldDescriptor) {
            TextFieldDescriptor textFieldDescriptor = (TextFieldDescriptor)this.fieldDescriptor;
            return textFieldDescriptor.isEncrypted();
        }
        return this.fieldDescriptor instanceof HashedTextFieldDescriptor;
    }

    public boolean isTextAreaField() {
        return this.fieldDescriptor instanceof TextAreaFieldDescriptor;
    }

    public boolean isSelectField() {
        return this.fieldDescriptor instanceof SelectFieldDescriptor;
    }

    public boolean isFilterableSelectionField() {
        return this.fieldDescriptor instanceof FilterableSelectionFieldDescriptor && !(this.fieldDescriptor instanceof PingOneEnvironmentFieldDescriptor);
    }

    public boolean isPingOneEnvironmentSelectionField() {
        return this.fieldDescriptor instanceof PingOneEnvironmentFieldDescriptor;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        if (this.isFilterableSelectionField() || this.isPingOneEnvironmentSelectionField()) {
            return ((FilterableSelectionFieldDescriptor)this.fieldDescriptor).getSearchableTypes();
        }
        return Collections.emptyList();
    }

    public String getSelectedFilterableFieldItemDisplayName() {
        return this.fieldDescriptor.getFormattedValue(this.value);
    }

    public void setSelectedFilterableFieldItemDisplayName(String value) {
    }

    public String getSelectedFilterableFieldValue() {
        if (this.isFilterableSelectionField() || this.isPingOneEnvironmentSelectionField()) {
            return this.value;
        }
        return "";
    }

    public boolean doesFilterFieldHaveValue() {
        String value = this.getSelectedFilterableFieldValue();
        return StringUtils.isNotBlank((String)value);
    }

    public boolean isFilterFieldDisabled() {
        return !this.overridesParent;
    }

    public void setSelectedFilterableFieldValue(String selectedTypeAndId) {
        if ((this.isFilterableSelectionField() || this.isPingOneEnvironmentSelectionField()) && ((FilterableSelectionFieldDescriptor)this.fieldDescriptor).isValidFormat(selectedTypeAndId)) {
            this.value = ((FilterableSelectionFieldDescriptor)this.fieldDescriptor).parseSelectedValueForStorage(selectedTypeAndId);
        }
    }

    public IPropertySelectionModel getSelectOptions() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        if (this.isSelectField()) {
            SelectFieldDescriptor selectFieldDescriptor = (SelectFieldDescriptor)this.fieldDescriptor;
            for (AbstractSelectionFieldDescriptor.OptionValue optionValue : selectFieldDescriptor.getOptionValues()) {
                model.add(optionValue.getName(), optionValue.getValue());
            }
        }
        return model;
    }

    public boolean isRadioGroup() {
        return this.fieldDescriptor instanceof RadioGroupFieldDescriptor;
    }

    public boolean isCheckBox() {
        return this.fieldDescriptor instanceof CheckBoxFieldDescriptor;
    }

    public void setCheckBoxSelected(boolean selected) {
        this.value = Boolean.toString(selected);
    }

    public boolean isCheckBoxSelected() {
        return Boolean.parseBoolean(this.value);
    }

    public boolean isUploadFile() {
        return this.fieldDescriptor instanceof UploadFileFieldDescriptor;
    }

    public boolean isUploadFileEncrypted() {
        if (this.fieldDescriptor instanceof UploadFileFieldDescriptor) {
            return ((UploadFileFieldDescriptor)this.fieldDescriptor).isEncryptedFile();
        }
        return false;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public void setAdvanced(boolean advanced) {
        this.isAdvanced = advanced;
    }

    public IUploadFile getFile() {
        return this.file;
    }

    public void setFile(IUploadFile file) {
        if (file != null && file.getSize() > 0L) {
            this.value = null;
            this.file = file;
        }
    }

    public boolean isRequiredField() {
        for (FieldDescriptor.FieldValidationWrapper validationWrapper : this.fieldDescriptor.getValidationChain()) {
            if (!(validationWrapper.getValidator() instanceof RequiredFieldValidator)) continue;
            return true;
        }
        return false;
    }

    public boolean isHidden() {
        return this.fieldDescriptor.isHidden();
    }

    public String toString() {
        if (this.isUploadFile()) {
            String fileName = this.getFileName();
            return fileName;
        }
        if (this.isEncrypted()) {
            return ENCRYPTED_FIELD_VALUE;
        }
        if (this.getFieldDescriptor() != null) {
            return this.getFieldDescriptor().getFormattedValue(this.getValue());
        }
        return this.getValue();
    }

    public boolean isOverridesParent() {
        return this.overridesParent;
    }

    public void setOverridesParent(boolean overridesParent) {
        this.overridesParent = overridesParent;
        if (!overridesParent) {
            this.value = this.inheritedValue;
        }
    }

    public void setRawOverridesParent(boolean overridesParent) {
        this.overridesParent = overridesParent;
    }

    public void setInheritedValue(String inheritedValue) {
        this.inheritedValue = inheritedValue;
    }

    public boolean isDisabled() {
        boolean tempValue = this.oldOverridesParent;
        this.oldOverridesParent = this.overridesParent;
        if (tempValue != this.overridesParent) {
            return true;
        }
        return !this.overridesParent;
    }
}

