/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import java.io.Serializable;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;

public class WsTrustListUIEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String entry;
    private boolean active = true;
    private Cert cert;

    public WsTrustListUIEntry() {
    }

    public WsTrustListUIEntry(String subjectDn) {
        this.entry = subjectDn;
    }

    public WsTrustListUIEntry(WsTrustListUIEntry itemToCopy) {
        this.entry = itemToCopy.getEntry();
    }

    public String getStatusCssClass() {
        if (CertificateHelper.isKnownToBeRevoked((Cert)this.cert)) {
            return "revoked";
        }
        if (this.isCertExpired()) {
            return "expired";
        }
        if (this.isCertNotYetValid()) {
            return "notyetvalid";
        }
        return "active";
    }

    public boolean isCertExpired() {
        try {
            if (this.cert != null) {
                this.cert.getX509Certificate().checkValidity(new Date());
                return false;
            }
        }
        catch (CertificateExpiredException cee) {
            return true;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        return false;
    }

    public boolean isCertNotYetValid() {
        try {
            if (this.cert != null) {
                this.cert.getX509Certificate().checkValidity(new Date());
                return false;
            }
        }
        catch (CertificateNotYetValidException cnyve) {
            return true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            // empty catch block
        }
        return false;
    }

    public boolean isKnownToBeRevoked() {
        return CertificateHelper.isKnownToBeRevoked((Cert)this.cert);
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Cert getCert() {
        return this.cert;
    }

    public void setCert(Cert cert) {
        this.cert = cert;
    }

    public boolean equals(Object o) {
        return this.entry.equals(((WsTrustListUIEntry)o).getEntry());
    }

    public int hashCode() {
        int result = this.entry.hashCode();
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.cert != null ? this.cert.hashCode() : 0);
        return result;
    }
}

