/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AdapterSelectorManagementTasklet
extends PluginInstanceTasklet {
    private static final long serialVersionUID = 20050127L;
    public static final String MENU_NAME = "Create Authentication Selector Instance";
    private static final DependencyErrorManager dependencyManager = MgmtFactory.getDependencyErrorManager();

    public AdapterSelectorManagementTasklet(Visit visit) {
        super("AdapterSelectorManagementTasklet", MENU_NAME, visit);
        this.setMenuName(MENU_NAME);
        this.configureAdapterState.setMenuName("Authentication Selector");
        this.createAdapterContractState.setMenuName("Selector Result Values");
        this.createAdapterContractState.setExtendedContractLabel("Result Values");
        this.createAdapterContractState.setDisplayCoreContract(false);
        this.setFinishAvailable(false);
    }

    @Override
    public boolean isItInUse() {
        return MgmtFactory.getAuthnSelectionConfigManager().isAuthnSelectorInUse(this.getPluginId()) || MgmtFactory.getPolicyFragmentManager().isAuthnSelectorInUse(this.getPluginId());
    }

    @Override
    public boolean save(Object instance) {
        boolean result = super.save(instance);
        if (this.isSaveCalled()) {
            if (result && instance instanceof AuthnSelectorInstance) {
                dependencyManager.remove(((AuthnSelectorInstance)instance).getId(), AffectedItemType.AUTHENTICATION_SELECTOR);
            }
            DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.AUTHN_POLICY_ATTRS);
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.FRAGMENT_ATTRS);
        }
        return result;
    }
}

