/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.IdpAdapterMappingState;
import com.pingidentity.fsm.state.impl.SelectSpAccountLinkingState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsFedIdentityMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AuthnSourceListApi;
import com.pingidentity.fsm.tasklet.data.SPNameIdentifierMappingType;
import com.pingidentity.fsm.tasklet.data.WsFedNameIdentifierMappingType;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigC2cMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class AssertionCreationTasklet
extends MultiProtocolTasklet
implements AttributeNamesApi,
AccountLinkingApi,
AuthnSourceListApi {
    private static final long serialVersionUID = 20050515L;
    private static final String SAML_SUBJECT = "SAML_SUBJECT";
    final WsFedIdentityMappingState wsFedIdentityMappingState;
    final CreateAttributeContractState createAttributeContractState;
    final SelectSpAccountLinkingState selectSpAccountLinkingState;
    final IdpAdapterMappingState idpAdapterMappingState;
    final SummaryCardState summaryCardState;

    public AssertionCreationTasklet(Visit visit) {
        super("AssertionCreationTasklet", "Assertion Creation");
        this.setSystemVisit(visit);
        this.wsFedIdentityMappingState = new WsFedIdentityMappingState(this);
        this.createAttributeContractState = new CreateAttributeContractState(this);
        this.selectSpAccountLinkingState = new SelectSpAccountLinkingState(this);
        this.idpAdapterMappingState = new IdpAdapterMappingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        SpConnection spConnection = new SpConnection();
        this.save(spConnection);
        this.setPopulateData(spConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void configureTasklet() {
        boolean isWsFedJwt;
        Tasklet parentTasklet = this.getParentTasklet();
        boolean bl = isWsFedJwt = parentTasklet != null && parentTasklet instanceof SpBrowserSsoTasklet && ((SpBrowserSsoTasklet)parentTasklet).isWsFedJwt();
        if (Protocol.WSFED.equals((Object)this.getProtocolType())) {
            this.wsFedIdentityMappingState.addOutgoingTransition(this, this.createAttributeContractState);
            this.createAttributeContractState.addOutgoingTransition(this, this.idpAdapterMappingState);
            this.createAttributeContractState.updateKeyContext(isWsFedJwt);
            this.idpAdapterMappingState.addOutgoingTransition(this, this.summaryCardState);
            if (isWsFedJwt) {
                this.setInitialState(this.createAttributeContractState);
                this.setMenuName("JWT Creation");
                this.summaryCardState.setKeyContext("jwt");
            } else {
                this.setInitialState(this.wsFedIdentityMappingState);
                this.setMenuName("Assertion Creation");
                this.summaryCardState.setKeyContext(null);
            }
        } else {
            this.selectSpAccountLinkingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idpAdapterMappingState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return (AssertionCreationTasklet.this.isAccountLinkingEnabled() || AssertionCreationTasklet.this.isTransientIdentifierEnabled()) && AssertionCreationTasklet.this.hasAdditionalAttributes();
                }
            });
            this.selectSpAccountLinkingState.addOutgoingTransition(this, this.createAttributeContractState);
            this.createAttributeContractState.addOutgoingTransition(this, this.idpAdapterMappingState);
            this.idpAdapterMappingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return AssertionCreationTasklet.this.isConnectionProtocol1x();
                }
            });
            this.idpAdapterMappingState.addOutgoingTransition(this, this.summaryCardState);
            this.setInitialState(this.selectSpAccountLinkingState);
        }
    }

    @Override
    public Protocol getProtocolType() {
        return ((MultiProtocolTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        if (this.findState(this.createAttributeContractState.getStateName()) != null) {
            return this.createAttributeContractState.getContract().getAllAttrNamesSorted();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        if (this.findState(this.createAttributeContractState.getStateName()) != null) {
            return this.createAttributeContractState.getContract().getSortedImmutableAttributeNames();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        if (this.findState(this.createAttributeContractState.getStateName()) != null) {
            return this.createAttributeContractState.getContract().getSortedMutableAttributeNames();
        }
        return new ArrayList<String>();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        if (this.findState(this.createAttributeContractState.getStateName()) != null) {
            return this.createAttributeContractState.getContract().getAllAttributeNames();
        }
        return new HashSet<String>();
    }

    @Override
    public boolean isAccountLinkingEnabled() {
        return this.selectSpAccountLinkingState.getNameIdentifierMappingType() == SPNameIdentifierMappingType.PSEUDONYM;
    }

    @Override
    public boolean isTransientIdentifierEnabled() {
        return this.selectSpAccountLinkingState.getNameIdentifierMappingType() == SPNameIdentifierMappingType.TRANSIENT;
    }

    @Override
    public boolean hasAdditionalAttributes() {
        return !this.selectSpAccountLinkingState.getNoAddlTransientAttrs() && !this.selectSpAccountLinkingState.getNoAddlPseudonymAttrs();
    }

    @Override
    public StringPairPropertySelectionModel getAdapterList() {
        StringPairPropertySelectionModel adapterList = new StringPairPropertySelectionModel(true);
        IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
        List<SpConfigAdapterMappingTasklet> tasklets = this.idpAdapterMappingState.getAdapterTasklets();
        ArrayList<ConfigurablePluginInstance> connectionBasedRelatedPlugins = new ArrayList<ConfigurablePluginInstance>();
        for (IdpAuthnAdapterInstance adapter : idpAdapterManager.getInstances()) {
            String parentId;
            ConfigurablePluginInstance parentInstance;
            boolean adapterInUse = this.adapterInUseByThisConnection(adapter, tasklets);
            if (adapterInUse && adapter.isConnectionBasedPlugin() && (parentInstance = idpAdapterManager.getInstance(parentId = adapter.getParentId())) != null) {
                connectionBasedRelatedPlugins.add(parentInstance);
            }
            if (adapterInUse || adapter.isConnectionBasedPlugin()) continue;
            adapterList.add(adapter.getName(), adapter);
        }
        for (ConfigurablePluginInstance instance : connectionBasedRelatedPlugins) {
            adapterList.remove(instance.getName());
        }
        adapterList.sort();
        return adapterList;
    }

    private boolean adapterInUseByThisConnection(IdpAuthnAdapterInstance adapter, List<SpConfigAdapterMappingTasklet> tasklets) {
        if (tasklets != null) {
            for (SpConfigAdapterMappingTasklet t : tasklets) {
                AuthnAdapterInstance instance = t.getSelectedAdapter();
                if (instance == null || !adapter.getId().equals(instance.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public String getIdentityMapping() {
        if (Protocol.WSFED.equals((Object)this.getProtocolType())) {
            if (this.wsFedIdentityMappingState != null) {
                WsFedNameIdentifierMappingType nameIdentifierMappingType = this.wsFedIdentityMappingState.getNameIdentifierMappingType();
                switch (nameIdentifierMappingType) {
                    case EMAIL_ADDR: {
                        return "Email Address";
                    }
                    case PRINCIPAL_NAME: {
                        return "User Principal Name";
                    }
                    case COMMON_NAME: {
                        return "Common Name";
                    }
                }
            }
        } else if (this.selectSpAccountLinkingState != null) {
            SPNameIdentifierMappingType nameIdentifierMappingType = this.selectSpAccountLinkingState.getNameIdentifierMappingType();
            switch (nameIdentifierMappingType) {
                case PSEUDONYM: {
                    return "Pseudonym";
                }
                case TRANSIENT: {
                    return "Transient";
                }
                case STANDARD: {
                    return "Standard";
                }
            }
        }
        return "Not Configured";
    }

    public List<String> getAttributeContractItems() {
        ArrayList<String> attributeContractList = new ArrayList<String>();
        if (this.createAttributeContractState != null) {
            Object item;
            int i;
            AttributeContract attributeContract = this.createAttributeContractState.getContract();
            List sortedImmutableAttrNames = attributeContract.getSortedImmutableAttributeNames();
            List sortedMutableAttrNames = attributeContract.getSortedMutableAttributeNames();
            if (!Protocol.WSFED.equals((Object)this.getProtocolType()) && !"Standard".equals(this.getIdentityMapping())) {
                sortedImmutableAttrNames.remove(SAML_SUBJECT);
                sortedMutableAttrNames.remove(SAML_SUBJECT);
            }
            for (i = 0; i < sortedImmutableAttrNames.size(); ++i) {
                item = (String)sortedImmutableAttrNames.get(i);
                if (i < sortedImmutableAttrNames.size() - 1 || sortedMutableAttrNames.size() > 0) {
                    item = ((String)item).trim() + ", ";
                }
                attributeContractList.add((String)item);
            }
            for (i = 0; i < sortedMutableAttrNames.size(); ++i) {
                item = (String)sortedMutableAttrNames.get(i);
                if (i < sortedMutableAttrNames.size() - 1) {
                    item = ((String)item).trim() + ", ";
                }
                attributeContractList.add((String)item);
            }
        }
        return attributeContractList;
    }

    public boolean isAdditionalAttributesRequired() {
        return this.selectSpAccountLinkingState.getNoAddlPseudonymAttrs() || this.selectSpAccountLinkingState.getNoAddlTransientAttrs();
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        List<SpAuthnSourceMappingTasklet> mappingTasklets = this.idpAdapterMappingState.getAdapterTasklets();
        if (mappingTasklets != null) {
            for (SpAuthnSourceMappingTasklet mappingTasklet : mappingTasklets) {
                mappingTasklet.cleanAttributeMappings(attributeContract);
            }
        }
        if ((mappingTasklets = this.idpAdapterMappingState.getC2cTasklets()) != null) {
            for (SpAuthnSourceMappingTasklet mappingTasklet : mappingTasklets) {
                mappingTasklet.cleanAttributeMappings(attributeContract);
            }
        }
    }

    public void refreshStatesAfterMappingChange() {
        this.createAttributeContractState.refreshState();
        this.cleanAttributeMappings(this.getAllAttributeNames());
    }

    @Override
    public StringPairPropertySelectionModel getC2cContractList() {
        StringPairPropertySelectionModel contractList = new StringPairPropertySelectionModel(true);
        HashMap<String, String> contractNames2Id = new HashMap<String, String>();
        for (C2cContract c2cContract : MgmtFactory.getC2cContractManager().getContracts()) {
            contractNames2Id.put(c2cContract.getName(), c2cContract.getId());
        }
        for (SpConfigC2cMappingTasklet spConfigC2cMappingTasklet : this.idpAdapterMappingState.getC2cTasklets()) {
            spConfigC2cMappingTasklet.refreshName();
        }
        for (SpConfigC2cMappingTasklet spConfigC2cMappingTasklet : this.idpAdapterMappingState.getC2cTasklets()) {
            contractNames2Id.remove(spConfigC2cMappingTasklet.getContractName());
        }
        for (Map.Entry entry : contractNames2Id.entrySet()) {
            contractList.add((String)entry.getKey(), entry.getValue());
        }
        contractList.sort();
        return contractList;
    }

    public List<SpConfigC2cMappingTasklet> getC2cTasklets() {
        return this.idpAdapterMappingState.getC2cTasklets();
    }
}

